/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.lang.javascript.flex.actions.ExternalTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AdtTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DeviceInfo {
    public final int IOS_HANDLE;
    public final String IOS_DEVICE_CLASS;
    public final String DEVICE_ID;
    public final String DEVICE_NAME;

    private DeviceInfo(int iosHandle, String iosDeviceClass, String deviceId, String deviceName) {
        this.IOS_HANDLE = iosHandle;
        this.IOS_DEVICE_CLASS = iosDeviceClass;
        this.DEVICE_ID = deviceId;
        this.DEVICE_NAME = deviceName;
    }

    public static List<DeviceInfo> getAndroidDevices(Project project, final Sdk sdk) {
        final ArrayList<DeviceInfo> result = new ArrayList<DeviceInfo>();
        ExternalTask.runWithProgress(new ExternalTask(project, sdk){

            @Override
            protected List<String> createCommandLine() {
                ArrayList<String> command = new ArrayList<String>();
                command.add(sdk.getHomePath() + AirPackageUtil.ADB_RELATIVE_PATH);
                command.add("devices");
                return command;
            }

            @Override
            protected boolean checkMessages() {
                if (this.myMessages.size() < 2) {
                    return true;
                }
                if (!((String)this.myMessages.get(0)).trim().contains("List of devices attached")) {
                    return true;
                }
                for (int i = 1; i < this.myMessages.size(); ++i) {
                    String line = ((String)this.myMessages.get(i)).trim();
                    if (line.isEmpty()) continue;
                    int index = StringUtil.indexOfAny((String)line, (String)" \t");
                    if (index > 0) {
                        result.add(new DeviceInfo(-1, null, line.substring(0, index), line.substring(index).trim()));
                        continue;
                    }
                    result.add(new DeviceInfo(-1, null, line, "unnamed"));
                }
                return true;
            }
        }, "Looking for Android devices", "Looking for Android devices");
        return result;
    }

    public static List<DeviceInfo> getIosDevices(Project project, Sdk sdk) {
        final ArrayList<DeviceInfo> result = new ArrayList<DeviceInfo>();
        ExternalTask.runWithProgress(new AdtTask(project, sdk){

            @Override
            protected void appendAdtOptions(List<String> command) {
                command.add("-devices");
                command.add("-platform");
                command.add("ios");
            }

            @Override
            protected boolean checkMessages() {
                if (this.myMessages.size() < 3) {
                    return true;
                }
                if (!((String)this.myMessages.get(0)).trim().startsWith("List of attached devices")) {
                    return true;
                }
                if (!((String)this.myMessages.get(1)).trim().startsWith("Handle")) {
                    return true;
                }
                for (int i = 2; i < this.myMessages.size(); ++i) {
                    String line = ((String)this.myMessages.get(i)).trim();
                    int handle = -1;
                    String deviceClass = "";
                    String deviceId = "";
                    String deviceName = "";
                    StringTokenizer tokenizer = new StringTokenizer(line, " \t");
                    if (tokenizer.hasMoreTokens()) {
                        try {
                            handle = Integer.parseInt(tokenizer.nextToken());
                        }
                        catch (NumberFormatException e) {
                            return true;
                        }
                    }
                    if (tokenizer.hasMoreTokens()) {
                        deviceClass = tokenizer.nextToken();
                    }
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.length() >= 24) {
                            deviceId = token;
                            break;
                        }
                        deviceClass = deviceClass + " " + token;
                    }
                    while (tokenizer.hasMoreTokens()) {
                        if (!deviceName.isEmpty()) {
                            deviceName = deviceName + " ";
                        }
                        deviceName = deviceName + tokenizer.nextToken();
                    }
                    if (handle < 0 || deviceId.length() <= 0) {
                        return true;
                    }
                    result.add(new DeviceInfo(handle, deviceClass, deviceId, deviceName));
                }
                return true;
            }
        }, "Looking for iOS devices", "Looking for iOS devices");
        return result;
    }
}

