/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.validation.ActionScriptUnusedImportsHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ActionScriptUnusedImportsPassFactory
implements TextEditorHighlightingPassFactory {
    public ActionScriptUnusedImportsPassFactory(TextEditorHighlightingPassRegistrar registrar) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            ActionScriptUnusedImportsPassFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ActionScriptUnusedImportsPassFactory.$$$reportNull$$$0(1);
        }
        if (file instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file) || file instanceof JSFile && !(file instanceof PsiCompiledElement) && file.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            HighlightDisplayKey key = HighlightDisplayKey.find((String)JSUnusedLocalSymbolsInspection.SHORT_NAME);
            if (InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile().isToolEnabled(key, (PsiElement)file)) {
                return new ActionScriptUnusedImportsHighlightingPass(file, editor);
            }
        }
        return null;
    }

    private static IntentionAction createOptimizeImportsIntention() {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = JSBundle.message((String)"javascript.fix.optimize.imports", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(final @NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                ECMAScriptImportOptimizer optimizer = new ECMAScriptImportOptimizer();
                final Runnable runnable = optimizer.processFile(file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(project, runnable, this.getFamilyName(), (Object)this);
                    }
                });
            }

            public boolean startInWriteAction() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public String getComponentName() {
        if ("ActionScript.UnusedImportReporter" == null) {
            ActionScriptUnusedImportsPassFactory.$$$reportNull$$$0(2);
        }
        return "ActionScript.UnusedImportReporter";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionScriptUnusedImportsHighlightingPass
    extends TextEditorHighlightingPass {
        private Collection<JSImportStatement> importStatements;
        private Collection<JSReferenceExpression> fqnsToReplaceWithShortName;
        private final PsiFile myFile;

        public ActionScriptUnusedImportsHighlightingPass(PsiFile file, Editor editor) {
            super(file.getProject(), editor.getDocument(), true);
            this.myFile = file;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                ActionScriptUnusedImportsHighlightingPass.$$$reportNull$$$0(0);
            }
            if (this.myFile instanceof JSExpressionCodeFragment) {
                this.importStatements = Collections.emptyList();
                this.fqnsToReplaceWithShortName = Collections.emptyList();
            } else {
                ActionScriptUnusedImportsHelper.Results results = ActionScriptUnusedImportsHelper.getUnusedImports((PsiFile)this.myFile);
                this.importStatements = results.unusedImports;
                this.fqnsToReplaceWithShortName = results.fqnsToReplaceWithShortName;
            }
        }

        public void doApplyInformationToEditor() {
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), this.getHighlights(), (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }

        private List<HighlightInfo> getHighlights() {
            AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(this.myFile));
            ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.importStatements.size() + this.fqnsToReplaceWithShortName.size());
            IntentionAction action = ActionScriptUnusedImportsPassFactory.createOptimizeImportsIntention();
            ActionScriptUnusedImportsHighlightingPass.createHighlights(this.importStatements, (AnnotationHolder)annotationHolder, action, JSBundle.message((String)"javascript.validation.unused.import", (Object[])new Object[0]), infos, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            ActionScriptUnusedImportsHighlightingPass.createHighlights(this.fqnsToReplaceWithShortName, (AnnotationHolder)annotationHolder, action, JSBundle.message((String)"javascript.validation.fqn.to.replace.with.import", (Object[])new Object[0]), infos, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return infos;
        }

        private static void createHighlights(Collection<? extends JSElement> elements, AnnotationHolder annotationHolder, IntentionAction action, String message, List<HighlightInfo> result, @NotNull ProblemHighlightType type) {
            if (type == null) {
                ActionScriptUnusedImportsHighlightingPass.$$$reportNull$$$0(1);
            }
            for (JSElement jSElement : elements) {
                TextRange range = InjectedLanguageManager.getInstance((Project)jSElement.getProject()).injectedToHost((PsiElement)jSElement, jSElement.getTextRange());
                if (range.isEmpty()) continue;
                Annotation annotation = annotationHolder.createWarningAnnotation(range, message);
                annotation.setHighlightType(type);
                annotation.registerFix(action);
                result.add(HighlightInfo.fromAnnotation((Annotation)annotation));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/flex/ActionScriptUnusedImportsPassFactory$ActionScriptUnusedImportsHighlightingPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlights";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

