/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.moveMembers;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMoveMembersOptions;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.MoveMemberViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptMoveMembersProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)ActionScriptMoveMembersProcessor.class.getName());
    private final JSClass myTargetClass;
    private final Set<JSAttributeListOwner> myMembersToMove = new LinkedHashSet<JSAttributeListOwner>();
    private final MoveCallback myMoveCallback;
    private final JSClass mySourceClass;
    @Nullable
    private final String myNewVisibility;
    private String myCommandName = JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]);

    public ActionScriptMoveMembersProcessor(Project project, MoveCallback moveCallback, JSClass sourceClass, GlobalSearchScope scope, JSMoveMembersOptions options) {
        super(project);
        this.myMoveCallback = moveCallback;
        this.mySourceClass = sourceClass;
        Object[] members = options.getSelectedMembers();
        this.myMembersToMove.clear();
        ContainerUtil.addAll(this.myMembersToMove, (Object[])members);
        this.myTargetClass = (JSClass)JSDialectSpecificHandlersFactory.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(options.getTargetClassName(), scope);
        this.setCommandName(sourceClass, (PsiElement[])members);
        this.myNewVisibility = options.getMemberVisibility();
    }

    @NotNull
    protected String getCommandName() {
        String string = this.myCommandName;
        if (string == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void setCommandName(JSClass sourceClass, PsiElement[] members) {
        StringBuilder commandName = new StringBuilder();
        commandName.append(MoveHandler.REFACTORING_NAME);
        commandName.append(" ");
        boolean first = true;
        for (PsiElement member : members) {
            if (member instanceof JSFunction && ((JSFunction)member).isSetProperty() && sourceClass.findFunctionByNameAndKind(((JSFunction)member).getName(), JSFunction.FunctionKind.GETTER) != null) continue;
            if (!first) {
                commandName.append(", ");
            }
            commandName.append(new JSNamedElementPresenter(member).getShortName());
            if (member instanceof JSFunction) {
                commandName.append("()");
            }
            first = false;
        }
        this.myCommandName = commandName.toString();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(1);
        }
        MoveMemberViewDescriptor moveMemberViewDescriptor = new MoveMemberViewDescriptor(PsiUtilCore.toPsiElementArray(this.myMembersToMove));
        if (moveMemberViewDescriptor == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(2);
        }
        return moveMemberViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = JSRefactoringUtil.getUsages(this.myMembersToMove, (JSClass)this.myTargetClass);
        if (usageInfoArray == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(this.myMembersToMove.size() == elements.length);
        this.myMembersToMove.clear();
        for (PsiElement element : elements) {
            this.myMembersToMove.add((JSAttributeListOwner)element);
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(5);
        }
        try {
            Collection filesWithUsages = ActionScriptRefactoringUtil.qualifyIncomingReferences((UsageInfo[])usages);
            HashSet importsInTargetFile = new HashSet();
            HashSet namespacesInTargetFile = new HashSet();
            ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
            JSRefactoringUtil.addRemovalFormatters((JSClass)this.mySourceClass, this.myMembersToMove, (Condition)Conditions.alwaysTrue(), (Condition)Conditions.alwaysTrue(), postponedFormatters);
            for (JSAttributeListOwner member : this.myMembersToMove) {
                RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member);
                ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, this.myMembersToMove, (JSClass)this.myTargetClass, (boolean)false, (this.myNewVisibility != null && !"escalate".equals(this.myNewVisibility) ? 1 : 0) != 0);
                if (member instanceof JSVariable) {
                    ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)member.getAttributeList(), importsInTargetFile, namespacesInTargetFile, this.myMembersToMove, (JSClass)this.myTargetClass, (boolean)false, (this.myNewVisibility != null && !"escalate".equals(this.myNewVisibility) ? 1 : 0) != 0);
                }
                JSAttributeListOwner newMember = ActionScriptMoveMembersProcessor.doMove(member, this.myTargetClass, postponedFormatters);
                elementListener.elementMoved((PsiElement)newMember);
                this.fixVisibility(newMember, usages);
                postponedFormatters.add(FormatFixer.create((PsiElement)JSRefactoringUtil.getElementToFormat((PsiElement)newMember), (FormatFixer.Mode)FormatFixer.Mode.Reformat));
            }
            JSRefactoringUtil.postProcess((PsiElement)this.mySourceClass, (JSQualifiedNamedElement)this.myTargetClass, (Collection)filesWithUsages, importsInTargetFile, namespacesInTargetFile, postponedFormatters, (boolean)true, (boolean)false);
            this.myMembersToMove.clear();
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void fixVisibility(JSAttributeListOwner member, UsageInfo[] usages) throws IncorrectOperationException {
        JSAttributeList modifierList = member.getAttributeList();
        if (this.myNewVisibility == null) {
            return;
        }
        if ("escalate".equals(this.myNewVisibility)) {
            PsiElement place;
            UsageInfo usage;
            JSAttributeList.AccessType visibility = modifierList.getAccessType();
            UsageInfo[] usageInfoArray = usages;
            int n = usageInfoArray.length;
            for (int i = 0; !(i >= n || (usage = usageInfoArray[i]) instanceof JSMemberUsageInfo && (place = usage.getElement()) != null && (visibility = JSVisibilityUtil.getEscalatedVisibility((JSAttributeListOwner)member, (PsiElement)place, (JSAttributeList.AccessType)visibility, (JSVisibilityUtil.Options)JSVisibilityUtil.DEFAULT_OPTIONS)) == JSAttributeList.AccessType.PUBLIC); ++i) {
            }
            JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)member, (JSAttributeList.AccessType)visibility);
        } else {
            JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)member, (String)this.myNewVisibility);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(6);
        }
        if (this.myTargetClass == null) {
            return true;
        }
        MultiMap conflicts = new MultiMap();
        JSRefactoringConflictsUtil.checkMembersAlreadyExist(this.myMembersToMove, (JSClass)this.myTargetClass, (MultiMap)conflicts);
        for (JSAttributeListOwner member : this.myMembersToMove) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)member, this.myMembersToMove, (PsiElement)this.myTargetClass, (boolean)true, (MultiMap)conflicts, (Condition)Conditions.alwaysTrue(), (JSVisibilityUtil.Options)JSVisibilityUtil.DEFAULT_OPTIONS);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        JSRefactoringConflictsUtil.checkIncomingReferencesAccessibility((UsageInfo[])usages, (JSClass)this.myTargetClass, (String)this.myNewVisibility, (MultiMap)conflicts, (JSVisibilityUtil.Options)JSVisibilityUtil.DEFAULT_OPTIONS);
        JSRefactoringConflictsUtil.analyzeModuleConflicts((Project)this.myProject, this.myMembersToMove, (UsageInfo[])usages, (PsiElement)this.myTargetClass, (MultiMap)conflicts);
        return this.showConflicts(conflicts, usages);
    }

    public void doRun() {
        if (this.myMembersToMove.isEmpty()) {
            String message = RefactoringBundle.message((String)"no.members.selected");
            CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (String)message, null, (Project)this.myProject);
            return;
        }
        super.doRun();
    }

    public static JSAttributeListOwner doMove(@NotNull JSAttributeListOwner member, @NotNull JSClass targetClass, List<? super FormatFixer> formatters) {
        if (member == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(7);
        }
        if (targetClass == null) {
            ActionScriptMoveMembersProcessor.$$$reportNull$$$0(8);
        }
        Object insert = member instanceof JSFunction ? member.copy() : JSRefactoringUtil.getVarStatementCopy((JSVariable)((JSVariable)member));
        PsiElement inserted = JSRefactoringUtil.addMemberToTargetClass((JSClass)targetClass, (PsiElement)insert);
        formatters.add((FormatFixer)FormatFixer.create((PsiElement)inserted, (FormatFixer.Mode)FormatFixer.Mode.Reformat));
        JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)inserted, formatters);
        JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)member);
        return inserted instanceof JSFunction ? (JSAttributeListOwner)inserted : (JSAttributeListOwner)PsiTreeUtil.getChildOfType((PsiElement)inserted, JSVariable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/refactoring/moveMembers/ActionScriptMoveMembersProcessor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/refactoring/moveMembers/ActionScriptMoveMembersProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

