/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.maven;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.javascript.flex.maven.FlexConfigInformer;
import com.intellij.javascript.flex.maven.Flexmojos3GenerateConfigTask;
import com.intellij.javascript.flex.maven.FlexmojosImporter;
import com.intellij.javascript.flex.maven.RuntimeModulesGenerateConfigTask;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerProjectConfiguration;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.CompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkAdditionalData;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenLog;

public class Flexmojos3Configurator {
    private static final String FLEX_COMPILER_ADOBE_GROUP_ID = "com.adobe.flex";
    private static final String FLEX_COMPILER_APACHE_GROUP_ID = "org.apache.flex";
    private static final String FLEX_COMPILER_ARTIFACT_ID = "compiler";
    private static final Pattern[] ADDITIONAL_JAR_NAME_PATTERNS_TO_INCLUDE_IN_FLEXMOJOS_SDK_CLASSPATH = new Pattern[]{Pattern.compile("afe"), Pattern.compile("aglj[0-9]+"), Pattern.compile("flex-fontkit"), Pattern.compile("license"), Pattern.compile("rideau")};
    protected final Module myModule;
    private final IdeModifiableModelsProvider myModelsProvider;
    private final FlexProjectConfigurationEditor myFlexEditor;
    protected final MavenProjectsTree myMavenTree;
    protected final MavenProject myMavenProject;
    protected final MavenPlugin myFlexmojosPlugin;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final List<String> myCompiledLocales;
    private final List<String> myRuntimeLocales;
    private final FlexConfigInformer myInformer;

    public Flexmojos3Configurator(Module module, IdeModifiableModelsProvider modelsProvider, FlexProjectConfigurationEditor flexEditor, MavenProjectsTree mavenTree, Map<MavenProject, String> mavenProjectToModuleName, MavenProject mavenProject, MavenPlugin flexmojosPlugin, List<String> compiledLocales, List<String> runtimeLocales, FlexConfigInformer informer) {
        this.myModelsProvider = modelsProvider;
        this.myMavenTree = mavenTree;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.myCompiledLocales = compiledLocales;
        this.myRuntimeLocales = runtimeLocales;
        this.myModule = module;
        this.myFlexEditor = flexEditor;
        this.myMavenProject = mavenProject;
        this.myFlexmojosPlugin = flexmojosPlugin;
        this.myInformer = informer;
    }

    public void configureAndAppendTasks(List<MavenProjectsProcessorTask> postTasks) {
        Object[] oldBCs = this.myFlexEditor.getConfigurations(this.myModule);
        if (oldBCs.length == 1 && oldBCs[0].getName().equals("Unnamed")) {
            this.myFlexEditor.configurationRemoved((ModifiableFlexBuildConfiguration)oldBCs[0]);
        }
        String mainBCName = this.myModule.getName();
        ModifiableFlexBuildConfiguration existingBC = (ModifiableFlexBuildConfiguration)ContainerUtil.find((Object[])oldBCs, bc -> mainBCName.equals(bc.getName()));
        ModifiableFlexBuildConfiguration mainBC = this.setupMainBuildConfiguration(existingBC);
        Collection<Object> rlmInfos = FlexmojosImporter.isFlexApp(this.myMavenProject) ? this.getRLMInfos() : Collections.emptyList();
        for (RuntimeModulesGenerateConfigTask.RLMInfo rLMInfo : rlmInfos) {
            ModifiableFlexBuildConfiguration existingRlmBC = (ModifiableFlexBuildConfiguration)ContainerUtil.find((Object[])oldBCs, bc -> bc.getName().equals(info.myRLMName));
            this.configureRuntimeLoadedModule(mainBC, rLMInfo, existingRlmBC);
        }
        if (FlexCompilerProjectConfiguration.getInstance((Project)this.myModule.getProject()).GENERATE_FLEXMOJOS_CONFIGS) {
            if (StringUtil.compareVersionNumbers((String)this.myFlexmojosPlugin.getVersion(), (String)"3.4") >= 0) {
                this.appendGenerateConfigTask(postTasks, mainBC.getCompilerOptions().getAdditionalConfigFilePath());
                if (!rlmInfos.isEmpty()) {
                    postTasks.add((MavenProjectsProcessorTask)new RuntimeModulesGenerateConfigTask(this.myModule, this.myMavenProject, this.myMavenTree, mainBC.getCompilerOptions().getAdditionalConfigFilePath(), rlmInfos));
                }
            } else {
                this.myInformer.showFlexConfigWarningIfNeeded(this.myModule.getProject());
            }
        }
    }

    private ModifiableFlexBuildConfiguration setupMainBuildConfiguration(@Nullable ModifiableFlexBuildConfiguration existingBC) {
        OutputType outputType;
        boolean producesAirPackage;
        boolean isNewBC = existingBC == null;
        ModifiableFlexBuildConfiguration mainBC = isNewBC ? this.myFlexEditor.createConfiguration(this.myModule) : existingBC;
        mainBC.setName(this.myModule.getName());
        TargetPlatform guessedTargetPlatform = this.handleDependencies(mainBC);
        boolean bl = producesAirPackage = "air".equals(this.myMavenProject.getPackaging()) || Flexmojos3Configurator.containsSignAirGoal(this.myFlexmojosPlugin);
        if (isNewBC) {
            TargetPlatform targetPlatform = producesAirPackage ? TargetPlatform.Desktop : guessedTargetPlatform;
            mainBC.setTargetPlatform(targetPlatform);
            mainBC.setPureAs(false);
        }
        OutputType outputType2 = outputType = FlexmojosImporter.isFlexApp(this.myMavenProject) ? OutputType.Application : OutputType.Library;
        if ((outputType != OutputType.Application || mainBC.getOutputType() != OutputType.RuntimeLoadedModule) && outputType != mainBC.getOutputType()) {
            mainBC.setOutputType(outputType);
            FlexProjectConfigurationEditor.resetNonApplicableValuesToDefaults(mainBC);
        }
        Element configurationElement = this.myFlexmojosPlugin.getConfigurationElement();
        if (FlexmojosImporter.isFlexApp(this.myMavenProject)) {
            String sourceFile;
            String string = sourceFile = configurationElement == null ? null : configurationElement.getChildTextNormalize("sourceFile");
            if (sourceFile != null && (sourceFile.endsWith(".as") || sourceFile.endsWith(".mxml"))) {
                mainBC.setMainClass(sourceFile.substring(0, sourceFile.lastIndexOf(".")).replace("/", ".").replace("\\", "."));
            }
            if (producesAirPackage) {
                this.setupPackagingOptions(mainBC.getAirDesktopPackagingOptions(), configurationElement);
            }
        }
        String outputFilePath = FlexmojosImporter.getOutputFilePath(this.myMavenProject);
        String fileName = PathUtil.getFileName((String)outputFilePath);
        mainBC.setOutputFileName(fileName);
        mainBC.setOutputFolder(PathUtil.getParentPath((String)outputFilePath));
        BuildConfigurationNature nature = mainBC.getNature();
        if (nature.isApp() && isNewBC) {
            String packageFileName = FileUtil.getNameWithoutExtension((String)fileName);
            if (nature.isDesktopPlatform()) {
                mainBC.getAirDesktopPackagingOptions().setPackageFileName(packageFileName);
            } else if (nature.isMobilePlatform()) {
                mainBC.getAndroidPackagingOptions().setPackageFileName(packageFileName);
                mainBC.getIosPackagingOptions().setPackageFileName(packageFileName);
            }
        }
        this.setupSdk(mainBC);
        String locales = StringUtil.join(this.myCompiledLocales, (String)"\n");
        THashMap options = new THashMap(mainBC.getCompilerOptions().getAllOptions());
        options.put("compiler.locale", locales);
        mainBC.getCompilerOptions().setAllOptions((Map<String, String>)options);
        if (BCUtils.canHaveResourceFiles(nature) && isNewBC) {
            mainBC.getCompilerOptions().setResourceFilesMode(CompilerOptions.ResourceFilesMode.None);
        }
        mainBC.getCompilerOptions().setAdditionalConfigFilePath(this.getCompilerConfigFilePath());
        return mainBC;
    }

    private static boolean containsSignAirGoal(MavenPlugin flexmojosPlugin) {
        for (MavenPlugin.Execution execution : flexmojosPlugin.getExecutions()) {
            for (String goal : execution.getGoals()) {
                if (!"sign-air".equals(goal)) continue;
                return true;
            }
        }
        return false;
    }

    private void setupPackagingOptions(ModifiableAirDesktopPackagingOptions packagingOptions, @Nullable Element configurationElement) {
        String keystoreType;
        String descriptorPath = StringUtil.notNullize((String)Flexmojos3Configurator.getPathOption(this.myMavenProject, configurationElement, "descriptorTemplate"), (String)(this.myMavenProject.getDirectory() + "/src/main/resources/descriptor.xml"));
        packagingOptions.setUseGeneratedDescriptor(false);
        packagingOptions.setCustomDescriptorPath(descriptorPath);
        String keystorePath = StringUtil.notNullize((String)Flexmojos3Configurator.getPathOption(this.myMavenProject, configurationElement, "keystore"), (String)(this.myMavenProject.getDirectory() + "/src/main/resources/sign.p12"));
        packagingOptions.getSigningOptions().setUseTempCertificate(false);
        packagingOptions.getSigningOptions().setKeystorePath(keystorePath);
        String string = keystoreType = configurationElement == null ? null : configurationElement.getChildTextNormalize("storetype", configurationElement.getNamespace());
        if (keystoreType != null) {
            packagingOptions.getSigningOptions().setKeystoreType(keystoreType);
        }
    }

    @Nullable
    private static String getPathOption(MavenProject mavenProject, @Nullable Element configurationElement, String optionName) {
        String path;
        String string = path = configurationElement == null ? null : configurationElement.getChildTextNormalize(optionName, configurationElement.getNamespace());
        if (path != null) {
            VirtualFile descriptorFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (descriptorFile == null) {
                descriptorFile = LocalFileSystem.getInstance().findFileByPath(mavenProject.getDirectory() + "/" + path);
            }
            if (descriptorFile != null) {
                return descriptorFile.getPath();
            }
        }
        return path;
    }

    private TargetPlatform handleDependencies(ModifiableFlexBuildConfiguration bc) {
        bc.getDependencies().getModifiableEntries().clear();
        boolean playerglobal = false;
        boolean airglobal = false;
        boolean mobilecomponents = false;
        ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(this.myModule);
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library;
            Object linkageType;
            boolean isExported;
            DependencyScope scope = entry instanceof ExportableOrderEntry ? ((ExportableOrderEntry)entry).getScope() : DependencyScope.COMPILE;
            boolean bl = isExported = entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).isExported();
            if (entry instanceof ModuleOrderEntry) {
                rootModel.removeOrderEntry(entry);
                String dependencyModuleName = ((ModuleOrderEntry)entry).getModuleName();
                MavenProject dependencyMavenProject = this.findMavenProjectByModuleName(dependencyModuleName);
                if (dependencyMavenProject == null) {
                    MavenLog.LOG.warn("Maven project not found, module dependency skipped: " + this.myModule.getName() + " on " + dependencyModuleName);
                    continue;
                }
                if (!ArrayUtil.contains((String)dependencyMavenProject.getPackaging(), (String[])FlexmojosImporter.SUPPORTED_PACKAGINGS)) {
                    MavenLog.LOG.info("Unexpected packaging (" + dependencyMavenProject.getPackaging() + "), module dependency skipped: " + this.myModule.getName() + " on " + dependencyModuleName);
                    continue;
                }
                ModifiableDependencyEntry existingEntry = (ModifiableDependencyEntry)ContainerUtil.find(bc.getDependencies().getModifiableEntries(), entry1 -> entry1 instanceof BuildConfigurationEntry && ((BuildConfigurationEntry)((Object)entry1)).getModuleName().equals(dependencyModuleName) && ((BuildConfigurationEntry)((Object)entry1)).getBcName().equals(dependencyModuleName));
                Object object = linkageType = "swc".equals(dependencyMavenProject.getPackaging()) ? FlexUtils.convertLinkageType(scope, isExported) : LinkageType.LoadInRuntime;
                if (existingEntry != null) {
                    if (existingEntry.getDependencyType().getLinkageType() != LinkageType.Test) continue;
                    existingEntry.getDependencyType().setLinkageType((LinkageType)linkageType);
                    continue;
                }
                ModifiableBuildConfigurationEntry bcEntry = this.myFlexEditor.createBcEntry(bc.getDependencies(), dependencyModuleName, dependencyModuleName);
                bcEntry.getDependencyType().setLinkageType((LinkageType)linkageType);
                bc.getDependencies().getModifiableEntries().add(0, bcEntry);
                continue;
            }
            if (entry instanceof JdkOrderEntry) {
                rootModel.removeOrderEntry(entry);
            }
            if (!(entry instanceof LibraryOrderEntry)) continue;
            rootModel.removeOrderEntry(entry);
            if (!"project".equals(((LibraryOrderEntry)entry).getLibraryLevel()) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || !MavenRootModelAdapter.isMavenLibrary((Library)library)) continue;
            String libraryName = library.getName();
            if (libraryName.contains(":rb.swc:") || libraryName.contains(":resource-bundle:")) {
                Library.ModifiableModel libraryModifiableModel = this.myModelsProvider.getModifiableLibraryModel(library);
                linkageType = Flexmojos3Configurator.findRbSwcPlaceholderUrls(libraryModifiableModel).iterator();
                while (linkageType.hasNext()) {
                    String rbSwcPlaceholdersUrl = (String)linkageType.next();
                    Collection<String> rootsToAdd = this.getRbSwcUrlsForCompiledLocales(rbSwcPlaceholdersUrl);
                    libraryModifiableModel.removeRoot(rbSwcPlaceholdersUrl, OrderRootType.CLASSES);
                    for (String rootToAdd : rootsToAdd) {
                        if (ArrayUtil.contains((String)rootToAdd, (String[])libraryModifiableModel.getUrls(OrderRootType.CLASSES))) continue;
                        libraryModifiableModel.addRoot(rootToAdd, OrderRootType.CLASSES);
                    }
                }
            }
            if (libraryName.contains(":swc:") || libraryName.contains(":rb.swc:") || libraryName.contains(":resource-bundle:") || libraryName.contains(":ane:")) {
                playerglobal |= libraryName.contains("playerglobal");
                airglobal |= libraryName.contains("airglobal");
                mobilecomponents |= libraryName.contains("mobilecomponents");
                boolean ane = libraryName.contains(":ane:") && !libraryName.contains(":swc:");
                PersistentLibraryKind kind = ((LibraryEx)library).getKind();
                if (kind != FlexLibraryType.FLEX_LIBRARY && kind == null) {
                    LibraryEx.ModifiableModelEx libraryModel = (LibraryEx.ModifiableModelEx)this.myModelsProvider.getModifiableLibraryModel(library);
                    libraryModel.setKind(FlexLibraryType.FLEX_LIBRARY);
                }
                ModifiableDependencyEntry sharedLibraryEntry = this.myFlexEditor.createSharedLibraryEntry(bc.getDependencies(), ((LibraryOrderEntry)entry).getLibraryName(), ((LibraryOrderEntry)entry).getLibraryLevel());
                LinkageType linkageType2 = ane ? DependencyType.DEFAULT_LINKAGE : FlexUtils.convertLinkageType(scope, isExported);
                sharedLibraryEntry.getDependencyType().setLinkageType(linkageType2);
                bc.getDependencies().getModifiableEntries().add(sharedLibraryEntry);
                continue;
            }
            MavenLog.LOG.info("Non-swc dependency for flexmojos project '" + this.myModule.getName() + "': " + libraryName);
        }
        return mobilecomponents && airglobal ? TargetPlatform.Mobile : (airglobal && !playerglobal ? TargetPlatform.Desktop : TargetPlatform.Web);
    }

    @Nullable
    private MavenProject findMavenProjectByModuleName(String moduleName) {
        for (Map.Entry<MavenProject, String> entry : this.myMavenProjectToModuleName.entrySet()) {
            if (!moduleName.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static Collection<String> findRbSwcPlaceholderUrls(Library.ModifiableModel libraryModifiableModel) {
        ArrayList<String> rbSwcPlaceholdersUrls = new ArrayList<String>();
        String[] libraryClassesRoots = libraryModifiableModel.getUrls(OrderRootType.CLASSES);
        String libName = libraryModifiableModel.getName();
        String version = libName.substring(libName.lastIndexOf(58) + 1);
        for (String librarySwcPath : libraryClassesRoots) {
            if (!librarySwcPath.matches(".*" + version + "\\.rb\\.swc!/")) continue;
            rbSwcPlaceholdersUrls.add(librarySwcPath);
        }
        return rbSwcPlaceholdersUrls;
    }

    private Collection<String> getRbSwcUrlsForCompiledLocales(String rbSwcPlaceholderUrl) {
        String RB_SWC_URL_END = ".rb.swc!/";
        assert (rbSwcPlaceholderUrl.endsWith(".rb.swc!/"));
        String rbSwcUrlCommonPart = rbSwcPlaceholderUrl.substring(0, rbSwcPlaceholderUrl.length() - ".rb.swc!/".length());
        ArrayList<String> result = new ArrayList<String>();
        for (String locale : this.myCompiledLocales) {
            result.add(rbSwcUrlCommonPart + "-" + locale + ".rb.swc!/");
        }
        return result;
    }

    private void setupSdk(ModifiableFlexBuildConfiguration bc) {
        String path = Flexmojos3Configurator.getArtifactFilePath(this.myMavenProject, this.getFlexCompilerMavenId(), "pom");
        Sdk flexSdk = FlexSdkUtils.createOrGetSdk(FlexmojosSdkType.getInstance(), path);
        if (flexSdk != null) {
            this.ensureSdkHasRequiredAdditionalJarPaths(flexSdk);
            bc.getDependencies().setSdkEntry(Factory.createSdkEntry(flexSdk.getName()));
        }
    }

    private MavenId getFlexCompilerMavenId() {
        for (MavenId mavenId : this.myFlexmojosPlugin.getDependencies()) {
            if (!FLEX_COMPILER_ARTIFACT_ID.equals(mavenId.getArtifactId()) || !FLEX_COMPILER_ADOBE_GROUP_ID.equals(mavenId.getGroupId()) && !FLEX_COMPILER_APACHE_GROUP_ID.equals(mavenId.getGroupId())) continue;
            return mavenId;
        }
        for (MavenArtifact mavenArtifact : this.myMavenProject.getDependencies()) {
            if (FLEX_COMPILER_ADOBE_GROUP_ID.equals(mavenArtifact.getGroupId()) && "framework".equals(mavenArtifact.getArtifactId()) || "com.adobe.flex.framework".equals(mavenArtifact.getGroupId()) && ("flex-framework".equals(mavenArtifact.getArtifactId()) || "air-framework".equals(mavenArtifact.getArtifactId()))) {
                return new MavenId(FLEX_COMPILER_ADOBE_GROUP_ID, FLEX_COMPILER_ARTIFACT_ID, mavenArtifact.getVersion());
            }
            if ((!FLEX_COMPILER_APACHE_GROUP_ID.equals(mavenArtifact.getGroupId()) || !"framework".equals(mavenArtifact.getArtifactId())) && (!"org.apache.flex.framework".equals(mavenArtifact.getGroupId()) || !"flex-framework".equals(mavenArtifact.getArtifactId()) && !"common-framework".equals(mavenArtifact.getArtifactId()))) continue;
            return new MavenId(FLEX_COMPILER_APACHE_GROUP_ID, FLEX_COMPILER_ARTIFACT_ID, mavenArtifact.getVersion());
        }
        String pluginVersion = this.myFlexmojosPlugin.getVersion();
        String version = StringUtil.compareVersionNumbers((String)pluginVersion, (String)"5") >= 0 ? "4.6.0.23201" : (StringUtil.compareVersionNumbers((String)pluginVersion, (String)"4.1") >= 0 || pluginVersion != null && pluginVersion.startsWith("4.0-RC") ? "4.5.1.21328" : (StringUtil.compareVersionNumbers((String)pluginVersion, (String)"4") >= 0 ? "4.5.0.18623" : "3.2.0.3958"));
        return new MavenId(FLEX_COMPILER_ADOBE_GROUP_ID, FLEX_COMPILER_ARTIFACT_ID, version);
    }

    private static String getArtifactFilePath(MavenProject mavenProject, MavenId mavenId, String type) {
        return FileUtil.toSystemIndependentName((String)MavenArtifactUtil.getArtifactFile((File)mavenProject.getLocalRepository(), (MavenId)mavenId, (String)type).getPath());
    }

    private void ensureSdkHasRequiredAdditionalJarPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            Flexmojos3Configurator.$$$reportNull$$$0(0);
        }
        assert (sdk.getSdkType() instanceof FlexmojosSdkType);
        FlexmojosSdkAdditionalData additionalData = (FlexmojosSdkAdditionalData)sdk.getSdkAdditionalData();
        assert (additionalData != null);
        block0: for (MavenId dependency : this.myFlexmojosPlugin.getDependencies()) {
            if (StringUtil.isEmpty((String)dependency.getArtifactId())) continue;
            for (Pattern jarNamePattern : ADDITIONAL_JAR_NAME_PATTERNS_TO_INCLUDE_IN_FLEXMOJOS_SDK_CLASSPATH) {
                if (!jarNamePattern.matcher(dependency.getArtifactId()).matches()) continue;
                String jarFilePath = Flexmojos3Configurator.getArtifactFilePath(this.myMavenProject, dependency, "jar");
                additionalData.addFlexCompilerClasspathEntryIfNotPresentAndRemoveDifferentVersionOfThisJar(jarNamePattern, jarFilePath);
                continue block0;
            }
        }
    }

    protected String getCompilerConfigFilePath() {
        return this.getCompilerConfigFilePath(null);
    }

    protected String getCompilerConfigFilePath(@Nullable String rlmName) {
        Element configurationElement = this.myFlexmojosPlugin.getConfigurationElement();
        String classifier = configurationElement == null ? null : configurationElement.getChildTextNormalize("classifier", configurationElement.getNamespace());
        String suffix = "";
        if (rlmName != null) {
            suffix = "-" + rlmName;
        } else if (classifier != null) {
            suffix = "-" + classifier;
        }
        return FileUtil.toSystemIndependentName((String)this.myMavenProject.getBuildDirectory()) + "/" + this.myMavenProject.getFinalName() + suffix + "-config-report.xml";
    }

    protected void appendGenerateConfigTask(List<MavenProjectsProcessorTask> postTasks, String configFilePath) {
        postTasks.add((MavenProjectsProcessorTask)new Flexmojos3GenerateConfigTask(this.myModule, this.myMavenProject, this.myMavenTree, configFilePath, this.myInformer));
    }

    private void configureRuntimeLoadedModule(ModifiableFlexBuildConfiguration mainBC, RuntimeModulesGenerateConfigTask.RLMInfo info, @Nullable ModifiableFlexBuildConfiguration existingRlmBC) {
        BuildConfigurationNature nature = new BuildConfigurationNature(mainBC.getTargetPlatform(), mainBC.isPureAs(), OutputType.RuntimeLoadedModule);
        boolean isNewBC = existingRlmBC == null;
        ModifiableFlexBuildConfiguration rlmBC = isNewBC ? this.myFlexEditor.copyConfiguration(mainBC, nature) : existingRlmBC;
        rlmBC.setName(info.myRLMName);
        rlmBC.setMainClass(info.myMainClass);
        rlmBC.setOutputFileName(info.myOutputFileName);
        rlmBC.setOutputFolder(info.myOutputFolderPath);
        rlmBC.getCompilerOptions().setAdditionalConfigFilePath(this.getCompilerConfigFilePath(info.myRLMName));
    }

    protected Collection<RuntimeModulesGenerateConfigTask.RLMInfo> getRLMInfos() {
        Element moduleFilesElement;
        Element configurationElement = this.myFlexmojosPlugin.getConfigurationElement();
        Element element = moduleFilesElement = configurationElement == null ? null : configurationElement.getChild("moduleFiles", configurationElement.getNamespace());
        if (moduleFilesElement == null) {
            return Collections.emptyList();
        }
        ArrayList<RuntimeModulesGenerateConfigTask.RLMInfo> result = new ArrayList<RuntimeModulesGenerateConfigTask.RLMInfo>();
        for (Element moduleFilePathElement : moduleFilesElement.getChildren()) {
            String path = moduleFilePathElement.getTextNormalize();
            if (!path.endsWith(".mxml") && !path.endsWith(".as")) continue;
            String mainClassRelativePath = FileUtil.toSystemIndependentName((String)path);
            String mainClass = FileUtil.getNameWithoutExtension((String)mainClassRelativePath.replace('/', '.'));
            String rlmName = StringUtil.getShortName((String)mainClass);
            String outputFileName = this.myMavenProject.getFinalName() + "-" + rlmName + ".swf";
            String outputFolderPath = FileUtil.toSystemIndependentName((String)this.myMavenProject.getBuildDirectory());
            String configFilePath = this.getCompilerConfigFilePath(rlmName);
            result.add(new RuntimeModulesGenerateConfigTask.RLMInfo(rlmName, mainClass, mainClassRelativePath, outputFileName, outputFolderPath, configFilePath));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/javascript/flex/maven/Flexmojos3Configurator", "ensureSdkHasRequiredAdditionalJarPaths"));
    }
}

