/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.DataBinder;
import android.databinding.tool.DataBindingCompilerArgs;
import android.databinding.tool.LayoutBinder;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.reflection.InjectedClass;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.store.GenClassInfoLog;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.BRWriter;
import android.databinding.tool.writer.BindingMapperWriter;
import android.databinding.tool.writer.BindingMapperWriterV2;
import android.databinding.tool.writer.JavaFileWriter;
import android.databinding.tool.writer.MergedBindingMapperWriter;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompilerChef {
    private static final String[] VERSION_CODES = new String[]{"BASE", "BASE_1_1", "CUPCAKE", "DONUT", "ECLAIR", "ECLAIRE_0_1", "ECLAIR_MR1", "FROYO", "GINGERBREAD", "GINGERBREAD_MR1", "HONEYCOMB", "HONEYCOMB_MR1", "HONEYCOMB_MR2", "ICE_CREAM_SANDWICH", "ICE_CREAM_SANDWICH_MR1", "JELLY_BEAN", "JELLY_BEAN_MR1", "JELLY_BEAN_MR2", "KITKAT", "KITKAT_WATCH", "LOLLIPOP", "LOLLIPOP_MR1", "M"};
    private JavaFileWriter mFileWriter;
    private ResourceBundle mResourceBundle;
    private DataBinder mDataBinder;
    private boolean mEnableV2;

    private CompilerChef() {
    }

    public static CompilerChef createChef(ResourceBundle bundle, JavaFileWriter fileWriter, DataBindingCompilerArgs compilerArgs) {
        CompilerChef chef = new CompilerChef();
        chef.mResourceBundle = bundle;
        chef.mFileWriter = fileWriter;
        chef.mResourceBundle.validateMultiResLayouts();
        chef.mEnableV2 = compilerArgs.isEnableV2();
        chef.pushClassesToAnalyzer();
        return chef;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public void ensureDataBinder() {
        if (this.mDataBinder == null) {
            this.mDataBinder = new DataBinder(this.mResourceBundle, this.mEnableV2);
            this.mDataBinder.setFileWriter(this.mFileWriter);
        }
    }

    public boolean hasAnythingToGenerate() {
        L.d("checking if we have anything to generate. bundle size: %s", this.mResourceBundle == null ? -1 : this.mResourceBundle.getLayoutBundles().size());
        return this.mResourceBundle != null && this.mResourceBundle.getLayoutBundles().size() > 0;
    }

    private void pushClassesToAnalyzer() {
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        for (String layoutName : this.mResourceBundle.getLayoutBundles().keySet()) {
            HashSet<String> variables2 = new HashSet<String>();
            HashSet<String> fields = new HashSet<String>();
            List<ResourceBundle.LayoutFileBundle> bundles = this.mResourceBundle.getLayoutBundles().get(layoutName);
            String className = bundles.get(0).getBindingClassPackage() + "." + bundles.get(0).getBindingClassName();
            InjectedClass bindingClass = new InjectedClass(className, "android.databinding.ViewDataBinding");
            analyzer.injectClass(bindingClass);
            for (ResourceBundle.LayoutFileBundle layoutFileBundle : bundles) {
                HashMap<String, String> imports = new HashMap<String, String>();
                for (ResourceBundle.NameTypeLocation imp : layoutFileBundle.getImports()) {
                    imports.put(imp.name, imp.type);
                }
                for (ResourceBundle.VariableDeclaration variable : layoutFileBundle.getVariables()) {
                    if (!variables2.add(variable.name)) continue;
                    bindingClass.addVariable(variable.name, variable.type, imports);
                }
                for (ResourceBundle.BindingTargetBundle bindingTargetBundle : layoutFileBundle.getBindingTargetBundles()) {
                    String fieldName2;
                    if (bindingTargetBundle.getId() == null || !fields.add(fieldName2 = bindingTargetBundle.getId())) continue;
                    String fieldType = bindingTargetBundle.getInterfaceType();
                    bindingClass.addField(fieldName2, fieldType);
                }
                if (!this.mEnableV2 && bundles.size() <= 1) continue;
                String implName = layoutFileBundle.getBindingClassPackage() + "." + layoutFileBundle.createImplClassNameWithConfig();
                analyzer.injectClass(new InjectedClass(implName, className));
            }
        }
    }

    public void writeDataBinderMapper(DataBindingCompilerArgs compilerArgs, BRWriter brWriter, List<String> modulePackages) {
        if (compilerArgs.isEnableV2()) {
            boolean generateMergedMapper;
            boolean generateMapper = compilerArgs.isApp() ? !compilerArgs.isTestVariant() || compilerArgs.isEnabledForTests() : true;
            if (generateMapper) {
                this.writeMapperForModule(compilerArgs, brWriter);
            }
            if (generateMergedMapper = compilerArgs.isApp() ? !compilerArgs.isTestVariant() : compilerArgs.isTestVariant()) {
                this.writeMergedMapper(compilerArgs, modulePackages);
            }
        } else {
            String pkg = "android.databinding";
            String mapperName = "DataBinderMapperImpl";
            this.ensureDataBinder();
            BindingMapperWriter dbr = new BindingMapperWriter("android.databinding", "DataBinderMapperImpl", this.mDataBinder.getLayoutBinders(), compilerArgs);
            this.mFileWriter.writeToFile("android.databinding." + dbr.getClassName(), dbr.write(brWriter));
        }
    }

    private void writeMergedMapper(DataBindingCompilerArgs compilerArgs, List<String> modulePackages) {
        StringBuilder sb = new StringBuilder();
        MergedBindingMapperWriter mergedBindingMapperWriter = new MergedBindingMapperWriter(modulePackages, compilerArgs);
        TypeSpec mergedMapperSpec = mergedBindingMapperWriter.write();
        try {
            JavaFile.builder((String)mergedBindingMapperWriter.getPkg(), (TypeSpec)mergedMapperSpec).build().writeTo((Appendable)sb);
            this.mFileWriter.writeToFile(mergedBindingMapperWriter.getQualifiedName(), sb.toString());
        }
        catch (IOException e) {
            Scope.defer(new ScopedException("cannot generate merged mapper class", new Object[]{e}));
        }
    }

    private void writeMapperForModule(DataBindingCompilerArgs compilerArgs, BRWriter brWriter) {
        GenClassInfoLog infoLog;
        try {
            infoLog = ResourceBundle.loadClassInfoFromFolder(new File(compilerArgs.getClassLogDir()));
        }
        catch (IOException e) {
            Scope.defer(new ScopedException("Cannot read class info log", new Object[0]));
            infoLog = new GenClassInfoLog();
        }
        GenClassInfoLog infoLogInThisModule = infoLog.createPackageInfoLog(compilerArgs.getModulePackage());
        BindingMapperWriterV2 v2 = new BindingMapperWriterV2(infoLogInThisModule, compilerArgs);
        TypeSpec spec = v2.write(brWriter);
        StringBuilder sb = new StringBuilder();
        try {
            JavaFile.builder((String)v2.getPkg(), (TypeSpec)spec).build().writeTo((Appendable)sb);
            this.mFileWriter.writeToFile(v2.getQualifiedName(), sb.toString());
        }
        catch (IOException e) {
            Scope.defer(new ScopedException("cannot generate mapper class", new Object[]{e}));
        }
    }

    public void addBRVariables(BindableHolder bindables) {
        this.ensureDataBinder();
        for (LayoutBinder layoutBinder : this.mDataBinder.mLayoutBinders) {
            for (String variableName : layoutBinder.getUserDefinedVariables().keySet()) {
                bindables.addVariable(variableName, layoutBinder.getClassName());
            }
        }
    }

    public void sealModels() {
        this.ensureDataBinder();
        this.mDataBinder.sealModels();
    }

    public void writeViewBinderInterfaces(boolean isLibrary) {
        this.ensureDataBinder();
        this.mDataBinder.writerBaseClasses(isLibrary);
    }

    public void writeViewBinders(int minSdk) {
        this.ensureDataBinder();
        this.mDataBinder.writeBinders(minSdk);
    }

    public void writeComponent() {
        this.ensureDataBinder();
        this.mDataBinder.writeComponent();
    }

    public Set<String> getClassesToBeStripped() {
        this.ensureDataBinder();
        return this.mDataBinder.getClassesToBeStripped();
    }

    public static interface BindableHolder {
        public void addVariable(String var1, String var2);
    }
}

