/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.SpringModulesPanelBase;
import com.intellij.spring.toolWindow.panels.SpringAutoConfiguredFilesFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringFileSetFinderRecursivePanel;
import gnu.trove.THashSet;
import icons.SpringApiIcons;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeansModulesPanel
extends SpringModulesPanelBase {
    private final DefaultActionGroup myStructureViewActionGroup;
    private ToggleAction myShowApplicationContextsAction;

    public SpringBeansModulesPanel(@NotNull Project project, @NotNull DefaultActionGroup structureViewActionGroup) {
        if (project == null) {
            SpringBeansModulesPanel.$$$reportNull$$$0(0);
        }
        if (structureViewActionGroup == null) {
            SpringBeansModulesPanel.$$$reportNull$$$0(1);
        }
        super(project, "SpringBeansModulesPanel");
        this.myStructureViewActionGroup = structureViewActionGroup;
        this.installActions();
    }

    private void installActions() {
        this.myShowApplicationContextsAction = new ToggleAction("Show application contexts", null, SpringApiIcons.FileSet){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return SpringBeansViewSettings.getInstance(SpringBeansModulesPanel.this.getProject()).isShowFileSets();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.update(e);
                e.getPresentation().setEnabled(SpringBeansViewSettings.getInstance(SpringBeansModulesPanel.this.getProject()).isShowModules());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                SpringBeansViewSettings.getInstance(SpringBeansModulesPanel.this.getProject()).setShowFileSets(state);
                SpringBeansModulesPanel.this.updateRightComponent(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/spring/toolWindow/panels/SpringBeansModulesPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myStructureViewActionGroup.add((AnAction)this.myShowApplicationContextsAction);
    }

    public void dispose() {
        this.myStructureViewActionGroup.remove((AnAction)this.myShowApplicationContextsAction);
        super.dispose();
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    @Nullable
    protected JComponent createRightComponent(final Module module) {
        SpringFacet springFacet;
        boolean autoConfigurationMode = SpringGeneralSettings.getInstance(this.getProject()).isAllowAutoConfigurationMode();
        if (SpringBeansModulesPanel.isAutoConfigurationModeAllowed(autoConfigurationMode, springFacet = SpringFacet.getInstance(module))) {
            return new SpringAutoConfiguredFilesFinderRecursivePanel(this, module);
        }
        if (springFacet != null && SpringBeansViewSettings.getInstance(this.getProject()).isShowFileSets()) {
            return new SpringFileSetFinderRecursivePanel(this, module, this.myStructureViewActionGroup);
        }
        NullableFactory factory = () -> new BeansSpringModel(null, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

            @NotNull
            protected Collection<? extends SpringBeanPointer> compute() {
                THashSet allBeans = new THashSet();
                for (SpringModel model : SpringManager.getInstance(SpringBeansModulesPanel.this.getProject()).getAllModelsWithoutDependencies(module)) {
                    allBeans.addAll(model.getAllCommonBeans());
                }
                THashSet tHashSet = allBeans;
                if (tHashSet == null) {
                    2.$$$reportNull$$$0(0);
                }
                return tHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringBeansModulesPanel$2", "compute"));
            }
        });
        return new SpringBeanPointerFinderRecursivePanel(this, (NullableFactory<CommonSpringModel>)factory);
    }

    private static boolean isAutoConfigurationModeAllowed(boolean autoConfigurationMode, SpringFacet springFacet) {
        return autoConfigurationMode && (springFacet == null || SpringFileSetService.getInstance().getAllSets(springFacet).isEmpty());
    }

    @Override
    public boolean hasChildren(Module module) {
        if (module.isDisposed()) {
            return false;
        }
        if (DumbService.isDumb((Project)this.getProject())) {
            return false;
        }
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (SpringBeansModulesPanel.isAutoConfigurationModeAllowed(SpringGeneralSettings.getInstance(this.getProject()).isAllowAutoConfigurationMode(), springFacet)) {
            return !SpringAutoConfiguredModels.discoverAutoConfiguredModels(module).isEmpty();
        }
        return springFacet != null && !SpringFileSetService.getInstance().getAllSets(springFacet).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "structureViewActionGroup";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/toolWindow/panels/SpringBeansModulesPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

