/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringBeansModulesPanel;
import com.intellij.ui.FinderRecursivePanel;
import gnu.trove.THashSet;
import icons.SpringApiIcons;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class SpringBeansView
extends SpringBaseView {
    private static final String TAB_ID = "Beans";
    private DefaultActionGroup myStructureViewActionGroup;
    private DefaultActionGroup myConfigurationViewActionGroup;
    private DefaultActionGroup myPresentationActionGroup;
    private SpringBeansViewSettings mySpringBeansViewSettings;

    SpringBeansView(Project project) {
        super(project);
        this.installToolbar();
        this.installSettingsListener();
        this.installProjectModuleListener();
    }

    @Override
    protected FinderRecursivePanel createRootPanel() {
        this.mySpringBeansViewSettings = SpringBeansViewSettings.getInstance(this.myProject);
        if (this.getSettings().isShowModules()) {
            return new SpringBeansModulesPanel(this.myProject, this.getStructureViewActionGroup());
        }
        return this.createSpringBeansProjectPanel();
    }

    static void selectIn(Project project, Object[] pathToSelect, boolean requestFocus) {
        SpringBeansView.select(project, pathToSelect, requestFocus, TAB_ID);
    }

    private SpringBeansViewSettings getSettings() {
        return this.mySpringBeansViewSettings;
    }

    private SpringBeanPointerFinderRecursivePanel createSpringBeansProjectPanel() {
        NullableFactory factory = () -> new BeansSpringModel(null, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

            @NotNull
            protected Collection<? extends SpringBeanPointer> compute() {
                Module[] modules;
                THashSet allBeans = new THashSet();
                for (Module module : modules = ModuleManager.getInstance((Project)SpringBeansView.this.myProject).getModules()) {
                    for (SpringModel model : SpringManager.getInstance(SpringBeansView.this.myProject).getAllModelsWithoutDependencies(module)) {
                        Collection<SpringBeanPointer> beans = model.getAllCommonBeans();
                        allBeans.addAll(beans);
                    }
                }
                THashSet tHashSet = allBeans;
                if (tHashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return tHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/SpringBeansView$1", "compute"));
            }
        });
        return new SpringBeanPointerFinderRecursivePanel(this.myProject, "SpringBeanPointerFinderRecursivePanel", (NullableFactory<CommonSpringModel>)factory);
    }

    private void installToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.getStructureViewActionGroup());
        group.addSeparator();
        group.add((AnAction)this.getConfigurationViewActionGroup());
        group.addSeparator();
        group.add((AnAction)this.getPresentationActionGroup());
        this.setToolbar(ActionManager.getInstance().createActionToolbar("SpringBeansView", (ActionGroup)group, false).getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(SpringBeansViewSettings.TOPIC, (Object)new SpringBeansViewSettings.Listener(){

            @Override
            public void settingsChanged(SpringBeansViewSettings.ChangeType changeType) {
                if (changeType == SpringBeansViewSettings.ChangeType.FULL) {
                    SpringBeansView.this.performFullUpdate();
                } else if (changeType == SpringBeansViewSettings.ChangeType.UPDATE_DETAILS) {
                    SpringBeansView.this.performDetailsUpdate();
                } else if (changeType == SpringBeansViewSettings.ChangeType.UPDATE_LIST) {
                    SpringBeansView.this.myRootPanel.updatePanel();
                } else if (changeType == SpringBeansViewSettings.ChangeType.FORCE_UPDATE_RIGHT_COMPONENT) {
                    SpringBeansView.this.myRootPanel.updateRightComponent(true);
                }
            }
        });
    }

    @NotNull
    private DefaultActionGroup getStructureViewActionGroup() {
        if (this.myStructureViewActionGroup == null) {
            this.myStructureViewActionGroup = new DefaultActionGroup();
            this.myStructureViewActionGroup.add((AnAction)new ToggleAction("Show modules", null, AllIcons.Actions.GroupByModule){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return SpringBeansView.this.getSettings().isShowModules();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    SpringBeansViewSettings settings = SpringBeansView.this.getSettings();
                    settings.setShowModules(state);
                    settings.fireSettingsChanged(SpringBeansViewSettings.ChangeType.FULL);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/spring/toolWindow/SpringBeansView$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        DefaultActionGroup defaultActionGroup = this.myStructureViewActionGroup;
        if (defaultActionGroup == null) {
            SpringBeansView.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    @NotNull
    private DefaultActionGroup getConfigurationViewActionGroup() {
        if (this.myConfigurationViewActionGroup == null) {
            this.myConfigurationViewActionGroup = new DefaultActionGroup();
            this.myConfigurationViewActionGroup.add((AnAction)new ToggleAction("Show Implicit Beans", null, SpringApiIcons.ImplicitBean){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return SpringBeansView.this.getSettings().isShowImplicitBeans();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    SpringBeansView.this.getSettings().setShowImplicitBeans(state);
                    SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_LIST);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/spring/toolWindow/SpringBeansView$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myConfigurationViewActionGroup.add((AnAction)new ToggleAction("Show Infrastructure Beans", null, SpringApiIcons.InfrastructureBean){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return SpringBeansView.this.getSettings().isShowInfrastructureBeans();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    SpringBeansView.this.getSettings().setShowInfrastructureBeans(state);
                    SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_LIST);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/spring/toolWindow/SpringBeansView$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        DefaultActionGroup defaultActionGroup = this.myConfigurationViewActionGroup;
        if (defaultActionGroup == null) {
            SpringBeansView.$$$reportNull$$$0(1);
        }
        return defaultActionGroup;
    }

    @NotNull
    private DefaultActionGroup getPresentationActionGroup() {
        if (this.myPresentationActionGroup == null) {
            this.myPresentationActionGroup = new DefaultActionGroup();
            this.myPresentationActionGroup.add((AnAction)new ToggleAction(SpringApiBundle.message("spring.beans.view.show.bean.documentation.title", new Object[0]), null, AllIcons.Toolwindows.Documentation){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return SpringBeansView.this.getSettings().isShowDoc();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    SpringBeansView.this.getSettings().setShowDoc(state);
                    SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_DETAILS);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/spring/toolWindow/SpringBeansView$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (((SpringBeanPointerFinderRecursivePanel.SpringBeanPointerPanelContent[])SpringBeanPointerFinderRecursivePanel.EP_NAME.getExtensions()).length != 0) {
                this.myPresentationActionGroup.add((AnAction)new ToggleAction(SpringApiBundle.message("spring.beans.view.show.bean.graph.title", new Object[0]), null, AllIcons.FileTypes.Diagram){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        return SpringBeansView.this.getSettings().isShowGraph();
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            7.$$$reportNull$$$0(1);
                        }
                        SpringBeansView.this.getSettings().setShowGraph(state);
                        SpringBeansView.this.getSettings().fireSettingsChanged(SpringBeansViewSettings.ChangeType.UPDATE_DETAILS);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/spring/toolWindow/SpringBeansView$7";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setSelected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        DefaultActionGroup defaultActionGroup = this.myPresentationActionGroup;
        if (defaultActionGroup == null) {
            SpringBeansView.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/toolWindow/SpringBeansView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureViewActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationViewActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationActionGroup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

