/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.profiles.SpringProfile;
import com.intellij.spring.profiles.SpringProfilePsiReference;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringProfilesFactoryImpl
extends SpringProfilesFactory
implements Disposable {
    private final Set<SpringProfile> myProfiles = new CopyOnWriteArraySet<SpringProfile>();
    private final Map<PsiFile, Long> myContributors = new ConcurrentHashMap<PsiFile, Long>();
    private final Module myModule;

    public SpringProfilesFactoryImpl(Module module) {
        this.myModule = module;
    }

    @Override
    @NotNull
    public SpringProfile getOrCreateProfile(String profileName, @NotNull PsiElement element) {
        SpringProfile byName;
        PsiFile containingFile;
        if (element == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(0);
        }
        if (this.myContributors.containsKey(containingFile = element.getContainingFile()) && this.myContributors.get(containingFile).longValue() != containingFile.getModificationStamp()) {
            this.myProfiles.clear();
            this.myContributors.clear();
        }
        if ((byName = this.findProfile(profileName)) != null) {
            SpringProfile springProfile = byName;
            if (springProfile == null) {
                SpringProfilesFactoryImpl.$$$reportNull$$$0(1);
            }
            return springProfile;
        }
        SpringProfile profile = new SpringProfile(profileName, element);
        this.myProfiles.add(profile);
        this.myContributors.put(containingFile, containingFile.getModificationStamp());
        SpringProfile springProfile = profile;
        if (springProfile == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(2);
        }
        return springProfile;
    }

    @Override
    @Nullable
    public SpringProfile findProfile(String profileName) {
        for (SpringProfile profile : this.myProfiles) {
            if (!profileName.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<SpringProfile> getProfiles() {
        Set<SpringProfile> set = this.myProfiles;
        if (set == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public PsiReference[] getProfilesReferences(@NotNull PsiElement element, @Nullable String value, boolean isDefinition) {
        if (element == null) {
            SpringProfilesFactoryImpl.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        final String elementText = element.getText();
        final int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        SmartList references = new SmartList();
        new DelimitedListProcessor(",", (List)references, element, isDefinition){
            final /* synthetic */ List val$references;
            final /* synthetic */ PsiElement val$element;
            final /* synthetic */ boolean val$isDefinition;
            {
                this.val$references = list;
                this.val$element = psiElement;
                this.val$isDefinition = bl;
                super(x0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                TextRange range = new TextRange(start + offset, end + offset);
                String profileName = range.substring(elementText);
                String profileNameTrimmed = profileName.trim();
                int profileNameIdx = profileName.indexOf(profileNameTrimmed);
                TextRange trimmedRange = TextRange.from((int)(range.getStartOffset() + profileNameIdx), (int)profileNameTrimmed.length());
                if (StringUtil.startsWithChar((CharSequence)profileNameTrimmed, (char)'!')) {
                    trimmedRange = trimmedRange.shiftRight(1).grown(-1);
                }
                this.val$references.add(new SpringProfilePsiReference(this.val$element, trimmedRange, SpringProfilesFactoryImpl.this.myModule, this.val$isDefinition));
            }
        }.processText(value);
        return (PsiReference[])ArrayUtil.toObjectArray((Collection)references, PsiReference.class);
    }

    public void dispose() {
        this.myProfiles.clear();
        this.myContributors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfilesFactoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfilesFactoryImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProfile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProfile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProfilesReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

