/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.profiles.ChangeActiveProfileDialog;
import com.intellij.spring.statistics.SpringFeatureUsagesCollector;
import com.intellij.ui.EditorNotifications;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringChangeActiveProfilesAction
extends AnAction {
    public static final String ACTION_ID = "SpringChangeActiveProfiles";

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (project = e.getProject()) != null && SpringCommonUtils.hasSpringFacets(project);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        SpringModel model;
        if (e == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        assert (project != null);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        ChangeActiveProfileDialog dialog = new ChangeActiveProfileDialog(project, module, model = SpringChangeActiveProfilesAction.getSpringModelFromDataContext(module, e));
        if (dialog.showAndGet()) {
            SpringChangeActiveProfilesAction.triggerRehighlight(project);
        }
    }

    private static void triggerRehighlight(Project project) {
        SpringFeatureUsagesCollector.trigger(project, "actions.SpringChangeActiveProfiles");
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        SpringModificationTrackersManager.getInstance(project).fireActiveProfilesChanged();
        PsiManager.getInstance((Project)project).dropPsiCaches();
    }

    @Nullable
    private static SpringModel getSpringModelFromDataContext(Module module, AnActionEvent e) {
        Object data;
        if (module != null && (data = e.getData(PlatformDataKeys.SELECTED_ITEM)) instanceof SpringFileSet) {
            return SpringChangeActiveProfilesAction.getSpringModelForFileSet(module, (SpringFileSet)data);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile != null) {
            return SpringChangeActiveProfilesAction.getSpringModel(psiFile);
        }
        return null;
    }

    @Nullable
    private static SpringModel getSpringModelForFileSet(Module module, SpringFileSet springFileSet) {
        for (SpringModel model : SpringManager.getInstance(module.getProject()).getAllModels(module)) {
            if (!springFileSet.equals(model.getFileSet())) continue;
            return model;
        }
        return null;
    }

    @Nullable
    static SpringModel getSpringModel(PsiFile psiFile) {
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
            SpringManager springManager = SpringManager.getInstance(psiFile.getProject());
            return springManager.getSpringModelByFile(psiFile);
        }
        if (psiFile instanceof PsiClassOwner) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            if (module == null) {
                return null;
            }
            if (!SpringChangeActiveProfilesAction.hasConfigurations((PsiClassOwner)psiFile)) {
                return null;
            }
            SpringManager springManager = SpringManager.getInstance(psiFile.getProject());
            Set<SpringModel> models = springManager.getAllModels(module);
            for (SpringModel model : models) {
                if (!SpringModelVisitorUtils.hasConfigFile(model, psiFile)) continue;
                return model;
            }
        }
        return null;
    }

    private static boolean hasConfigurations(PsiClassOwner psiFile) {
        for (PsiClass psiClass : psiFile.getClasses()) {
            if (!SpringChangeActiveProfilesAction.containsConfigurations(psiClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConfigurations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringChangeActiveProfilesAction.$$$reportNull$$$0(2);
        }
        if (SpringCommonUtils.isConfigurationOrMeta(psiClass)) {
            return true;
        }
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (!innerClass.hasModifierProperty("static") || !SpringCommonUtils.isConfigurationOrMeta(innerClass)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/profiles/SpringChangeActiveProfilesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsConfigurations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

