/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.JamService;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.context.PropertyPlaceholder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.DomElement;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderPropertyReference
extends PropertyReferenceBase
implements LocalQuickFixProvider {
    private final PlaceholderInfo myInfo;
    @Nullable
    private final String myDefaultValue;

    private PlaceholderPropertyReference(@NotNull String key, PsiElement element, TextRange textRange, PlaceholderInfo info, @Nullable String defaultValue) {
        if (key == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(0);
        }
        super(key, true, element, textRange);
        this.myInfo = info;
        this.myDefaultValue = defaultValue;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public static PlaceholderPropertyReference create(PsiElement element, TextRange textRange, PlaceholderInfo info) {
        String text = info.text;
        if (text.contains(":")) {
            int offset = textRange.getStartOffset();
            int endOffset = text.indexOf(":");
            String key = text.substring(0, endOffset);
            String defaultValue = text.substring(endOffset + 1);
            return new PlaceholderPropertyReference(key, element, TextRange.from((int)offset, (int)endOffset), info, defaultValue){

                public boolean isSoft() {
                    return true;
                }
            };
        }
        return new PlaceholderPropertyReference(text, element, textRange, info, null);
    }

    @NotNull
    private static Properties getValueProperties(SpringProperty property) {
        Properties props = new Properties();
        String value = property.getValue().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            try {
                props.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties properties = props;
        if (properties == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(1);
        }
        return properties;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet properties = new HashSet();
        Processor processor = propertiesFile -> {
            properties.addAll(propertiesFile.findPropertiesByKey(this.myKey));
            return true;
        };
        HashSet<DomElement> configurerProperties = new HashSet<DomElement>();
        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer> placeholders = this.getPlaceholders(springModel);
        if (placeholders.size() > 0) {
            configurerProperties.addAll(this.getPlaceholderConfigurerProperties(this.myKey, placeholders));
        }
        for (PropertiesFile propertiesFile2 : PlaceholderPropertyReference.collectPropertiesFiles(springModel, placeholders, this.myElement.getProject())) {
            processor.process((Object)propertiesFile2);
        }
        ResolveResult[] result = new ResolveResult[properties.size() + configurerProperties.size()];
        if (properties.size() > 0 || configurerProperties.size() > 0) {
            int i = 0;
            for (IProperty property : properties) {
                result[i++] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
            }
            for (DomElement configurerProperty : configurerProperties) {
                result[i++] = new PsiElementResolveResult((PsiElement)configurerProperty.getXmlElement());
            }
        } else if (System.getProperties().getProperty(this.myKey) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(this.getElement())};
            if (resolveResultArray == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        if (result == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(3);
        }
        return result;
    }

    @NotNull
    private static Collection<PropertiesFile> getFiles(CommonSpringModel springModel, @NotNull List<? extends SpringBeanPointer> placeholders, Project project) {
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(4);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        if (placeholders.size() > 0) {
            PlaceholderPropertyReference.processXmlProperties((Processor<? super PropertiesFile>)processor, placeholders);
        }
        PlaceholderPropertyReference.processEmbeddedPropertySources((Processor<? super PropertiesFile>)processor, springModel);
        PlaceholderPropertyReference.processCommonModel(project, (Processor<? super PropertiesFile>)processor, springModel);
        Collection collection = processor.getResults();
        if (collection == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static void processCommonModel(@NotNull Project project, @NotNull Processor<? super PropertiesFile> processor, @NotNull CommonSpringModel springModel) {
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(7);
        }
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(8);
        }
        SpringModelVisitors.visitRelatedModels(springModel, CommonSpringModelVisitorContext.context(processor, (model, params) -> {
            if (processor == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(44);
            }
            if (project == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(45);
            }
            if (model instanceof SpringModel) {
                return PlaceholderPropertyReference.processFilesetCustomPropertiesFiles(processor, ((SpringModel)model).getFileSet(), project);
            }
            if (model instanceof LocalAnnotationModel) {
                return PlaceholderPropertyReference.processLocalAnnotationModelPropertySources(project, processor, (LocalAnnotationModel)model);
            }
            return true;
        }));
    }

    private static boolean processLocalAnnotationModelPropertySources(@NotNull Project project, @NotNull Processor<? super PropertiesFile> processor, @NotNull LocalAnnotationModel model) {
        SpringConfiguration configuration;
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(10);
        }
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(11);
        }
        if ((configuration = (SpringConfiguration)JamService.getJamService((Project)project).getJamElement(SpringConfiguration.JAM_KEY, model.getConfig())) != null) {
            for (SpringPropertySource source : configuration.getPropertySources()) {
                for (PropertiesFile propertiesFile : source.getPropertiesFiles()) {
                    if (processor.process((Object)propertiesFile)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processFilesetCustomPropertiesFiles(@NotNull Processor<? super PropertiesFile> processor, @Nullable SpringFileSet fileSet, @NotNull Project project) {
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(12);
        }
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(13);
        }
        if (fileSet == null) {
            return true;
        }
        Set<VirtualFilePointer> files = fileSet.getPropertiesFiles();
        for (VirtualFilePointer pointer : files) {
            PsiFile psiFile;
            VirtualFile virtualFile = pointer.getFile();
            if (virtualFile == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile) || processor.process((Object)((PropertiesFile)psiFile))) continue;
            return false;
        }
        return true;
    }

    static void processEmbeddedPropertySources(@NotNull Processor<? super PropertiesFile> processor, @NotNull CommonSpringModel model) {
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(14);
        }
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(15);
        }
        List<SpringJamPropertySource> propertySources = PlaceholderPropertyReference.getPropertySources(model);
        for (SpringJamPropertySource propertySource : propertySources) {
            for (PropertiesFile file : propertySource.getPropertiesFiles()) {
                processor.process((Object)file);
            }
        }
    }

    @NotNull
    private static List<SpringJamPropertySource> getPropertySources(CommonSpringModel model) {
        List list = ContainerUtil.filter(PlaceholderPropertyReference.getPropertySources(model.getModule()), source -> {
            PsiClass psiClass = source.getPsiElement();
            return psiClass.isValid() && SpringCommonUtils.isSpringBeanCandidateClass(psiClass) && SpringModelSearchers.doesBeanExist(model, SpringModelSearchParameters.byClass(psiClass));
        });
        if (list == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static List<SpringJamPropertySource> getPropertySources(@Nullable Module module) {
        if (module == null || DumbService.isDumb((Project)module.getProject())) {
            List<SpringJamPropertySource> list = Collections.emptyList();
            if (list == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            List propertySources = ContainerUtil.newSmartList();
            JamService jamService = JamService.getJamService((Project)module.getProject());
            propertySources.addAll(jamService.getJamClassElements(SpringJamPropertySource.META, "org.springframework.context.annotation.PropertySource", scope));
            for (SpringPropertySources springPropertySources : jamService.getJamClassElements(SpringPropertySources.META, "org.springframework.context.annotation.PropertySources", scope)) {
                propertySources.addAll(springPropertySources.getPropertySources());
            }
            return CachedValueProvider.Result.create((Object)propertySources, (Object[])SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies());
        });
        if (list == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(18);
        }
        return list;
    }

    static void processXmlProperties(@NotNull Processor<? super PropertiesFile> processor, @NotNull List<? extends SpringBeanPointer> placeholders) {
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(19);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(20);
        }
        for (PropertiesFile resource : PlaceholderUtils.getInstance().getResources(placeholders)) {
            if (!processor.process((Object)resource)) break;
        }
    }

    @NotNull
    private Set<DomElement> getPlaceholderConfigurerProperties(@NotNull String key, @NotNull List<SpringBeanPointer> placeholders) {
        Set set;
        if (key == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(21);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(22);
        }
        Set set2 = (set = (Set)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, () -> {
            if (placeholders == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(42);
            }
            if (key == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(43);
            }
            return PlaceholderPropertyReference.getAllPlaceholderConfigurerProperties(placeholders).get(key);
        })) == null ? Collections.emptySet() : set;
        if (set2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(23);
        }
        return set2;
    }

    @NotNull
    static Map<String, Set<DomElement>> getAllPlaceholderConfigurerProperties(List<? extends SpringBeanPointer> placeholders) {
        HashMap all = new HashMap();
        for (SpringBeanPointer springBeanPointer : placeholders) {
            PropertyPlaceholder propertyPlaceholder;
            SpringBeanPointer propertyBeanHolder;
            Object placeholderBean = springBeanPointer.getSpringBean();
            PlaceholderPropertyReference.addProperties((Map<String, Set<DomElement>>)all, placeholderBean);
            if (!(placeholderBean instanceof PropertyPlaceholder) || (propertyBeanHolder = (SpringBeanPointer)(propertyPlaceholder = (PropertyPlaceholder)placeholderBean).getPropertiesRef().getValue()) == null) continue;
            PlaceholderPropertyReference.addProperties((Map<String, Set<DomElement>>)all, propertyBeanHolder.getSpringBean());
        }
        HashMap hashMap = all;
        if (hashMap == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    private static void addProperties(Map<String, Set<DomElement>> all, CommonSpringBean bean) {
        SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName(bean, "properties");
        if (propertyDefinition instanceof SpringProperty) {
            for (Prop prop : ((SpringProperty)propertyDefinition).getProps().getProps()) {
                String propKey = prop.getKey().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)propKey)) continue;
                if (!all.containsKey(propKey)) {
                    all.put(propKey, new HashSet());
                }
                all.get(propKey).add((DomElement)prop);
            }
            for (SpringEntry springEntry : ((SpringProperty)propertyDefinition).getMap().getEntries()) {
                String keyAttr = springEntry.getKeyAttr().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)keyAttr)) continue;
                if (!all.containsKey(keyAttr)) {
                    all.put(keyAttr, new HashSet());
                }
                all.get(keyAttr).add(springEntry);
            }
            for (Object object : PlaceholderPropertyReference.getValueProperties((SpringProperty)propertyDefinition).keySet()) {
                if (!(object instanceof String)) continue;
                if (!all.containsKey(object)) {
                    all.put((String)object, new HashSet());
                }
                all.get(object).add(((SpringProperty)propertyDefinition).getValue());
            }
        }
    }

    public LocalQuickFix[] getQuickFixes() {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer> placeholders = this.getPlaceholders(model);
        Set<PropertiesFile> resources = PlaceholderUtils.getInstance().getResources(placeholders);
        return new LocalQuickFix[]{new CreatePropertyFix(this.getElement(), this.myKey, new ArrayList<PropertiesFile>(resources))};
    }

    public List<SpringBeanPointer> getPlaceholders(@NotNull CommonSpringModel model) {
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(25);
        }
        SmartList placeholders = new SmartList();
        for (SpringBeanPointer pointer : PlaceholderPropertyReference.getConfigurers(model, this.myElement.getProject())) {
            Pair<String, String> pair;
            if (!pointer.isValid() || !this.myInfo.prefixAndSuffix.equals(pair = PlaceholderUtils.getInstance().getPlaceholderPrefixAndSuffixInner(pointer))) continue;
            placeholders.add(pointer);
        }
        return placeholders;
    }

    @NotNull
    public static Collection<PropertiesFile> collectPropertiesFiles(@NotNull CommonSpringModel springModel, @NotNull List<? extends SpringBeanPointer> placeholders, @NotNull Project project) {
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(26);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(27);
        }
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(28);
        }
        if (springModel instanceof UserDataHolder) {
            Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)springModel, () -> {
                if (springModel == null) {
                    PlaceholderPropertyReference.$$$reportNull$$$0(39);
                }
                if (placeholders == null) {
                    PlaceholderPropertyReference.$$$reportNull$$$0(40);
                }
                if (project == null) {
                    PlaceholderPropertyReference.$$$reportNull$$$0(41);
                }
                return CachedValueProvider.Result.create(PlaceholderPropertyReference.getFiles(springModel, placeholders, project), (Object[])PlaceholderPropertyReference.getDependencies(project, placeholders));
            });
            if (collection == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(29);
            }
            return collection;
        }
        Collection<PropertiesFile> collection = PlaceholderPropertyReference.getFiles(springModel, placeholders, project);
        if (collection == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(30);
        }
        return collection;
    }

    @NotNull
    private static List<SpringBeanPointer> getConfigurers(@NotNull CommonSpringModel model, @NotNull Project project) {
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(31);
        }
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(32);
        }
        if (model instanceof UserDataHolder) {
            List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)model, () -> {
                if (model == null) {
                    PlaceholderPropertyReference.$$$reportNull$$$0(37);
                }
                if (project == null) {
                    PlaceholderPropertyReference.$$$reportNull$$$0(38);
                }
                List<SpringBeanPointer> configurers = SpringModelVisitorUtils.getPlaceholderConfigurers(model);
                return CachedValueProvider.Result.create(configurers, (Object[])PlaceholderPropertyReference.getDependencies(project, configurers));
            });
            if (list == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(33);
            }
            return list;
        }
        List<SpringBeanPointer> list = SpringModelVisitorUtils.getPlaceholderConfigurers(model);
        if (list == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    private static Object[] getDependencies(@NotNull Project project, List<? extends SpringBeanPointer> configurers) {
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(35);
        }
        LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAllNotNull((Collection)dependencies, (Iterable)configurers.stream().map(pointer -> pointer.getContainingFile()).collect(Collectors.toSet()));
        ContainerUtil.addAll((Collection)dependencies, (Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies());
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)dependencies);
        if (objectArray == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(36);
        }
        return objectArray;
    }

    public TextRange getFullTextRange() {
        return this.myInfo.fullTextRange;
    }

    @Nullable
    protected List<PropertiesFile> getPropertiesFiles() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/PlaceholderPropertyReference";
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 27: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 28: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 26: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 11: 
            case 15: 
            case 25: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/PlaceholderPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertySources";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurerProperties";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPlaceholderConfigurerProperties";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertiesFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurers";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCommonModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processLocalAnnotationModelPropertySources";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processFilesetCustomPropertiesFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processEmbeddedPropertySources";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processXmlProperties";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderConfigurerProperties";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertiesFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurers";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigurers$6";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectPropertiesFiles$5";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPlaceholderConfigurerProperties$4";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCommonModel$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

