/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class PlaceholderTextRanges {
    private PlaceholderTextRanges() {
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix) {
        if (s == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(2);
        }
        Set<TextRange> set = PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, false);
        if (set == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange) {
        if (s == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(5);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(6);
        }
        Set<TextRange> set = PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, useFullTextRange, false);
        if (set == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange, boolean filterNestedRanges) {
        int nextSuffix;
        int current;
        if (s == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(9);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(10);
        }
        if ((current = s.indexOf(prefix)) == -1) {
            Set<TextRange> set = Collections.emptySet();
            if (set == null) {
                PlaceholderTextRanges.$$$reportNull$$$0(11);
            }
            return set;
        }
        LinkedHashSet<TextRange> ranges = new LinkedHashSet<TextRange>(2);
        Stack<Integer> prefixes = new Stack<Integer>();
        prefixes.push(current);
        while (!(current < 0 || (nextSuffix = s.indexOf(suffix, current)) == -1 || nextSuffix == current && prefix.equals(suffix) && (nextSuffix = s.indexOf(suffix, current + 1)) == -1)) {
            int nextPrefix = s.indexOf(prefix, current + 1);
            while (nextPrefix > 0 && nextPrefix < nextSuffix) {
                prefixes.push(nextPrefix);
                nextPrefix = s.indexOf(prefix, nextPrefix + 1);
            }
            int startOffset = (Integer)prefixes.pop() + (useFullTextRange ? 0 : prefix.length());
            int endOffset = useFullTextRange ? nextSuffix + suffix.length() : nextSuffix;
            TextRange textRange = new TextRange(startOffset, endOffset);
            ranges.add(textRange);
            if (prefixes.isEmpty()) {
                current = s.indexOf(prefix, nextSuffix + suffix.length());
                prefixes.push(current);
                continue;
            }
            current = s.indexOf(prefix, nextSuffix);
            if (current > 0) {
                prefixes.push(current);
                continue;
            }
            current = s.indexOf(suffix, nextSuffix + suffix.length());
        }
        Set<TextRange> set = filterNestedRanges ? PlaceholderTextRanges.filterNested(ranges) : ranges;
        if (set == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static Set<TextRange> filterNested(Set<TextRange> allRanges) {
        LinkedHashSet<TextRange> filtered = new LinkedHashSet<TextRange>(allRanges.size());
        for (TextRange outer : allRanges) {
            boolean contains = PlaceholderTextRanges.anyRangeContains(allRanges, outer);
            if (contains) continue;
            filtered.add(outer);
        }
        return filtered;
    }

    private static boolean anyRangeContains(Set<TextRange> allRanges, TextRange inner) {
        for (TextRange outer : allRanges) {
            if (inner.equals((Object)outer) || !outer.contains(inner)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/PlaceholderTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/PlaceholderTextRanges";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderRanges";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

