/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeAssignableFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeAssignableFilter(@Nullable String expression) {
        super(expression);
    }

    @Override
    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(1);
        }
        LinkedHashSet components = ContainerUtil.newLinkedHashSet();
        String fqn = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)fqn)) {
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass assignableClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(fqn, searchScope);
            SpringContextIncludeAssignableFilter.addCustomComponents(packages, searchScope, components, assignableClass);
        }
        LinkedHashSet linkedHashSet = components;
        if (linkedHashSet == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    public static void addCustomComponents(@NotNull Set<? extends PsiPackage> packages, @NotNull GlobalSearchScope searchScope, @NotNull Set<? super SpringStereotypeElement> components, @Nullable PsiClass assignableClass) {
        if (packages == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(4);
        }
        if (components == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(5);
        }
        if (assignableClass == null) {
            return;
        }
        SpringContextIncludeAssignableFilter.addCustomComponent(components, assignableClass);
        for (PsiPackage psiPackage : packages) {
            GlobalSearchScope pkgSearchScope = searchScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
            Collection inheritors = ClassInheritorsSearch.search((PsiClass)assignableClass, (SearchScope)pkgSearchScope, (boolean)true).findAll();
            for (PsiClass psiClass : inheritors) {
                SpringContextIncludeAssignableFilter.addCustomComponent(components, psiClass);
            }
        }
    }

    private static void addCustomComponent(@NotNull Set<? super SpringStereotypeElement> components, @NotNull PsiClass componentCandidateClass) {
        if (components == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(6);
        }
        if (componentCandidateClass == null) {
            SpringContextIncludeAssignableFilter.$$$reportNull$$$0(7);
        }
        PsiModifierList modifierList = componentCandidateClass.getModifierList();
        if (componentCandidateClass.isInterface() || componentCandidateClass.isAnnotationType() || modifierList != null && modifierList.hasModifierProperty("abstract")) {
            return;
        }
        components.add(new CustomSpringComponent(componentCandidateClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentCandidateClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "includeStereotypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeStereotypes";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCustomComponents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCustomComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

