/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringOldJavaConfigurationUtil {
    public static List<JavaConfigConfiguration> getJavaConfigurations(@NotNull Module module) {
        if (module == null) {
            SpringOldJavaConfigurationUtil.$$$reportNull$$$0(0);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        return jamService.getJamClassElements(JavaConfigConfiguration.META, "org.springframework.config.java.annotation.Configuration", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    @NotNull
    public static List<SpringBeanPointer> findExternalBeans(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        PsiClass psiClass = psiMethod.getContainingClass();
        if (module == null || psiClass == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (SpringOldJavaConfigurationUtil.getExternalBean(psiMethod) == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList extBeans = new SmartList();
        for (SpringModel model : SpringManager.getInstance(psiMethod.getProject()).getAllModels(module)) {
            boolean hasJavaConfigBean = SpringModelSearchers.doesBeanExist((CommonSpringModel)model, SpringModelSearchParameters.byClass(psiClass));
            if (!hasJavaConfigBean) continue;
            String externalBeanName = psiMethod.getName();
            for (SpringBeanPointer springBean : SpringModelVisitorUtils.getAllDomBeans(model)) {
                String beanName = springBean.getName();
                if (!externalBeanName.equals(beanName) && !Arrays.asList(springBean.getAliases()).contains(externalBeanName)) continue;
                extBeans.add(springBean);
            }
        }
        SmartList smartList = extBeans;
        if (smartList == null) {
            SpringOldJavaConfigurationUtil.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    public static List<SpringJavaExternalBean> findExternalBeanReferences(CommonSpringBean springBean) {
        XmlTag element = springBean.getXmlTag();
        if (element == null) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        Set<String> beanNames = SpringBeanUtils.getInstance().findBeanNames(springBean);
        if (beanNames.isEmpty()) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                SpringOldJavaConfigurationUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<SpringJavaExternalBean> extBeans = new ArrayList<SpringJavaExternalBean>();
        for (SpringJavaConfiguration springJavaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
            if (!(springJavaConfiguration instanceof JavaConfigConfiguration)) continue;
            for (SpringJavaExternalBean springJavaExternalBean : ((JavaConfigConfiguration)springJavaConfiguration).getExternalBeans()) {
                PsiMethod psiMethod = springJavaExternalBean.getPsiElement();
                if (!beanNames.contains(psiMethod.getName())) continue;
                extBeans.add(springJavaExternalBean);
            }
        }
        ArrayList<SpringJavaExternalBean> arrayList = extBeans;
        if (arrayList == null) {
            SpringOldJavaConfigurationUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static SpringJavaExternalBean getExternalBean(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        if (module != null) {
            for (SpringJavaConfiguration springJavaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
                if (!(springJavaConfiguration instanceof JavaConfigConfiguration) || !psiMethod.getContainingFile().equals(springJavaConfiguration.getPsiClass().getContainingFile())) continue;
                for (SpringJavaExternalBean springJavaExternalBean : ((JavaConfigConfiguration)springJavaConfiguration).getExternalBeans()) {
                    if (!psiMethod.equals(springJavaExternalBean.getPsiElement())) continue;
                    return springJavaExternalBean;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalBeans";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalBeanReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJavaConfigurations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

