/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.events.jam.CustomSpringEventListener;
import com.intellij.spring.model.events.jam.SpringJamEventListener;
import com.intellij.spring.model.jam.SpringOrder;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.contexts.CustomContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.lookup.SpringLookupInjection;
import com.intellij.spring.model.jam.profile.CustomContextProfile;
import com.intellij.spring.model.jam.profile.SpringJamProfile;
import com.intellij.spring.model.jam.stereotype.CustomJamComponentScan;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.CustomSpringImport;
import com.intellij.spring.model.jam.stereotype.SpringCdiNamed;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringContextImport;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringImportResource;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringManagedBean;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.testContexts.CustomContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.SpringTestingDirtiesContext;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSql;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.jam.testContexts.profiles.SpringCustomActiveProfiles;
import com.intellij.spring.model.jam.testContexts.profiles.SpringJamActiveProfiles;
import com.intellij.spring.model.jam.testContexts.propertySources.CustomTestPropertySource;
import com.intellij.spring.model.jam.testContexts.propertySources.SpringTestPropertySource;
import com.intellij.spring.model.jam.transaction.SpringTransactionalComponent;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;

public class SpringSemContributor
extends SemContributor {
    private final SemService mySemService;

    public SpringSemContributor(SemService semService, UltimateVerifier verifier) {
        this.mySemService = semService;
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public void registerSemProviders(SemRegistrar registrar) {
        PsiClassPattern nonAnnoClass = (PsiClassPattern)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"});
        PsiClassPattern classPattern = (PsiClassPattern)PsiJavaPatterns.psiClass().withoutModifiers(new String[]{"private"});
        SpringComponent.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.stereotype.Component"));
        this.registerConfigurations(registrar);
        this.registerServices(registrar, nonAnnoClass);
        this.registerControllers(registrar, nonAnnoClass);
        this.registerRepositories(registrar, nonAnnoClass);
        this.registerProfiles(registrar);
        this.registerActiveProfiles(registrar);
        this.registerCustomComponents(registrar, nonAnnoClass);
        this.registerCustomContextConfigurations(registrar, nonAnnoClass);
        this.registerCustomComponentScans(registrar, nonAnnoClass);
        this.registerCustomImports(registrar, classPattern);
        this.registerCustomTestingPropertySources(registrar, nonAnnoClass);
        SpringCdiNamed.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("javax.inject.Named"));
        this.registerContextJavaBeans(registrar);
        this.registerEventListeners(registrar);
        SpringAliasFor.METHOD_META.register(registrar, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"})).withAnnotation("org.springframework.core.annotation.AliasFor"));
        SpringOrder.CLASS_META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.core.annotation.Order"));
        SpringOrder.FIELD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiField().withAnnotation("org.springframework.core.annotation.Order"));
        SpringOrder.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.core.annotation.Order"));
        SpringContextImport.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.Import"));
        SpringImportResource.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.ImportResource"));
        SpringJamComponentScan.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.ComponentScan"));
        registrar.registerSemElementProvider(SpringJamComponentScan.REPEATABLE_ANNO_JAM_KEY, (ElementPattern)PsiJavaPatterns.psiAnnotation().qName("org.springframework.context.annotation.ComponentScan"), annotation -> new SpringJamComponentScan((PsiAnnotation)annotation));
        SpringJamComponentScans.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.ComponentScans"));
        SpringJamPropertySource.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.PropertySource"));
        SpringPropertySources.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.PropertySources"));
        JavaConfigConfiguration.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.config.java.annotation.Configuration"));
        SpringContextConfiguration.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.test.context.ContextConfiguration"));
        SpringContextHierarchy.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.ContextHierarchy"));
        SpringTestPropertySource.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.TestPropertySource"));
        SpringTestingSql.CLASS_META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.jdbc.Sql"));
        SpringTestingSql.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(false).withAnnotation("org.springframework.test.context.jdbc.Sql"));
        SpringTestingDirtiesContext.CLASS_META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.annotation.DirtiesContext"));
        SpringTestingDirtiesContext.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(false).withAnnotation("org.springframework.test.annotation.DirtiesContext"));
        SpringTestingSqlConfig.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.jdbc.SqlConfig"));
        SpringTransactionConfiguration.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.transaction.TransactionConfiguration"));
        SpringTransactionalComponent.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.transaction.annotation.Transactional"));
        SpringManagedBean.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("javax.annotation.ManagedBean"));
        SpringLookupInjection.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(false).withAnnotation("org.springframework.beans.factory.annotation.Lookup"));
    }

    private void registerEventListeners(SemRegistrar registrar) {
        PsiMethodPattern methodPattern = (PsiMethodPattern)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"});
        SpringJamEventListener.METHOD_META.register(registrar, (ElementPattern)methodPattern.withAnnotation("org.springframework.context.event.EventListener"));
        this.registerCustomEventListeners(registrar, methodPattern);
    }

    private void registerProfiles(SemRegistrar registrar) {
        SpringJamProfile.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotation("org.springframework.context.annotation.Profile"));
        this.registerCustomProfiles(registrar, (ElementPattern<? extends PsiMember>)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"}));
        this.registerCustomProfiles(registrar, (ElementPattern<? extends PsiMember>)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"}));
    }

    private void registerActiveProfiles(SemRegistrar registrar) {
        SpringJamActiveProfiles.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.test.context.ActiveProfiles"));
        this.registerCustomActiveProfiles(registrar, (ElementPattern<? extends PsiMember>)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"}));
    }

    private void registerContextJavaBeans(SemRegistrar registrar) {
        PsiMethodPattern beanMethodPattern = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withoutModifiers(new String[]{"private"})).constructor(false);
        ContextJavaBean.METHOD_META.register(registrar, (ElementPattern)beanMethodPattern.withAnnotation("org.springframework.context.annotation.Bean"));
        this.registerCustomContextJavaBean(registrar, (PsiMethodPattern)beanMethodPattern.andNot((ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.context.annotation.Bean")));
    }

    private void registerCustomComponents(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, CustomSpringComponent.META_KEY, CustomSpringComponent.JAM_KEY, SpringSemContributorUtil.createFunction(CustomSpringComponent.JAM_KEY, CustomSpringComponent.class, SpringSemContributor.getUserDefinedCustomAnnotations(), pair -> new CustomSpringComponent((String)pair.first, (PsiClass)pair.second), SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerCustomComponentScans(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, CustomJamComponentScan.META_KEY, CustomJamComponentScan.JAM_KEY, SpringSemContributorUtil.createFunction(CustomJamComponentScan.JAM_KEY, CustomJamComponentScan.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.context.annotation.ComponentScan"), pair -> new CustomJamComponentScan((String)pair.first, (PsiClass)pair.second), null, SpringAliasForUtils.getAnnotationMetaProducer(CustomJamComponentScan.JAM_ANNO_META_KEY, new JamMemberMeta[]{SpringJamComponentScan.META})));
    }

    private void registerCustomContextConfigurations(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, CustomContextConfiguration.META_KEY, CustomContextConfiguration.JAM_KEY, SpringSemContributorUtil.createFunction(CustomContextConfiguration.JAM_KEY, CustomContextConfiguration.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.test.context.ContextConfiguration", true), pair -> new CustomContextConfiguration((String)pair.first, (PsiClass)pair.second), null, SpringAliasForUtils.getAnnotationMetaProducer(CustomContextConfiguration.JAM_ANNO_META_KEY, new JamMemberMeta[]{SpringContextConfiguration.META})));
    }

    private void registerCustomImports(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerRepeatableMetaComponents(this.mySemService, registrar, psiClassPattern, CustomSpringImport.META_KEY, CustomSpringImport.JAM_KEY, SpringSemContributorUtil.createRepeatableFunction(CustomSpringImport.JAM_KEY, CustomSpringImport.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.context.annotation.Import", true), pair -> new CustomSpringImport((String)pair.first, (PsiClass)pair.second), null, null));
    }

    private void registerCustomTestingPropertySources(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, CustomTestPropertySource.META_KEY, CustomTestPropertySource.JAM_KEY, SpringSemContributorUtil.createFunction(CustomTestPropertySource.JAM_KEY, CustomTestPropertySource.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.test.context.TestPropertySource", true), pair -> new CustomTestPropertySource((String)pair.first, (PsiClass)pair.second), null, SpringAliasForUtils.getAnnotationMetaProducer(CustomTestPropertySource.JAM_ANNO_META_KEY, new JamMemberMeta[]{SpringTestPropertySource.META})));
    }

    private void registerCustomEventListeners(SemRegistrar registrar, PsiMethodPattern psiMethodPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiMethodPattern, CustomSpringEventListener.META_KEY, CustomSpringEventListener.JAM_KEY, SpringSemContributorUtil.createFunction(CustomSpringEventListener.JAM_KEY, CustomSpringEventListener.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.context.event.EventListener", true), pair -> new CustomSpringEventListener((String)pair.first, (PsiMethod)pair.second), null));
    }

    private void registerCustomProfiles(SemRegistrar registrar, ElementPattern<? extends PsiMember> pattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, pattern, CustomContextProfile.META_KEY, CustomContextProfile.JAM_KEY, SpringSemContributorUtil.createFunction(CustomContextProfile.JAM_KEY, CustomContextProfile.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.context.annotation.Profile", true), pair -> new CustomContextProfile((String)pair.first, (PsiMember)pair.second), null));
    }

    private void registerCustomActiveProfiles(SemRegistrar registrar, ElementPattern<? extends PsiMember> pattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, pattern, SpringCustomActiveProfiles.META_KEY, SpringCustomActiveProfiles.JAM_KEY, SpringSemContributorUtil.createFunction(SpringCustomActiveProfiles.JAM_KEY, SpringCustomActiveProfiles.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.test.context.ActiveProfiles", true), pair -> new SpringCustomActiveProfiles((String)pair.first, (PsiMember)pair.second), null));
    }

    private void registerCustomContextJavaBean(SemRegistrar registrar, PsiMethodPattern pattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, pattern, CustomContextJavaBean.META_KEY, CustomContextJavaBean.JAM_KEY, SpringSemContributorUtil.createFunction(CustomContextJavaBean.JAM_KEY, CustomContextJavaBean.class, SpringSemContributorUtil.getCustomMetaAnnotations("org.springframework.context.annotation.Bean"), pair -> new CustomContextJavaBean((String)pair.first, (PsiMethod)pair.second), null, SpringAliasForUtils.getAnnotationMetaProducer(CustomContextJavaBean.JAM_ANNO_META_KEY, new JamMemberMeta[]{ContextJavaBean.METHOD_META})));
    }

    private void registerConfigurations(SemRegistrar registrar) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"abstract"}), SpringConfiguration.META_KEY, SpringConfiguration.JAM_KEY, SpringSemContributorUtil.createFunction(SpringConfiguration.JAM_KEY, SpringConfiguration.class, SpringConfiguration.getAnnotations(), pair -> new SpringConfiguration((String)pair.first, (PsiClass)pair.second), SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerControllers(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, SpringController.META_KEY, SpringController.JAM_KEY, SpringSemContributorUtil.createFunction(SpringController.JAM_KEY, SpringController.class, SpringController.getControllerAnnotations(), pair -> new SpringController((String)pair.first, (PsiClass)pair.second), SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerRepositories(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, SpringRepository.META_KEY, SpringRepository.JAM_KEY, SpringSemContributorUtil.createFunction(SpringRepository.JAM_KEY, SpringRepository.class, SpringRepository.getRepositoryAnnotations(), pair -> new SpringRepository((String)pair.first, (PsiClass)pair.second), SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerServices(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents(this.mySemService, registrar, psiClassPattern, SpringService.META_KEY, SpringService.JAM_KEY, SpringSemContributorUtil.createFunction(SpringService.JAM_KEY, SpringService.class, SpringService.getServiceAnnotations(), pair -> new SpringService((String)pair.first, (PsiClass)pair.second), SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private static Function<Module, Collection<String>> getUserDefinedCustomAnnotations() {
        return module -> module == null ? Collections.emptySet() : JamAnnotationTypeUtil.getInstance(module).getUserDefinedCustomComponentAnnotations();
    }
}

