/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.factories.SpringFactoryBeansManagerImpl;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryMethodInspection
extends SpringBeanInspectionBase {
    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringFactoryMethodInspection" == null) {
            FactoryMethodInspection.$$$reportNull$$$0(0);
        }
        return "SpringFactoryMethodInspection";
    }

    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        GenericAttributeValue<PsiMethod> factoryMethodAttribute;
        if (springBean == null) {
            FactoryMethodInspection.$$$reportNull$$$0(1);
        }
        if (beans == null) {
            FactoryMethodInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            FactoryMethodInspection.$$$reportNull$$$0(3);
        }
        if (!DomUtil.hasXml(factoryMethodAttribute = springBean.getFactoryMethod())) {
            return;
        }
        PsiMethod factoryMethod = (PsiMethod)factoryMethodAttribute.getValue();
        if (factoryMethod != null) {
            boolean isStatic = factoryMethod.hasModifierProperty("static");
            SpringBeanPointer factoryBean = (SpringBeanPointer)springBean.getFactoryBean().getValue();
            if (!isStatic && factoryBean == null) {
                holder.createProblem(factoryMethodAttribute, SpringBundle.message("method.must.be.static", factoryMethod.getName()), new LocalQuickFix[0]);
            } else if (isStatic && factoryBean != null) {
                holder.createProblem(factoryMethodAttribute, SpringBundle.message("method.must.not.be.static", factoryMethod.getName()), new LocalQuickFix[0]);
            }
            if (!SpringFactoryBeansManagerImpl.hasFactoryReturnType(factoryMethod)) {
                holder.createProblem(factoryMethodAttribute, SpringBundle.message("method.cannot.instantiate.bean", factoryMethod.getName()), new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/FactoryMethodInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/FactoryMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

