/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractBeanReferencesInspection
extends SpringBeanInspectionBase {
    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            AbstractBeanReferencesInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            AbstractBeanReferencesInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            AbstractBeanReferencesInspection.$$$reportNull$$$0(2);
        }
        for (SpringValueHolderDefinition property : SpringPropertyUtils.getValueHolders(springBean)) {
            AbstractBeanReferencesInspection.checkAbstractBeanReferences(property, holder);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("AbstractBeanReferencesInspection" == null) {
            AbstractBeanReferencesInspection.$$$reportNull$$$0(3);
        }
        return "AbstractBeanReferencesInspection";
    }

    private static void checkAbstractBeanReferences(SpringValueHolderDefinition definition, DomElementAnnotationHolder holder) {
        SpringBeanPointer ref;
        GenericDomValue<SpringBeanPointer> refElement = definition.getRefElement();
        if (refElement != null && (ref = (SpringBeanPointer)refElement.getValue()) != null) {
            AbstractBeanReferencesInspection.checkNotAbstract(refElement, ref, holder);
        }
        if (definition instanceof SpringValueHolder) {
            SpringValueHolder springInjection = (SpringValueHolder)definition;
            AbstractBeanReferencesInspection.checkSpringRefBeans(springInjection.getRef(), holder);
            if (DomUtil.hasXml((DomElement)springInjection.getBean())) {
                SpringBean innerBean = springInjection.getBean();
                AbstractBeanReferencesInspection.checkNotAbstract(innerBean, BeanService.getInstance().createSpringBeanPointer(innerBean), holder);
            }
            AbstractBeanReferencesInspection.checkIdrefBeans(springInjection.getIdref(), holder);
            if (DomUtil.hasXml((DomElement)springInjection.getList())) {
                AbstractBeanReferencesInspection.checkCollectionReferences(springInjection.getList(), holder);
            }
            if (DomUtil.hasXml((DomElement)springInjection.getSet())) {
                AbstractBeanReferencesInspection.checkCollectionReferences(springInjection.getSet(), holder);
            }
            if (DomUtil.hasXml((DomElement)springInjection.getArray())) {
                AbstractBeanReferencesInspection.checkCollectionReferences(springInjection.getArray(), holder);
            }
            if (DomUtil.hasXml((DomElement)springInjection.getMap())) {
                AbstractBeanReferencesInspection.checkMapReferences(springInjection.getMap(), holder);
            }
        }
    }

    private static void checkNotAbstract(DomElement annotated, @Nullable SpringBeanPointer springBean, DomElementAnnotationHolder holder) {
        if (springBean != null && springBean.isAbstract()) {
            holder.createProblem(annotated, SpringBundle.message("spring.bean.referenced.by.abstract.bean", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkMapReferences(SpringMap map, DomElementAnnotationHolder beans) {
        for (SpringEntry entry : map.getEntries()) {
            AbstractBeanReferencesInspection.checkAbstractBeanReferences(entry, beans);
        }
    }

    private static void checkIdrefBeans(Idref idref, DomElementAnnotationHolder holder) {
        GenericAttributeValue<SpringBeanPointer> bean;
        if (!DomUtil.hasXml((DomElement)idref)) {
            return;
        }
        GenericAttributeValue<SpringBeanPointer> local = idref.getLocal();
        if (DomUtil.hasXml(local)) {
            AbstractBeanReferencesInspection.checkNotAbstract(local, (SpringBeanPointer)local.getValue(), holder);
        }
        if (DomUtil.hasXml(bean = idref.getBean())) {
            AbstractBeanReferencesInspection.checkNotAbstract(bean, (SpringBeanPointer)bean.getValue(), holder);
        }
    }

    private static void checkSpringRefBeans(SpringRef springRef, DomElementAnnotationHolder holder) {
        if (DomUtil.hasXml((DomElement)springRef)) {
            GenericAttributeValue<SpringBeanPointer> local;
            GenericAttributeValue<SpringBeanPointer> bean = springRef.getBean();
            if (DomUtil.hasXml(bean)) {
                AbstractBeanReferencesInspection.checkNotAbstract(bean, (SpringBeanPointer)bean.getValue(), holder);
            }
            if (DomUtil.hasXml(local = springRef.getLocal())) {
                AbstractBeanReferencesInspection.checkNotAbstract(local, (SpringBeanPointer)local.getValue(), holder);
            }
        }
    }

    private static void checkCollectionReferences(CollectionElements elements, DomElementAnnotationHolder holder) {
        for (SpringRef springRef : elements.getRefs()) {
            AbstractBeanReferencesInspection.checkSpringRefBeans(springRef, holder);
        }
        for (Idref idref : elements.getIdrefs()) {
            AbstractBeanReferencesInspection.checkIdrefBeans(idref, holder);
        }
        for (ListOrSet listOrSet : elements.getLists()) {
            AbstractBeanReferencesInspection.checkCollectionReferences(listOrSet, holder);
        }
        for (ListOrSet listOrSet : elements.getSets()) {
            AbstractBeanReferencesInspection.checkCollectionReferences(listOrSet, holder);
        }
        for (ListOrSet listOrSet : elements.getArrays()) {
            AbstractBeanReferencesInspection.checkCollectionReferences(listOrSet, holder);
        }
        for (SpringBean innerBean : elements.getBeans()) {
            AbstractBeanReferencesInspection.checkNotAbstract(innerBean, BeanService.getInstance().createSpringBeanPointer(innerBean), holder);
        }
        for (SpringMap map : elements.getMaps()) {
            AbstractBeanReferencesInspection.checkMapReferences(map, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/AbstractBeanReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/AbstractBeanReferencesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

