/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamReferenceContributorKt;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

public class SpringComponentScanInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass aClass;
        if (uClass == null) {
            SpringComponentScanInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringComponentScanInspection.$$$reportNull$$$0(1);
        }
        if ((aClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null || !SpringCommonUtils.isConfigurationOrMeta(aClass)) {
            return null;
        }
        PsiElement sourcePsiElement = UElementKt.getSourcePsiElement((UElement)uClass);
        if (sourcePsiElement == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsiElement.getContainingFile(), isOnTheFly);
        for (SpringBeansPackagesScan springBeansPackagesScan : SpringJamUtils.getInstance().getBeansPackagesScan(aClass)) {
            if (!(springBeansPackagesScan instanceof SpringComponentScan)) continue;
            SpringComponentScanInspection.checkComponentScan(holder, (SpringComponentScan)springBeansPackagesScan);
        }
        return holder.getResultsArray();
    }

    private static void checkComponentScan(ProblemsHolder holder, SpringComponentScan springComponentScan) {
        PsiAnnotation annotation = springComponentScan.getAnnotation();
        if (annotation == null) {
            return;
        }
        PsiElementRef ref = PsiElementRef.real((PsiElement)annotation);
        for (JamStringAttributeMeta.Collection<Collection<PsiPackage>> packageAttribute : springComponentScan.getPackageJamAttributes()) {
            for (JamStringAttributeElement stringAttributeElement : packageAttribute.getJam(ref)) {
                PsiLiteral literal = stringAttributeElement.getPsiLiteral();
                if (literal == null) continue;
                for (PsiReference reference : literal.getReferences()) {
                    PsiReference unwrapped = JamReferenceContributorKt.unwrapReference((PsiReference)reference);
                    if (!(unwrapped instanceof PsiPackageReference) || ((PsiPackageReference)unwrapped).multiResolve(false).length != 0) continue;
                    holder.registerProblem(reference);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "uClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/jam/SpringComponentScanInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

