/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class SpringUastConstructorAutowiringInspection
extends AbstractBaseUastLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SpringUastConstructorAutowiringInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringUastConstructorAutowiringInspection.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = aClass.getJavaPsi();
        PsiElement sourcePsi = aClass.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract") || !SpringAutowireUtil.isAutowiringRelevantClass(psiClass)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
        if (info.isStereotypeJavaBean()) {
            Set<PsiMethod> requiredConstructors;
            Set<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            HashMap autowiredConstructors = new HashMap();
            PsiMethod[] constructors = psiClass.getConstructors();
            boolean hasNoArgConstructor = constructors.length == 0;
            for (PsiMethod method : constructors) {
                if (!hasNoArgConstructor && method.getParameterList().getParametersCount() == 0) {
                    hasNoArgConstructor = true;
                }
                for (String annotation : annotations) {
                    PsiAnnotation autowiredAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{annotation});
                    if (autowiredAnno == null) continue;
                    autowiredConstructors.put(method, autowiredAnno);
                }
            }
            if (!hasNoArgConstructor && autowiredConstructors.size() == 0 && constructors.length > 1) {
                PsiElement identifier;
                boolean isContextBeanMapped = false;
                for (JamSpringBeanPointer pointer : info.getStereotypeMappedBeans()) {
                    if (!(pointer.getSpringBean() instanceof ContextJavaBean)) continue;
                    isContextBeanMapped = true;
                    break;
                }
                if (!isContextBeanMapped && (identifier = UElementKt.getSourcePsiElement((UElement)aClass.getUastAnchor())) != null) {
                    holder.registerProblem(identifier, SpringBundle.message("class.without.matching.constructor.for.autowiring", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
            if ((requiredConstructors = SpringUastConstructorAutowiringInspection.getRequiredConstructors((Map<PsiMethod, PsiAnnotation>)autowiredConstructors)).size() > 1) {
                for (PsiMethod constructor : requiredConstructors) {
                    PsiElement identifier;
                    UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)constructor, UMethod.class);
                    if (uMethod == null || (identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                    holder.registerProblem(identifier, SpringBundle.message("multiple.autowiring.constructor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
        return holder.getResultsArray();
    }

    @NotNull
    private static Set<PsiMethod> getRequiredConstructors(@NotNull Map<PsiMethod, PsiAnnotation> constructors) {
        if (constructors == null) {
            SpringUastConstructorAutowiringInspection.$$$reportNull$$$0(2);
        }
        HashSet requiredConstructors = new HashSet();
        for (Map.Entry<PsiMethod, PsiAnnotation> constructor : constructors.entrySet()) {
            PsiAnnotation annotation = constructor.getValue();
            PsiMethod method = constructor.getKey();
            if ("org.springframework.beans.factory.annotation.Autowired".equals(annotation.getQualifiedName())) {
                Boolean required = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"required");
                if (required != null && !required.booleanValue()) continue;
                requiredConstructors.add(method);
                continue;
            }
            requiredConstructors.add(method);
        }
        HashSet hashSet = requiredConstructors;
        if (hashSet == null) {
            SpringUastConstructorAutowiringInspection.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringUastConstructorAutowiringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringUastConstructorAutowiringInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredConstructors";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

