/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.impl.SpringModelsCreationContext;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringManagerImpl
extends SpringManager {
    private static final Key<CachedValue<Set<SpringModel>>> ALL_MODELS_MODULE_WITH_DEPS = Key.create((String)"ALL_MODELS_MODULE_WITH_DEPS");
    private static final Key<CachedValue<SpringModel>> MODULE_COMBINED_MODEL_KEY = Key.create((String)"MODULE_COMBINED_MODEL_KEY");
    private final Project myProject;

    public SpringManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public Object[] getModelsDependencies(@NotNull Module module, Object ... additional) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(6);
        Collections.addAll(dependencies, additional);
        Object[] objectArray = SpringManagerImpl.addModuleModelsDependencies(module, dependencies).toArray();
        if (objectArray == null) {
            SpringManagerImpl.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    private static Collection<Object> addModuleModelsDependencies(@NotNull Module module, Collection<Object> dependencies) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(2);
        }
        ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies());
        SpringFacet facet = SpringFacet.getInstance(module);
        if (facet != null) {
            dependencies.add(facet.getConfiguration());
        }
        Collection<Object> collection = dependencies;
        if (collection == null) {
            SpringManagerImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<SpringModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(4);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, ALL_MODELS_MODULE_WITH_DEPS, () -> {
            if (module == null) {
                SpringManagerImpl.$$$reportNull$$$0(44);
            }
            Set<SpringModel> models = this.computeAllModels(SpringModelsCreationContext.create(module));
            return CachedValueProvider.Result.create(models, (Object[])this.getModelsDependencies(module, SpringManagerImpl.getConfigs(models)));
        }, false);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private static Object[] getConfigs(@NotNull Set<SpringModel> models) {
        if (models == null) {
            SpringManagerImpl.$$$reportNull$$$0(6);
        }
        HashSet configs = ContainerUtil.newHashSet();
        for (SpringModel model : models) {
            configs.addAll(model.getRelatedModels().stream().filter(lm -> lm instanceof LocalModel).map(lm -> ((LocalModel)lm).getConfig()).collect(Collectors.toSet()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)configs);
        if (objectArray == null) {
            SpringManagerImpl.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @NotNull
    public Set<SpringModel> getAllModels(@NotNull SpringModelsCreationContext context) {
        if (context == null) {
            SpringManagerImpl.$$$reportNull$$$0(8);
        }
        Set<SpringModel> set = this.computeAllModels(context);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(10);
        }
        if (module.isDisposed()) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        Project project = module.getProject();
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            SpringFacet facet;
            if (module == null) {
                SpringManagerImpl.$$$reportNull$$$0(43);
            }
            if ((facet = SpringFacet.getInstance(module)) == null) {
                if (this.isAllowAutoConfiguration()) {
                    return SpringAutoConfiguredModels.getAutoConfiguredModels(module);
                }
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
            }
            Set<SpringFileSet> fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            if (fileSets.isEmpty() && this.isAllowAutoConfiguration()) {
                return SpringAutoConfiguredModels.getAutoConfiguredModels(module);
            }
            Set<SpringModel> models = SpringManagerImpl.createModelsWithoutDependencies(module, module);
            return CachedValueProvider.Result.create(models, (Object[])this.getModelsDependencies(module, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        });
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    private static Set<SpringModel> createModelsWithoutDependencies(@NotNull Module module, @Nullable Module contextModule) {
        SpringFacet facet;
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(13);
        }
        if ((facet = SpringFacet.getInstance(module)) == null) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(14);
            }
            return set;
        }
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (SpringFileSet set : SpringFileSetService.getInstance().getAllSets(facet)) {
            if (set.isRemoved()) continue;
            SpringModel model = SpringCombinedModelFactory.createModel(set, contextModule == null ? module : contextModule);
            ContainerUtil.addIfNotNull(models, (Object)model);
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    public boolean isAllowAutoConfiguration() {
        return SpringGeneralSettings.getInstance(this.myProject).isAllowAutoConfigurationMode();
    }

    @Override
    @NotNull
    public SpringModel getCombinedModel(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(16);
        }
        SpringModel springModel = (SpringModel)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, MODULE_COMBINED_MODEL_KEY, () -> {
            if (module == null) {
                SpringManagerImpl.$$$reportNull$$$0(42);
            }
            Set<SpringModel> models = this.getAllModels(module);
            return CachedValueProvider.Result.create((Object)new CombinedSpringModelImpl(models, module), (Object[])this.getModelsDependencies(module, SpringManagerImpl.getConfigs(models)));
        }, false);
        if (springModel == null) {
            SpringManagerImpl.$$$reportNull$$$0(17);
        }
        return springModel;
    }

    @Override
    @NotNull
    public Set<SpringModel> getSpringModelsByFile(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(18);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(19);
            }
            return set;
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Set<SpringModel> models;
            SpringContextDescriptor descriptor;
            if (file == null) {
                SpringManagerImpl.$$$reportNull$$$0(40);
            }
            if ((descriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(file)).equals(SpringContextDescriptor.LOCAL_CONTEXT)) {
                models = ContainerUtil.createMaybeSingletonSet((Object)SpringCombinedModelFactory.createSingleModel(file, module));
            } else if (descriptor.equals(SpringContextDescriptor.ALL_CONTEXTS)) {
                models = SpringCombinedModelFactory.findModelsInScope(file, module);
            } else {
                Module descriptorModule = descriptor.getModule();
                Set<SpringModel> allModels = this.getAllModels(SpringModelsCreationContext.create(descriptorModule != null ? descriptorModule : module));
                models = allModels.stream().filter(model -> {
                    SpringFileSet fileSet;
                    if (file == null) {
                        SpringManagerImpl.$$$reportNull$$$0(41);
                    }
                    if ((fileSet = model.getFileSet()) == null) {
                        return false;
                    }
                    return descriptor.getId().equals(fileSet.getId()) && SpringManagerImpl.isConfiguredInModel(file, model);
                }).collect(Collectors.toSet());
            }
            return CachedValueProvider.Result.create(models, (Object[])this.getSpringModelDependencies(models, module.getProject()).toArray());
        });
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(20);
        }
        return set;
    }

    private static boolean isConfiguredInModel(@NotNull PsiFile file, @NotNull SpringModel model) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(21);
        }
        if (model == null) {
            SpringManagerImpl.$$$reportNull$$$0(22);
        }
        return SpringCombinedModelFactory.isConfiguredInFileSet(model, file.getOriginalFile().getVirtualFile()) || SpringModelVisitorUtils.hasConfigFile(model, file);
    }

    @Override
    @Nullable
    public SpringModel getSpringModelByFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(23);
        }
        return (SpringModel)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Set<SpringModel> allModels;
            if (file == null) {
                SpringManagerImpl.$$$reportNull$$$0(39);
            }
            SpringModel modelByFile = (allModels = this.getSpringModelsByFile(file)).size() == 0 ? null : (allModels.size() == 1 ? allModels.iterator().next() : new CombinedSpringModelImpl(allModels, allModels.iterator().next().getModule()));
            return CachedValueProvider.Result.create((Object)modelByFile, (Object[])this.getSpringModelDependencies(allModels, file.getProject()).toArray());
        });
    }

    @NotNull
    public Set<ModificationTracker> getSpringModelDependencies(@NotNull Set<SpringModel> allModels, @NotNull Project project) {
        if (allModels == null) {
            SpringManagerImpl.$$$reportNull$$$0(24);
        }
        if (project == null) {
            SpringManagerImpl.$$$reportNull$$$0(25);
        }
        HashSet modificationTrackers = ContainerUtil.newHashSet();
        modificationTrackers.add(SpringModificationTrackersManager.getInstance(project).getMultipleContextsModificationTracker());
        modificationTrackers.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        modificationTrackers.add(ProjectRootManager.getInstance((Project)project));
        for (SpringModel model : allModels) {
            SpringFileSet fileSet = model.getFileSet();
            if (fileSet == null) continue;
            ContainerUtil.addIfNotNull((Collection)modificationTrackers, (Object)fileSet.getFacet().getConfiguration());
        }
        HashSet hashSet = modificationTrackers;
        if (hashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    private Set<SpringModel> computeAllModels(@NotNull SpringModelsCreationContext context) {
        LinkedHashSet<SpringModel> result;
        block3: {
            Module contextModule;
            block2: {
                if (context == null) {
                    SpringManagerImpl.$$$reportNull$$$0(27);
                }
                contextModule = context.getModule();
                result = new LinkedHashSet<SpringModel>(this.getAllModelsWithoutDependencies(contextModule));
                if (!context.onlyCurrentModule()) break block2;
                if (!result.isEmpty()) break block3;
                result.addAll(SpringManagerImpl.getModelsFromDependencies(contextModule));
                if (!result.isEmpty()) break block3;
                result.addAll(SpringManagerImpl.getModelsFromDependentModules(contextModule));
                break block3;
            }
            for (Module module : SpringManagerImpl.getRelatedModules(context)) {
                if (module.equals(contextModule)) continue;
                result.addAll(this.getAllModelsWithoutDependencies(module));
            }
        }
        Set<SpringModel> springModels = Collections.unmodifiableSet(result);
        SpringManagerImpl.processFileSetDependencies(springModels);
        return springModels;
    }

    @NotNull
    private static Set<Module> getRelatedModules(@NotNull SpringModelsCreationContext context) {
        if (context == null) {
            SpringManagerImpl.$$$reportNull$$$0(28);
        }
        Module contextModule = context.getModule();
        HashSet relatedModules = ContainerUtil.newHashSet();
        if (context.isLoadModelsFromModuleDependencies()) {
            ModuleUtilCore.getDependencies((Module)contextModule, (Set)relatedModules);
        }
        if (context.isLoadModelsFromDependentModules()) {
            LinkedHashSet dependentModules = new LinkedHashSet();
            ModuleUtilCore.collectModulesDependsOn((Module)contextModule, dependentModules);
            relatedModules.addAll(dependentModules);
        }
        HashSet hashSet = relatedModules;
        if (hashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    @NotNull
    private static Set<SpringModel> getModelsFromDependencies(@NotNull Module contextModule) {
        if (contextModule == null) {
            SpringManagerImpl.$$$reportNull$$$0(30);
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)contextModule, dependencies);
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (Module dep : dependencies) {
            if (dep.equals(contextModule)) continue;
            models.addAll(SpringManagerImpl.createModelsWithoutDependencies(dep, contextModule));
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(31);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<SpringModel> getModelsFromDependentModules(@NotNull Module contextModule) {
        if (contextModule == null) {
            SpringManagerImpl.$$$reportNull$$$0(32);
        }
        LinkedHashSet dependentModules = new LinkedHashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)contextModule, dependentModules);
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (Module dep : dependentModules) {
            if (dep.equals(contextModule)) continue;
            models.addAll(SpringManagerImpl.createModelsWithoutDependencies(dep, dep));
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(33);
        }
        return linkedHashSet;
    }

    private static void processFileSetDependencies(@NotNull Set<SpringModel> models) {
        if (models == null) {
            SpringManagerImpl.$$$reportNull$$$0(34);
        }
        for (SpringModel model : models) {
            SpringManagerImpl.resolveDependencies(new LinkedHashSet<SpringModel>(models), model);
        }
    }

    private static void resolveDependencies(@NotNull Set<SpringModel> dependenciesCandidates, @NotNull SpringModel model) {
        SpringFileSet fileSet;
        if (dependenciesCandidates == null) {
            SpringManagerImpl.$$$reportNull$$$0(35);
        }
        if (model == null) {
            SpringManagerImpl.$$$reportNull$$$0(36);
        }
        if ((fileSet = model.getFileSet()) == null) {
            return;
        }
        Set<SpringFileSet> dependencyFileSets = fileSet.getDependencyFileSets();
        if (dependencyFileSets.isEmpty()) {
            return;
        }
        LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
        for (SpringFileSet depend : dependencyFileSets) {
            SpringModel candidateModel;
            SpringModel resolvedModel = SpringManagerImpl.findResolvedModel(model, depend, dependenciesCandidates.toArray(new SpringModel[0]));
            if (resolvedModel != null) {
                dependencies.add(resolvedModel);
                continue;
            }
            Module module = model.getModule();
            if (module == null || (candidateModel = SpringCombinedModelFactory.createModel(depend, module)) == null) continue;
            dependencies.add(candidateModel);
            dependenciesCandidates.add(candidateModel);
            SpringManagerImpl.resolveDependencies(dependenciesCandidates, candidateModel);
        }
        model.setDependencies(dependencies);
    }

    @Nullable
    private static SpringModel findResolvedModel(@NotNull SpringModel model, SpringFileSet depend, SpringModel ... candidates) {
        if (model == null) {
            SpringManagerImpl.$$$reportNull$$$0(37);
        }
        if (candidates == null) {
            SpringManagerImpl.$$$reportNull$$$0(38);
        }
        for (SpringModel depModel : candidates) {
            if (depModel == model || !depend.equals(depModel.getFileSet())) continue;
            return depModel;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringManagerImpl";
                break;
            }
            case 6: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 8: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 21: 
            case 23: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesCandidates";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleModelsDependencies";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModelsWithoutDependencies";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelsWithoutDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedModel";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelsByFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModules";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsFromDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsFromDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelsDependencies";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModuleModelsDependencies";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllModels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllModelsWithoutDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createModelsWithoutDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedModel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelsByFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredInModel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelByFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelDependencies";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "computeAllModels";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedModules";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModelsFromDependencies";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getModelsFromDependentModules";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processFileSetDependencies";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependencies";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findResolvedModel";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSpringModelByFile$7";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSpringModelsByFile$6";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCombinedModel$4";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllModelsWithoutDependencies$3";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllModels$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

