/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public abstract class SpringAnnotatorBase
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UElement element;
        if (psiElement == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(1);
        }
        if ((element = UastUtils.getUParentForIdentifier((PsiElement)psiElement)) instanceof UMethod) {
            this.annotateMethod((UMethod)element, result);
        } else if (element instanceof UClass) {
            this.annotateClass(result, (UClass)element);
        }
    }

    protected void annotateClass(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, UClass uClass) {
        PsiElement identifier;
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(2);
        }
        if ((identifier = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor())) == null) {
            return;
        }
        this.annotateClass(result, uClass, identifier);
    }

    protected void annotateMethod(UMethod method, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiElement identifier;
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(3);
        }
        if ((identifier = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor())) == null) {
            return;
        }
        this.annotateMethod(method, identifier, result);
    }

    protected void annotateMethod(UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
    }

    protected void annotateClass(Collection<? super RelatedItemLineMarkerInfo> result, UClass uClass, PsiElement identifier) {
    }

    public final void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(4);
        }
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(5);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringAnnotatorBase.hasFacetsOrAutoConfigurationMode(psiElement) || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    private static boolean hasFacetsOrAutoConfigurationMode(PsiElement psiElement) {
        return SpringCommonUtils.hasSpringFacets(psiElement.getProject()) || SpringGeneralSettings.getInstance(psiElement.getProject()).isAllowAutoConfigurationMode();
    }

    @Deprecated
    protected PsiElement getIdentifierLocal(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(6);
        }
        return SpringAnnotatorBase.getIdentifier(annotation);
    }

    @Deprecated
    @Nullable
    protected PsiElement getElementToProcess(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(7);
        }
        if (psiElement instanceof PsiIdentifier) {
            return psiElement.getParent();
        }
        return null;
    }

    public static PsiElement getIdentifier(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement identifier;
        if (annotation == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(8);
        }
        return (identifier = annotation.getNameReferenceElement()) == null ? null : identifier.getReferenceNameElement();
    }

    protected static void addSpringJavaBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends CommonModelElement>> targets, Icon icon) {
        SpringGutterIconBuilder<CommonModelElement> builder = SpringGutterIconBuilder.createBuilder(icon, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_CONVERTOR, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_GOTO_PROVIDER);
        builder.setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add(builder.createSpringGroupLineMarkerInfo(psiIdentifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/gutter/SpringAnnotatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdentifierLocal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

