/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.editor;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringContextIcons;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.ui.ListCellRendererWithRightAlignedComponent;

class ParentContextListCellRenderer
extends ListCellRendererWithRightAlignedComponent<SpringFileSet> {
    ParentContextListCellRenderer() {
    }

    protected void customize(SpringFileSet fileSet) {
        String leftText = fileSet == null ? SpringBundle.message("facet.context.edit.parent.none.selected", new Object[0]) : fileSet.getName();
        this.setLeftText(leftText);
        if (fileSet != null) {
            Module module = fileSet.getFacet().getModule();
            if (module.isDisposed()) {
                this.clear();
                return;
            }
            this.setIcon(fileSet.getIcon());
            this.setRightText(module.getName());
            this.setRightIcon(ModuleType.get((Module)module).getIcon());
        } else {
            this.clear();
        }
    }

    private void clear() {
        this.setIcon(SpringContextIcons.ParentContext);
        this.setRightText("");
        this.setRightIcon(null);
    }
}

