/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.BeanNamesMapper;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelIndexProcessor;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.dom.PlaceholderDomReferenceInjector;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.impl.SpringLocalModelFactoryImpl;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalXmlModelImpl
extends LocalXmlModel {
    private final XmlFile myConfigFile;
    private final Module myModule;
    private final Set<String> myActiveProfiles;
    private final LocalXmlModelIndexProcessor myIndexProcessor;
    private final NotNullLazyValue<BeanNamesMapper> myLocalBeanNamesMapper;
    private CachedValue<CommonSpringModel> javaConfigurationModel;
    private CachedValue<CommonSpringModel> explicitlyDefinedBeansModel;
    private CachedValue<List<SpringBeanPointer>> myPlaceholders;
    private final Map<String, Collection<XmlTag>> myCustomBeanIdCandidates;
    private CachedValue<Set<String>> myProfiles;
    private CachedValue<List<SpringBeanPointer>> myAnnotationConfigApplicationContexts;
    private CachedValue<List<SpringBeansPackagesScan>> myComponentScanBeans;
    private CachedValue<MultiMap<SpringBeanPointer, SpringBeanPointer>> myDirectInheritorsMap;
    private static final Key<CachedValue<Map<XmlFile, LocalModelDependency>>> IMPORT_FILES_KEY = Key.create((String)"IMPORT_FILES_KEY");
    private static final Key<ParameterizedCachedValue<Set<PsiClass>, GlobalSearchScope>> EXPLICIT_BEAN_CLASSES = Key.create((String)"explicitBeanClasses");

    @NotNull
    private Set<String> computeProfiles() {
        DomFileElement<Beans> element = this.getRoot();
        Set<String> set = element == null ? Collections.emptySet() : SpringProfileUtils.getAllProfiles((Beans)element.getRootElement());
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    public LocalXmlModelImpl(@NotNull XmlFile configFile, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (configFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(1);
        }
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(2);
        }
        if (activeProfiles == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(3);
        }
        this.myLocalBeanNamesMapper = new VolatileNotNullLazyValue<BeanNamesMapper>(){

            @NotNull
            protected BeanNamesMapper compute() {
                BeanNamesMapper beanNamesMapper = new BeanNamesMapper(LocalXmlModelImpl.this);
                if (beanNamesMapper == null) {
                    1.$$$reportNull$$$0(0);
                }
                return beanNamesMapper;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$1", "compute"));
            }
        };
        this.myConfigFile = configFile;
        this.myModule = module;
        this.myActiveProfiles = activeProfiles;
        this.myIndexProcessor = (LocalXmlModelIndexProcessor)CachedValuesManager.getCachedValue((PsiElement)this.myConfigFile, () -> {
            if (configFile == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(49);
            }
            return LocalXmlModelImpl.createIndexProcessor(configFile);
        });
        this.myCustomBeanIdCandidates = ConcurrentFactoryMap.createMap(key -> {
            if (!this.canProcessBeans()) {
                return Collections.emptyList();
            }
            return this.myIndexProcessor.getCustomBeanCandidates((String)key);
        });
    }

    @NotNull
    private static CachedValueProvider.Result<LocalXmlModelIndexProcessor> createIndexProcessor(@NotNull XmlFile configFile) {
        if (configFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(4);
        }
        CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)new LocalXmlModelIndexProcessor(configFile), (Object[])SpringLocalModelFactoryImpl.getLocalXmlModelDependencies(configFile));
        if (result == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(5);
        }
        return result;
    }

    @Override
    @Nullable
    public DomFileElement<Beans> getRoot() {
        return SpringDomUtils.getSpringDomFileElement(this.myConfigFile);
    }

    private Project getProject() {
        return this.myConfigFile.getProject();
    }

    @Override
    @NotNull
    public XmlFile getConfig() {
        XmlFile xmlFile = this.myConfigFile;
        if (xmlFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(6);
        }
        return xmlFile;
    }

    @Override
    public Collection<XmlTag> getCustomBeans(String id) {
        return this.myCustomBeanIdCandidates.get(id);
    }

    private BeanNamesMapper getLocalBeanNamesMapper() {
        return (BeanNamesMapper)this.myLocalBeanNamesMapper.getValue();
    }

    @Override
    @NotNull
    public Set<String> getAllBeanNames(@NotNull SpringBeanPointer beanPointer) {
        String beanName;
        if (beanPointer == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(7);
        }
        THashSet tHashSet = StringUtil.isEmptyOrSpaces((String)(beanName = beanPointer.getName())) ? Collections.emptySet() : new THashSet(this.getLocalBeanNamesMapper().getAllBeanNames(beanName));
        if (tHashSet == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(8);
        }
        return tHashSet;
    }

    @Override
    public Collection<PsiElementPointer> getDuplicatedBeanNames(@NotNull String beanName) {
        if (beanName == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(9);
        }
        return this.getLocalBeanNamesMapper().getDuplicatedNames(beanName);
    }

    @Override
    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        ArrayList beans = new ArrayList();
        Processor processor = bean -> {
            beans.add(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean));
            return true;
        };
        DomFileElement<Beans> element = this.getRoot();
        if (element != null) {
            this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor);
        }
        return Collections.unmodifiableList(beans);
    }

    @Override
    public Set<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAllNotNull((Collection)models, (Iterable)this.getDependentLocalModels().stream().map(pair -> (LocalModel)pair.first).collect(Collectors.toSet()));
        ContainerUtil.addAllNotNull((Collection)models, this.getCachedPackageScanModel());
        ContainerUtil.addAllNotNull((Collection)models, (Object[])new CommonSpringModel[]{this.getCustomDiscoveredBeansModel()});
        if (SpringCommonUtils.findLibraryClass(this.getModule(), "org.springframework.config.java.annotation.Configuration") != null) {
            ContainerUtil.addIfNotNull((Collection)models, (Object)this.getOldJavaConfigurationBeansModel());
        }
        if (LocalXmlModelImpl.isProcessExplicitlyDefinedAnnotatedBeans(this.getModule())) {
            ContainerUtil.addIfNotNull((Collection)models, (Object)this.getExplicitlyDefinedBeansModel());
        }
        return models;
    }

    private Set<CommonSpringModel> getCachedPackageScanModel() {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)this.getConfig(), () -> CachedValueProvider.Result.create(this.getPackagesScans().stream().map(scan -> new SpringComponentScanModel<SpringBeansPackagesScan>(this.getModule(), (SpringBeansPackagesScan)scan, this.getActiveProfiles())).collect(Collectors.toSet()), (Object[])this.getOutsideModelDependencies(this)));
    }

    private CommonSpringModel getOldJavaConfigurationBeansModel() {
        if (this.javaConfigurationModel == null) {
            this.javaConfigurationModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                BeansSpringModel model = new BeansSpringModel(this.getModule(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        LinkedHashSet pointers = ContainerUtil.newLinkedHashSet();
                        for (SpringJavaConfiguration springJavaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(LocalXmlModelImpl.this.myModule)) {
                            for (SpringJavaBean springJavaBean : springJavaConfiguration.getBeans()) {
                                if (!springJavaBean.isPublic()) continue;
                                pointers.add(BeanService.getInstance().createSpringBeanPointer(springJavaBean));
                            }
                        }
                        LinkedHashSet linkedHashSet = pointers;
                        if (linkedHashSet == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return linkedHashSet;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$2", "compute"));
                    }
                });
                return CachedValueProvider.Result.create((Object)model, (Object[])this.getOutsideModelDependencies(this));
            }, false);
        }
        return (CommonSpringModel)this.javaConfigurationModel.getValue();
    }

    private void processDomBeans(@NotNull Beans rootElement, Processor<CommonSpringBean> processor) {
        if (rootElement == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(10);
        }
        if (SpringProfileUtils.isActiveProfile(rootElement, this.getActiveProfiles())) {
            SpringBeanUtils.getInstance().processChildBeans(rootElement, false, processor);
            for (Beans profile : rootElement.getBeansProfiles()) {
                this.processDomBeans(profile, processor);
            }
        }
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getDescendantBeans(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(11);
        }
        THashSet visited = new THashSet();
        visited.add(pointer);
        MultiMap<SpringBeanPointer, SpringBeanPointer> map = this.getDirectInheritorsMap();
        LocalXmlModelImpl.addDescendants(map, pointer, (Set<SpringBeanPointer>)visited);
        visited.remove(pointer);
        SmartList smartList = new SmartList((Collection)visited);
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    private static void addDescendants(MultiMap<SpringBeanPointer, SpringBeanPointer> map, SpringBeanPointer current, Set<SpringBeanPointer> result) {
        Collection pointers = map.get((Object)current);
        for (SpringBeanPointer pointer : pointers) {
            if (!result.add(pointer)) continue;
            LocalXmlModelImpl.addDescendants(map, pointer, result);
        }
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(13);
        }
        return module;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurerBeans() {
        if (this.myPlaceholders == null) {
            this.myPlaceholders = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computePlaceholders(), (Object[])this.getOutsideModelDependencies(this)), false);
        }
        List list = (List)this.myPlaceholders.getValue();
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    private CachedValue<List<SpringBeansPackagesScan>> getComponentScanBeans() {
        if (this.myComponentScanBeans == null) {
            this.myComponentScanBeans = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.canProcessBeans() ? this.myIndexProcessor.getComponentScans() : Collections.emptyList(), (Object[])this.getOutsideModelDependencies(this)), false);
        }
        return this.myComponentScanBeans;
    }

    private MultiMap<SpringBeanPointer, SpringBeanPointer> getDirectInheritorsMap() {
        if (this.myDirectInheritorsMap == null) {
            this.myDirectInheritorsMap = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computeDirectInheritorsMap(), (Object[])this.getOutsideModelDependencies(this)), false);
        }
        return (MultiMap)this.myDirectInheritorsMap.getValue();
    }

    @Override
    @NotNull
    public List<SpringBeansPackagesScan> getPackagesScans() {
        Set<String> activeProfiles = this.getActiveProfiles();
        List allComponentScans = (List)this.getComponentScanBeans().getValue();
        if (activeProfiles.isEmpty()) {
            List list = allComponentScans;
            if (list == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Collection)allComponentScans, scan -> {
            if (scan instanceof DomSpringBean && SpringProfileUtils.isInActiveProfile((DomSpringBean)((Object)scan), activeProfiles)) {
                return scan;
            }
            return null;
        });
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigAppContexts() {
        if (this.myAnnotationConfigApplicationContexts == null) {
            this.myAnnotationConfigApplicationContexts = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computeAnnotationConfigApplicationContexts(), (Object[])this.getOutsideModelDependencies(this)), false);
        }
        List list = (List)this.myAnnotationConfigApplicationContexts.getValue();
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getProfiles() {
        if (this.myProfiles == null) {
            this.myProfiles = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.computeProfiles(), (Object[])this.getOutsideModelDependencies(this)), false);
        }
        Set set = (Set)this.myProfiles.getValue();
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalXmlModel)) {
            return false;
        }
        LocalXmlModel model = (LocalXmlModel)o;
        if (!this.myConfigFile.equals(model.getConfig())) {
            return false;
        }
        if (!this.myModule.equals(model.getModule())) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.getActiveProfiles()));
    }

    public int hashCode() {
        int result = this.myConfigFile.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(21);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            return true;
        }
        if (!this.processLocalBeansByClass(params, processor).booleanValue()) {
            return false;
        }
        return SpringModelVisitors.visitRelatedModels(this, CommonSpringModelVisitorContext.context(processor, (model, p) -> {
            if (params == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(48);
            }
            return model.processByClass(params, (Processor<SpringBeanPointer>)p);
        }), false);
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(23);
        }
        if (!this.processLocalBeansByName(params, processor).booleanValue()) {
            return false;
        }
        return SpringModelVisitors.visitRelatedModels(this, CommonSpringModelVisitorContext.context(processor, (model, p) -> {
            if (params == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(47);
            }
            return model.processByName(params, (Processor<SpringBeanPointer>)p);
        }), false);
    }

    @Override
    @NotNull
    public Boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(25);
        }
        Boolean bl = this.processLocalBeansByClass(params, processor, false);
        if (bl == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(26);
        }
        return bl;
    }

    @NotNull
    public Boolean processLocalBeansByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor, boolean onlyPlainBeans) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(28);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            Boolean bl = true;
            if (bl == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(29);
            }
            return bl;
        }
        Boolean bl = this.myIndexProcessor.processByClass(params, processor, this.getActiveProfiles(), this.myModule, onlyPlainBeans);
        if (bl == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(30);
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean processLocalBeansByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(32);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            Boolean bl = true;
            if (bl == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(33);
            }
            return bl;
        }
        Boolean bl = this.myIndexProcessor.processByName(params, processor, this.getActiveProfiles());
        if (bl == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(34);
        }
        return bl;
    }

    private boolean canProcessBeans() {
        DomFileElement<Beans> root = this.getRoot();
        return root != null && SpringProfileUtils.isActiveProfile((Beans)root.getRootElement(), this.getActiveProfiles());
    }

    @Override
    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Set set = (Set)CachedValuesManager.getManager((Project)this.getConfig().getProject()).getCachedValue((UserDataHolder)this, () -> {
            LinkedHashSet models = ContainerUtil.newLinkedHashSet();
            Set<String> profiles = this.getActiveProfiles();
            for (Map.Entry<XmlFile, LocalModelDependency> importedXml : LocalXmlModelImpl.getImports(this.getConfig(), profiles).entrySet()) {
                LocalXmlModelImpl.addNotNullModel(models, SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(importedXml.getKey(), this.getModule(), profiles), importedXml.getValue());
            }
            for (SpringBeansPackagesScan packagesScan : this.getPackagesScans()) {
                if (!packagesScan.isValid()) continue;
                if (!(packagesScan instanceof SpringBeansPackagesScanBean)) {
                    throw new UnsupportedOperationException("not support " + packagesScan);
                }
                SpringBeansPackagesScanBean domScan = (SpringBeansPackagesScanBean)packagesScan;
                String label = "<" + domScan.getXmlElementName() + " [" + domScan.getProviderName() + "] \"" + domScan.getBasePackage().getStringValue() + "\">";
                LocalModelDependency dependency = LocalModelDependency.create(label, LocalModelDependencyType.COMPONENT_SCAN, domScan);
                for (SpringConfiguration configuration : ComponentScanPackagesModel.getScannedConfigurations(packagesScan, this.getModule(), profiles)) {
                    LocalXmlModelImpl.addNotNullModel(models, SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration.getPsiElement(), this.getModule(), profiles), dependency);
                }
            }
            LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addAll((Collection)dependencies, (Object[])this.getOutsideModelDependencies(this));
            ContainerUtil.addAll((Collection)dependencies, (Iterable)models.stream().map(pair -> ((LocalModel)pair.first).getConfig()).collect(Collectors.toSet()));
            return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
        });
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(35);
        }
        return set;
    }

    private static Map<XmlFile, LocalModelDependency> getImports(@NotNull XmlFile file, @Nullable Set<String> activeProfiles) {
        if (file == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(36);
        }
        return (Map)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, IMPORT_FILES_KEY, () -> {
            if (file == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(46);
            }
            LinkedHashMap<XmlFile, LocalModelDependency> includes = new LinkedHashMap<XmlFile, LocalModelDependency>();
            DomFileElement<Beans> beans = SpringDomUtils.getSpringDomFileElement(file);
            if (beans != null) {
                LocalXmlModelImpl.processLocalImports(includes, (Beans)beans.getRootElement(), activeProfiles);
            }
            includes.remove(file);
            return CachedValueProvider.Result.create(includes, (Object[])ArrayUtil.append((Object[])SpringModificationTrackersManager.getInstance(file.getProject()).getOuterModelsDependencies(), (Object)file));
        }, false);
    }

    private static void processLocalImports(Map<XmlFile, LocalModelDependency> includes, Beans beans, @Nullable Set<String> activeProfiles) {
        for (SpringImport springImport : beans.getImports()) {
            Set psiFiles = (Set)springImport.getResource().getValue();
            if (psiFiles == null) continue;
            for (PsiFile psiFile : psiFiles) {
                XmlFile xmlFile;
                if (!(psiFile instanceof XmlFile) || includes.containsKey(xmlFile = (XmlFile)psiFile) || !SpringDomUtils.isSpringXml(xmlFile)) continue;
                DomFileElement<Beans> fileElement = SpringDomUtils.getSpringDomFileElement(xmlFile);
                assert (fileElement != null) : psiFile;
                Beans child = (Beans)fileElement.getRootElement();
                if (activeProfiles != null && !SpringProfileUtils.isActiveProfile(child, activeProfiles)) continue;
                String label = "<import resource=\"" + springImport.getResource().getStringValue() + "/>";
                includes.put(xmlFile, LocalModelDependency.create(label, LocalModelDependencyType.IMPORT, springImport));
            }
        }
        for (Beans beanProfiles : beans.getBeansProfiles()) {
            if (activeProfiles != null && !SpringProfileUtils.isActiveProfile(beanProfiles, activeProfiles)) continue;
            LocalXmlModelImpl.processLocalImports(includes, beanProfiles, activeProfiles);
        }
    }

    private CommonSpringModel getExplicitlyDefinedBeansModel() {
        if (this.explicitlyDefinedBeansModel == null) {
            this.explicitlyDefinedBeansModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                BeansSpringModel model = new BeansSpringModel(this.getModule(), new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        LinkedHashSet explicitBeans = ContainerUtil.newLinkedHashSet();
                        Module module = LocalXmlModelImpl.this.getModule();
                        if (LocalXmlModelImpl.isProcessExplicitlyDefinedAnnotatedBeans(module)) {
                            Set explicitBeanPsiClasses = LocalXmlModelImpl.getExplicitBeanCandidatePsiClasses(module, LocalXmlModelImpl.this.myConfigFile.getResolveScope());
                            for (PsiClass explicitBeanClass : explicitBeanPsiClasses) {
                                SpringModelSearchParameters.BeanClass candidateClassParams = SpringModelSearchParameters.byClass(explicitBeanClass).effectiveBeanTypes();
                                if (!candidateClassParams.canSearch()) continue;
                                CommonProcessors.FindFirstProcessor findFirstProcessor2 = new CommonProcessors.FindFirstProcessor();
                                LocalXmlModelImpl.this.myIndexProcessor.processByClass(candidateClassParams, (Processor<SpringBeanPointer>)findFirstProcessor2, LocalXmlModelImpl.this.getActiveProfiles(), LocalXmlModelImpl.this.myModule, true);
                                if (!findFirstProcessor2.isFound()) continue;
                                explicitBeans.addAll(SpringJamUtils.getInstance().getContextBeans(explicitBeanClass, Collections.emptySet()));
                            }
                        }
                        Set<SpringBeanPointer> set = BeanService.getInstance().mapSpringBeans(explicitBeans);
                        if (set == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return set;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$3", "compute"));
                    }
                });
                return CachedValueProvider.Result.create((Object)model, (Object[])this.getOutsideModelDependencies(this));
            }, false);
        }
        return (CommonSpringModel)this.explicitlyDefinedBeansModel.getValue();
    }

    private static boolean isProcessExplicitlyDefinedAnnotatedBeans(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(37);
        }
        if ((springFacet = SpringFacet.getInstance(module)) == null) {
            return true;
        }
        CustomSetting.BOOLEAN setting = (CustomSetting.BOOLEAN)springFacet.findSetting(PROCESS_EXPLICITLY_ANNOTATED);
        return setting == null || setting.getBooleanValue();
    }

    @NotNull
    private static Set<PsiClass> getExplicitBeanCandidatePsiClasses(@NotNull Module module, GlobalSearchScope scope) {
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(38);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getParameterizedCachedValue((UserDataHolder)module, EXPLICIT_BEAN_CLASSES, param -> {
            PsiClass annotationClass;
            if (module == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(45);
            }
            if ((annotationClass = SpringCommonUtils.findLibraryClass(module, "org.springframework.context.annotation.Bean")) == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            LinkedHashSet psiClasses = ContainerUtil.newLinkedHashSet();
            for (PsiMember member : AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)param).findAll()) {
                PsiClass containingClass = member.getContainingClass();
                if (!SpringCommonUtils.isSpringBeanCandidateClass(containingClass)) continue;
                ContainerUtil.addIfNotNull((Collection)psiClasses, (Object)containingClass);
            }
            return CachedValueProvider.Result.create((Object)psiClasses, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }, false, (Object)scope);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(39);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SpringBeanPointer> computePlaceholders() {
        SmartList result = new SmartList();
        try {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(true);
            DomFileElement<Beans> element = this.getRoot();
            if (element != null) {
                CommonProcessors.CollectProcessor<CommonSpringBean> processor = new CommonProcessors.CollectProcessor<CommonSpringBean>((List)result){
                    final /* synthetic */ List val$result;
                    {
                        this.val$result = list;
                    }

                    public boolean process(CommonSpringBean bean) {
                        PsiClass psiClass;
                        String className;
                        if (bean instanceof AbstractDomSpringBean && (className = ((AbstractDomSpringBean)bean).getClassName()) != null && InheritanceUtil.isInheritor((PsiClass)(psiClass = DomJavaUtil.findClass((String)className.trim(), (PsiFile)LocalXmlModelImpl.this.getConfig(), (Module)LocalXmlModelImpl.this.getModule(), null)), (String)"org.springframework.core.io.support.PropertiesLoaderSupport")) {
                            this.val$result.add(BeanService.getInstance().createSpringBeanPointer(bean));
                        }
                        return true;
                    }
                };
                this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor);
            }
        }
        finally {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(false);
        }
        SmartList smartList = result;
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(40);
        }
        return smartList;
    }

    @NotNull
    private List<SpringBeanPointer> computeAnnotationConfigApplicationContexts() {
        if (!this.canProcessBeans()) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(41);
            }
            return list;
        }
        PsiClass annotationConfigAppContext = SpringCommonUtils.findLibraryClass(this.myModule, "org.springframework.context.annotation.AnnotationConfigApplicationContext");
        if (annotationConfigAppContext == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(42);
            }
            return list;
        }
        SmartList result = new SmartList();
        CommonProcessors.CollectProcessor<SpringBeanPointer> processor = new CommonProcessors.CollectProcessor<SpringBeanPointer>((Collection)result){

            public boolean process(SpringBeanPointer pointer) {
                ProgressManager.checkCanceled();
                return super.process((Object)pointer);
            }

            protected boolean accept(SpringBeanPointer pointer) {
                return pointer.getSpringBean() instanceof SpringBean;
            }
        };
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(annotationConfigAppContext).withInheritors();
        this.myIndexProcessor.processByClass(searchParameters, (Processor<SpringBeanPointer>)processor, this.getActiveProfiles(), this.myModule, true);
        SmartList smartList = result;
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(43);
        }
        return smartList;
    }

    @NotNull
    private MultiMap<SpringBeanPointer, SpringBeanPointer> computeDirectInheritorsMap() {
        MultiMap<SpringBeanPointer, SpringBeanPointer> map = new MultiMap<SpringBeanPointer, SpringBeanPointer>(){

            @NotNull
            protected Map<SpringBeanPointer, Collection<SpringBeanPointer>> createMap() {
                ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
                if (concurrentMap == null) {
                    6.$$$reportNull$$$0(0);
                }
                return concurrentMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$6", "createMap"));
            }
        };
        for (SpringBeanPointer pointer : this.getLocalBeans()) {
            SpringBeanPointer parentPointer = pointer.getParentPointer();
            if (parentPointer == null) continue;
            map.putValue((Object)parentPointer.getBasePointer(), (Object)pointer);
        }
        MultiMap<SpringBeanPointer, SpringBeanPointer> multiMap = map;
        if (multiMap == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(44);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalXmlModelImpl";
                break;
            }
            case 1: 
            case 4: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 37: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProfiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalXmlModelImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendantBeans";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurerBeans";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesScans";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigAppContexts";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 26: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "processLocalBeansByClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "processLocalBeansByName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitBeanCandidatePsiClasses";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "computePlaceholders";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAnnotationConfigApplicationContexts";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDirectInheritorsMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIndexProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicatedBeanNames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDomBeans";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescendantBeans";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processByClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processByName";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processLocalBeansByName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isProcessExplicitlyDefinedAnnotatedBeans";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitBeanCandidatePsiClasses";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExplicitBeanCandidatePsiClasses$19";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getImports$17";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processByName$14";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processByClass$13";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

