/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.valueclass;

import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossPropertyDescriptor;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossValueClassesEditor;
import com.intellij.javaee.oss.jboss.model.JBossProperty;
import com.intellij.javaee.oss.jboss.model.JBossValueClass;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ColumnInfo;

class JBossPersistentColumn
extends ColumnInfo<JavaeeNodeDescriptor<?>, Boolean> {
    JBossPersistentColumn() {
        super(JBossBundle.getText("JBossValueClassesEditor.persistent", new Object[0]));
    }

    public Class<?> getColumnClass() {
        return Boolean.class;
    }

    public Boolean valueOf(JavaeeNodeDescriptor<?> item) {
        Boolean value = null;
        Object element = item.getElement();
        if (element instanceof JBossPropertyDescriptor) {
            value = JBossValueClassesEditor.findProperty(item) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return value;
    }

    public void setValue(JavaeeNodeDescriptor<?> item, Boolean value) {
        Object element = item.getElement();
        if (element instanceof JBossPropertyDescriptor) {
            JBossProperty property = JBossValueClassesEditor.findProperty(item);
            if (property == null && value.booleanValue()) {
                WriteCommandAction.writeCommandAction((Project)item.getProject()).run(() -> {
                    JBossValueClass valueClass = (JBossValueClass)item.getParentDescriptor().getElement();
                    String name = ((JBossPropertyDescriptor)item.getElement()).getName();
                    valueClass.addProperty().getPropertyName().setValue((Object)name);
                });
            } else if (property != null && !value.booleanValue()) {
                WriteCommandAction.writeCommandAction((Project)item.getProject()).run(() -> property.undefine());
            }
        }
    }

    public boolean isCellEditable(JavaeeNodeDescriptor<?> item) {
        return item.getElement() instanceof JBossPropertyDescriptor;
    }
}

