/*
 * Decompiled with CFR 0.152.
 */
package io.nettyjarjar.handler.codec.serialization;

import io.nettyjarjar.buffer.ByteBuf;
import io.nettyjarjar.buffer.ByteBufOutputStream;
import io.nettyjarjar.channel.ChannelHandlerContext;
import io.nettyjarjar.handler.codec.MessageToByteEncoder;
import io.nettyjarjar.util.Attribute;
import io.nettyjarjar.util.AttributeKey;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final AttributeKey<ObjectOutputStream> OOS = AttributeKey.valueOf(CompatibleObjectEncoder.class, "OOS");
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        if (resetInterval < 0) {
            throw new IllegalArgumentException("resetInterval: " + resetInterval);
        }
        this.resetInterval = resetInterval;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        ObjectOutputStream newOos;
        Attribute<ObjectOutputStream> oosAttr = ctx.attr(OOS);
        ObjectOutputStream oos = oosAttr.get();
        if (oos == null && (newOos = oosAttr.setIfAbsent(oos = this.newObjectOutputStream(new ByteBufOutputStream(out)))) != null) {
            oos = newOos;
        }
        ObjectOutputStream objectOutputStream = oos;
        synchronized (objectOutputStream) {
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    oos.reset();
                }
            }
            oos.writeObject(msg);
            oos.flush();
        }
    }
}

