/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.agent.cloud;

import com.cloudbees.api.AccountInfo;
import com.cloudbees.api.AccountKeysResponse;
import com.cloudbees.api.AccountListResponse;
import com.cloudbees.api.ApplicationInfo;
import com.cloudbees.api.ApplicationListResponse;
import com.cloudbees.api.BeesClient;
import com.cloudbees.api.BeesClientConfiguration;
import com.cloudbees.api.SayHelloResponse;
import com.intellij.javaee.cloudbees.agent.cloud.CBApplication;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgent;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentApplicationImpl;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentConfig;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentDeploymentConfig;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentDeploymentImpl;
import com.intellij.remoteServer.agent.util.CloudAgentApplication;
import com.intellij.remoteServer.agent.util.CloudAgentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudProxySettings;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import java.util.ArrayList;

public class CBCloudAgentImpl
implements CBCloudAgent {
    private static final String API_URL = "https://api.cloudbees.com/api";
    private static final String HELLO_MESSAGE = "HiThere";
    private final LogAgentManager myLogManager = new LogAgentManager();
    private BeesClient myClient;
    private CloudAgentLogger myLogger;
    private CloudAgentErrorHandler myErrorHandler;

    public void connect(CBCloudAgentConfig config, CloudAgentCallback callback, CloudAgentLogger logger, CloudAgentErrorHandler errorHandler) {
        this.myLogger = logger;
        this.myErrorHandler = errorHandler;
        try {
            String format = "xml";
            String version = "1.0";
            BeesClientConfiguration clientConfiguration = new BeesClientConfiguration(API_URL, "", "", "xml", "1.0");
            CloudProxySettings proxySettings = config.getProxySettings();
            if (proxySettings.useHttpProxy()) {
                clientConfiguration.setProxyHost(proxySettings.getHost());
                clientConfiguration.setProxyPort(proxySettings.getPort());
                if (proxySettings.useAuthentication()) {
                    clientConfiguration.setProxyUser(proxySettings.getLogin());
                    clientConfiguration.setProxyPassword(proxySettings.getPassword());
                }
            }
            BeesClient authClient = new BeesClient(clientConfiguration);
            authClient.setVerbose(false);
            String domain = config.getDomainPrefix();
            AccountKeysResponse keysResponse = authClient.accountKeys(domain, config.getEmail(), config.getPasswordSafe());
            clientConfiguration.setSecret(keysResponse.getSecret());
            clientConfiguration.setApiKey(keysResponse.getKey());
            this.myClient = new BeesClient(clientConfiguration);
            this.myClient.setVerbose(false);
            boolean domainValid = false;
            AccountListResponse accountList = this.myClient.accountList();
            for (AccountInfo accountInfo : accountList.getAccounts()) {
                if (!domain.equals(accountInfo.getName())) continue;
                domainValid = true;
                break;
            }
            if (!domainValid) {
                callback.errorOccurred("Invalid domain");
                return;
            }
            SayHelloResponse helloResponse = this.myClient.sayHello(HELLO_MESSAGE);
            String message = helloResponse.getMessage();
            if (!HELLO_MESSAGE.equals(message)) {
                callback.errorOccurred("Unexpected hello response: " + message);
                return;
            }
            callback.connected();
        }
        catch (Exception e) {
            callback.errorOccurred(e.toString());
        }
    }

    public void disconnect() {
        this.myLogManager.stopListeningAllLogs();
    }

    public CloudAgentApplication createApplication(CloudRemoteApplication applicationIdentity) {
        return new CBCloudAgentApplicationImpl(this.myClient, applicationIdentity.getName());
    }

    public CloudAgentDeployment createDeployment(CBCloudAgentDeploymentConfig config, CloudAgentLoggingHandler loggingHandler) {
        return new CBCloudAgentDeploymentImpl(this.myClient, config, loggingHandler, this.myLogManager, this.myLogger);
    }

    public CloudRemoteApplication[] getApplications() {
        return (CloudRemoteApplication[])new ApiTask<CloudRemoteApplication[]>(){

            @Override
            protected CloudRemoteApplication[] doPerform() throws Exception {
                ArrayList<CBApplication> result = new ArrayList<CBApplication>();
                ApplicationListResponse listResponse = CBCloudAgentImpl.this.myClient.applicationList();
                for (ApplicationInfo info : listResponse.getApplications()) {
                    result.add(new CBApplication(info));
                }
                return result.toArray(new CloudRemoteApplication[0]);
            }
        }.perform();
    }

    private abstract class ApiTask<T> {
        private ApiTask() {
        }

        public T perform() {
            try {
                return this.doPerform();
            }
            catch (Exception ex) {
                CBCloudAgentImpl.this.myErrorHandler.onError(ex.toString());
                return null;
            }
        }

        protected abstract T doPerform() throws Exception;
    }
}

