/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.spring.el.highlighting.SpringELHighlighter;
import com.intellij.spring.el.psi.SpringELPropertyReference;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.SpringELSelectExpression;
import org.jetbrains.annotations.NotNull;

public class SpringELHighlightingAnnotator
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringELHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringELHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof SpringELQualifiedType) {
            SpringELHighlightingAnnotator.doAnnotate(holder, element, SpringELHighlighter.SPEL_QUALIFIED_TYPE);
        }
        if (element instanceof SpringELPropertyReference) {
            SpringELHighlightingAnnotator.doAnnotate(holder, element, SpringELHighlighter.SPEL_PROPERTY_KEY);
        }
        if (element instanceof SpringELSelectExpression) {
            SpringELSelectExpression selectExpression = (SpringELSelectExpression)element;
            ELVariable variable = selectExpression.getField();
            if (variable == null) {
                return;
            }
            PsiReference reference = variable.getReference();
            if (reference == null) {
                return;
            }
            if (reference instanceof PsiPolyVariantReference) {
                for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement resolve = result.getElement();
                    if (!SpringELHighlightingAnnotator.annotateMethodOrField(holder, variable, resolve)) continue;
                    return;
                }
            }
            PsiElement resolve = reference.resolve();
            SpringELHighlightingAnnotator.annotateMethodOrField(holder, variable, resolve);
        }
    }

    private static boolean annotateMethodOrField(AnnotationHolder holder, ELVariable variable, PsiElement resolve) {
        PsiField field;
        if (resolve instanceof PsiMethod) {
            SpringELHighlightingAnnotator.doAnnotate(holder, (PsiElement)variable, SpringELHighlighter.SPEL_METHOD_CALL);
            return true;
        }
        if (resolve instanceof PsiField && (field = (PsiField)resolve).hasModifierProperty("static")) {
            SpringELHighlightingAnnotator.doAnnotate(holder, (PsiElement)variable, SpringELHighlighter.SPEL_STATIC_FIELD);
            return true;
        }
        return false;
    }

    private static void doAnnotate(AnnotationHolder holder, PsiElement element, TextAttributesKey key) {
        String message = DEBUG_MODE ? key.getExternalName() : null;
        holder.createInfoAnnotation(element, message).setTextAttributes(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/el/highlighting/SpringELHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

