/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugin.devel.plugins.IvyPluginPublishingPlugin;
import org.gradle.plugin.devel.plugins.MavenPluginPublishPlugin;
import org.gradle.plugin.devel.tasks.GeneratePluginDescriptors;
import org.gradle.plugin.devel.tasks.PluginUnderTestMetadata;
import org.gradle.plugin.devel.tasks.ValidateTaskProperties;

@Incubating
@NonNullApi
public class JavaGradlePluginPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(JavaGradlePluginPlugin.class);
    static final String COMPILE_CONFIGURATION = "compile";
    static final String JAR_TASK = "jar";
    static final String PROCESS_RESOURCES_TASK = "processResources";
    static final String GRADLE_PLUGINS = "gradle-plugins";
    static final String PLUGIN_DESCRIPTOR_PATTERN = "META-INF/gradle-plugins/*.properties";
    static final String CLASSES_PATTERN = "**/*.class";
    static final String BAD_IMPL_CLASS_WARNING_MESSAGE = "%s: A valid plugin descriptor was found for %s but the implementation class %s was not found in the jar.";
    static final String INVALID_DESCRIPTOR_WARNING_MESSAGE = "%s: A plugin descriptor was found for %s but it was invalid.";
    static final String NO_DESCRIPTOR_WARNING_MESSAGE = "%s: No valid plugin descriptors were found in META-INF/gradle-plugins";
    static final String DECLARED_PLUGIN_MISSING_MESSAGE = "%s: Could not find plugin descriptor of %s at META-INF/gradle-plugins/%s.properties";
    static final String DECLARATION_MISSING_ID_MESSAGE = "Missing id for %s";
    static final String DECLARATION_MISSING_IMPLEMENTATION_MESSAGE = "Missing implementationClass for %s";
    static final String EXTENSION_NAME = "gradlePlugin";
    static final String PLUGIN_UNDER_TEST_METADATA_TASK_NAME = "pluginUnderTestMetadata";
    static final String GENERATE_PLUGIN_DESCRIPTORS_TASK_NAME = "pluginDescriptors";
    static final String VALIDATE_TASK_PROPERTIES_TASK_NAME = "validateTaskProperties";
    static final String PLUGIN_DEVELOPMENT_GROUP = "Plugin development";
    static final String PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION = "Generates the metadata for plugin functional tests.";
    static final String GENERATE_PLUGIN_DESCRIPTORS_TASK_DESCRIPTION = "Generates plugin descriptors from plugin declarations.";
    static final String VALIDATE_TASK_PROPERTIES_TASK_DESCRIPTION = "Validates task property annotations for the plugin.";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        this.applyDependencies(project);
        GradlePluginDevelopmentExtension extension = this.createExtension(project);
        this.configureJarTask(project, extension);
        this.configureTestKit(project, extension);
        this.configurePublishing(project);
        this.configureDescriptorGeneration(project, extension);
        this.validatePluginDeclarations(project, extension);
        this.configureTaskPropertiesValidation(project);
    }

    private void applyDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add(COMPILE_CONFIGURATION, dependencies.gradleApi());
    }

    private void configureJarTask(Project project, final GradlePluginDevelopmentExtension extension) {
        project.getTasks().withType(Jar.class).named(JAR_TASK).configure(new Action<Jar>(){

            @Override
            public void execute(Jar jarTask) {
                ArrayList<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>();
                HashSet<String> classList = new HashSet<String>();
                PluginDescriptorCollectorAction pluginDescriptorCollector = new PluginDescriptorCollectorAction(descriptors);
                ClassManifestCollectorAction classManifestCollector = new ClassManifestCollectorAction(classList);
                PluginValidationAction pluginValidationAction = new PluginValidationAction(extension.getPlugins(), descriptors, classList);
                jarTask.filesMatching(JavaGradlePluginPlugin.PLUGIN_DESCRIPTOR_PATTERN, (Action)pluginDescriptorCollector);
                jarTask.filesMatching(JavaGradlePluginPlugin.CLASSES_PATTERN, (Action)classManifestCollector);
                jarTask.appendParallelSafeAction(pluginValidationAction);
            }
        });
    }

    private GradlePluginDevelopmentExtension createExtension(Project project) {
        JavaPluginConvention javaConvention = project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet defaultPluginSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet defaultTestSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
        return project.getExtensions().create(EXTENSION_NAME, GradlePluginDevelopmentExtension.class, project, defaultPluginSourceSet, defaultTestSourceSet);
    }

    private void configureTestKit(Project project, GradlePluginDevelopmentExtension extension) {
        TaskProvider<PluginUnderTestMetadata> pluginUnderTestMetadataTask = this.createAndConfigurePluginUnderTestMetadataTask(project, extension);
        this.establishTestKitAndPluginClasspathDependencies(project, extension, pluginUnderTestMetadataTask);
    }

    private TaskProvider<PluginUnderTestMetadata> createAndConfigurePluginUnderTestMetadataTask(final Project project, final GradlePluginDevelopmentExtension extension) {
        return project.getTasks().register(PLUGIN_UNDER_TEST_METADATA_TASK_NAME, PluginUnderTestMetadata.class, new Action<PluginUnderTestMetadata>(){

            @Override
            public void execute(PluginUnderTestMetadata pluginUnderTestMetadataTask) {
                pluginUnderTestMetadataTask.setGroup(JavaGradlePluginPlugin.PLUGIN_DEVELOPMENT_GROUP);
                pluginUnderTestMetadataTask.setDescription(JavaGradlePluginPlugin.PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION);
                pluginUnderTestMetadataTask.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir(pluginUnderTestMetadataTask.getName()));
                pluginUnderTestMetadataTask.getPluginClasspath().from(new Callable<Object>(){

                    @Override
                    public Object call() {
                        Configuration gradlePluginConfiguration = project.getConfigurations().detachedConfiguration(project.getDependencies().gradleApi());
                        FileCollection gradleApi = gradlePluginConfiguration.getIncoming().getFiles();
                        return extension.getPluginSourceSet().getRuntimeClasspath().minus(gradleApi);
                    }
                });
            }
        });
    }

    private void establishTestKitAndPluginClasspathDependencies(Project project, GradlePluginDevelopmentExtension extension, TaskProvider<PluginUnderTestMetadata> pluginClasspathTask) {
        project.afterEvaluate(new TestKitAndPluginClasspathDependenciesAction(extension, pluginClasspathTask));
    }

    private void configurePublishing(final Project project) {
        project.getPluginManager().withPlugin("maven-publish", (Action<? super AppliedPlugin>)new Action<AppliedPlugin>(){

            @Override
            public void execute(AppliedPlugin appliedPlugin) {
                project.getPluginManager().apply(MavenPluginPublishPlugin.class);
            }
        });
        project.getPluginManager().withPlugin("ivy-publish", (Action<? super AppliedPlugin>)new Action<AppliedPlugin>(){

            @Override
            public void execute(AppliedPlugin appliedPlugin) {
                project.getPluginManager().apply(IvyPluginPublishingPlugin.class);
            }
        });
    }

    private void configureDescriptorGeneration(final Project project, final GradlePluginDevelopmentExtension extension) {
        final TaskProvider<GeneratePluginDescriptors> generatePluginDescriptors = project.getTasks().register(GENERATE_PLUGIN_DESCRIPTORS_TASK_NAME, GeneratePluginDescriptors.class, new Action<GeneratePluginDescriptors>(){

            @Override
            public void execute(GeneratePluginDescriptors generatePluginDescriptors) {
                generatePluginDescriptors.setGroup(JavaGradlePluginPlugin.PLUGIN_DEVELOPMENT_GROUP);
                generatePluginDescriptors.setDescription(JavaGradlePluginPlugin.GENERATE_PLUGIN_DESCRIPTORS_TASK_DESCRIPTION);
                generatePluginDescriptors.getDeclarations().set(extension.getPlugins());
                generatePluginDescriptors.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir(generatePluginDescriptors.getName()));
            }
        });
        project.getTasks().withType(Copy.class).named(PROCESS_RESOURCES_TASK).configure(new Action<Copy>(){

            @Override
            public void execute(Copy processResources) {
                CopySpecInternal copyPluginDescriptors = processResources.getRootSpec().addChild();
                copyPluginDescriptors.into("META-INF/gradle-plugins");
                copyPluginDescriptors.from(generatePluginDescriptors);
            }
        });
    }

    private void validatePluginDeclarations(Project project, final GradlePluginDevelopmentExtension extension) {
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                for (PluginDeclaration declaration : extension.getPlugins()) {
                    if (declaration.getId() == null) {
                        throw new IllegalArgumentException(String.format(JavaGradlePluginPlugin.DECLARATION_MISSING_ID_MESSAGE, declaration.getName()));
                    }
                    if (declaration.getImplementationClass() != null) continue;
                    throw new IllegalArgumentException(String.format(JavaGradlePluginPlugin.DECLARATION_MISSING_IMPLEMENTATION_MESSAGE, declaration.getName()));
                }
            }
        });
    }

    private void configureTaskPropertiesValidation(final Project project) {
        final SourceSet mainSourceSet = (SourceSet)project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().getByName("main");
        final TaskProvider<ValidateTaskProperties> validator = project.getTasks().register(VALIDATE_TASK_PROPERTIES_TASK_NAME, ValidateTaskProperties.class, new Action<ValidateTaskProperties>(){

            @Override
            public void execute(ValidateTaskProperties validator) {
                validator.setGroup(JavaGradlePluginPlugin.PLUGIN_DEVELOPMENT_GROUP);
                validator.setDescription(JavaGradlePluginPlugin.VALIDATE_TASK_PROPERTIES_TASK_DESCRIPTION);
                validator.getOutputFile().set(project.getLayout().getBuildDirectory().file("reports/task-properties/report.txt"));
                validator.setClasses(mainSourceSet.getOutput().getClassesDirs());
                validator.setClasspath(mainSourceSet.getCompileClasspath());
                validator.dependsOn(mainSourceSet.getOutput());
            }
        });
        project.getTasks().named("check").configure(new Action<Task>(){

            @Override
            public void execute(Task check) {
                check.dependsOn(validator);
            }
        });
    }

    static class TestKitAndPluginClasspathDependenciesAction
    implements Action<Project> {
        private final GradlePluginDevelopmentExtension extension;
        private final TaskProvider<PluginUnderTestMetadata> pluginClasspathTask;

        private TestKitAndPluginClasspathDependenciesAction(GradlePluginDevelopmentExtension extension, TaskProvider<PluginUnderTestMetadata> pluginClasspathTask) {
            this.extension = extension;
            this.pluginClasspathTask = pluginClasspathTask;
        }

        @Override
        public void execute(Project project) {
            DependencyHandler dependencies = project.getDependencies();
            Set<SourceSet> testSourceSets = this.extension.getTestSourceSets();
            project.getNormalization().getRuntimeClasspath().ignore("plugin-under-test-metadata.properties");
            project.getTasks().withType(Test.class).configureEach(new Action<Test>(){

                @Override
                public void execute(Test test) {
                    test.getInputs().files(((PluginUnderTestMetadata)TestKitAndPluginClasspathDependenciesAction.this.pluginClasspathTask.get()).getPluginClasspath()).withPropertyName("pluginClasspath").withNormalizer(ClasspathNormalizer.class);
                }
            });
            for (SourceSet testSourceSet : testSourceSets) {
                String compileConfigurationName = testSourceSet.getCompileConfigurationName();
                dependencies.add(compileConfigurationName, dependencies.gradleTestKit());
                String runtimeConfigurationName = testSourceSet.getRuntimeConfigurationName();
                dependencies.add(runtimeConfigurationName, project.getLayout().files(this.pluginClasspathTask));
            }
        }
    }

    static class ClassManifestCollectorAction
    implements Action<FileCopyDetails> {
        Set<String> classList;

        ClassManifestCollectorAction(Set<String> classList) {
            this.classList = classList;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            this.classList.add(fileCopyDetails.getRelativePath().toString());
        }
    }

    static class PluginDescriptorCollectorAction
    implements Action<FileCopyDetails> {
        List<PluginDescriptor> descriptors;

        PluginDescriptorCollectorAction(List<PluginDescriptor> descriptors) {
            this.descriptors = descriptors;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            PluginDescriptor descriptor;
            try {
                descriptor = new PluginDescriptor(fileCopyDetails.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                return;
            }
            if (descriptor.getImplementationClassName() != null) {
                this.descriptors.add(descriptor);
            }
        }
    }

    static class PluginValidationAction
    implements Action<Task> {
        private final Collection<PluginDeclaration> plugins;
        private final Collection<PluginDescriptor> descriptors;
        private final Set<String> classes;

        PluginValidationAction(Collection<PluginDeclaration> plugins, @Nullable Collection<PluginDescriptor> descriptors, Set<String> classes) {
            this.plugins = plugins;
            this.descriptors = descriptors;
            this.classes = classes;
        }

        @Override
        public void execute(Task task) {
            if (this.descriptors == null || this.descriptors.isEmpty()) {
                LOGGER.warn(String.format(JavaGradlePluginPlugin.NO_DESCRIPTOR_WARNING_MESSAGE, task.getPath()));
            } else {
                HashSet pluginFileNames = Sets.newHashSet();
                for (PluginDescriptor descriptor : this.descriptors) {
                    URI descriptorURI = null;
                    try {
                        descriptorURI = descriptor.getPropertiesFileUrl().toURI();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    String pluginFileName = descriptorURI != null ? new File(descriptorURI).getName() : "UNKNOWN";
                    pluginFileNames.add(pluginFileName);
                    String pluginImplementation = descriptor.getImplementationClassName();
                    if (pluginImplementation.length() == 0) {
                        LOGGER.warn(String.format(JavaGradlePluginPlugin.INVALID_DESCRIPTOR_WARNING_MESSAGE, task.getPath(), pluginFileName));
                        continue;
                    }
                    if (this.hasFullyQualifiedClass(pluginImplementation)) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.BAD_IMPL_CLASS_WARNING_MESSAGE, task.getPath(), pluginFileName, pluginImplementation));
                }
                for (PluginDeclaration declaration : this.plugins) {
                    if (pluginFileNames.contains(declaration.getId() + ".properties")) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.DECLARED_PLUGIN_MISSING_MESSAGE, task.getPath(), declaration.getName(), declaration.getId()));
                }
            }
        }

        boolean hasFullyQualifiedClass(String fqClass) {
            return this.classes.contains(fqClass.replaceAll("\\.", "/") + ".class");
        }
    }
}

