/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.AbstractVariantBackedConfigurationMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

class LazyVariantBackedConfigurationMetadata
extends AbstractVariantBackedConfigurationMetadata {
    private final VariantMetadataRules variantMetadataRules;
    private List<? extends ModuleDependencyMetadata> calculatedDependencies;

    LazyVariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant, ImmutableAttributes componentLevelAttributes, ImmutableAttributesFactory attributesFactory, VariantMetadataRules variantMetadataRules) {
        super(componentId, new RuleAwareVariant(variant, attributesFactory, componentLevelAttributes, variantMetadataRules));
        this.variantMetadataRules = variantMetadataRules;
    }

    @Override
    public List<? extends ModuleDependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.variantMetadataRules.applyDependencyMetadataRules(this.getVariant(), super.getDependencies());
        }
        return this.calculatedDependencies;
    }

    private static class RuleAwareVariant
    implements ComponentVariant {
        private final ImmutableAttributesFactory attributesFactory;
        private final ComponentVariant delegate;
        private final ImmutableAttributes componentLevelAttributes;
        private final VariantMetadataRules variantMetadataRules;
        private ImmutableAttributes computedAttributes;
        private CapabilitiesMetadata computedCapabilities;

        RuleAwareVariant(ComponentVariant delegate, ImmutableAttributesFactory attributesFactory, ImmutableAttributes componentLevelAttributes, VariantMetadataRules variantMetadataRules) {
            this.attributesFactory = attributesFactory;
            this.delegate = delegate;
            this.componentLevelAttributes = componentLevelAttributes;
            this.variantMetadataRules = variantMetadataRules;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public DisplayName asDescribable() {
            return this.delegate.asDescribable();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            if (this.computedAttributes == null) {
                this.computedAttributes = this.variantMetadataRules.applyVariantAttributeRules(this.delegate, this.mergeComponentAndVariantAttributes(this.delegate.getAttributes()));
            }
            return this.computedAttributes;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.delegate.getArtifacts();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.Dependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.DependencyConstraint> getDependencyConstraints() {
            return this.delegate.getDependencyConstraints();
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.delegate.getFiles();
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            if (this.computedCapabilities == null) {
                this.computedCapabilities = this.variantMetadataRules.applyCapabilitiesRules(this.delegate, this.delegate.getCapabilities());
            }
            return this.computedCapabilities;
        }

        private AttributeContainerInternal mergeComponentAndVariantAttributes(AttributeContainerInternal variantAttributes) {
            return this.attributesFactory.concat(this.componentLevelAttributes, variantAttributes.asImmutable());
        }
    }
}

