/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class ParallelismBuildOptions {
    private static List<BuildOption<ParallelismConfiguration>> options;

    public static List<BuildOption<ParallelismConfiguration>> get() {
        return options;
    }

    private ParallelismBuildOptions() {
    }

    static {
        ArrayList<AbstractBuildOption> options = new ArrayList<AbstractBuildOption>();
        options.add(new ParallelOption());
        options.add(new MaxWorkersOption());
        ParallelismBuildOptions.options = Collections.unmodifiableList(options);
    }

    public static class MaxWorkersOption
    extends StringBuildOption<ParallelismConfiguration> {
        public static final String GRADLE_PROPERTY = "org.gradle.workers.max";
        public static final String LONG_OPTION = "max-workers";
        public static final String HINT = "must be a positive, non-zero, integer";

        public MaxWorkersOption() {
            super(GRADLE_PROPERTY, CommandLineOptionConfiguration.create(LONG_OPTION, "Configure the number of concurrent workers Gradle is allowed to use.").incubating());
        }

        @Override
        public void applyTo(String value, ParallelismConfiguration settings, Origin origin) {
            try {
                int workerCount = Integer.parseInt(value);
                if (workerCount < 1) {
                    origin.handleInvalidValue(value, HINT);
                }
                settings.setMaxWorkerCount(workerCount);
            }
            catch (NumberFormatException e) {
                origin.handleInvalidValue(value, HINT);
            }
        }
    }

    public static class ParallelOption
    extends BooleanBuildOption<ParallelismConfiguration> {
        public static final String GRADLE_PROPERTY = "org.gradle.parallel";

        public ParallelOption() {
            super(GRADLE_PROPERTY, BooleanCommandLineOptionConfiguration.create("parallel", "Build projects in parallel. Gradle will attempt to determine the optimal number of executor threads to use.", "Disables parallel execution to build projects.").incubating());
        }

        @Override
        public void applyTo(boolean value, ParallelismConfiguration settings, Origin origin) {
            settings.setParallelProjectExecutionEnabled(value);
        }
    }
}

