/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class PBXGroup
extends PBXReference {
    private final List<PBXReference> children;
    private final LoadingCache<String, PBXGroup> childGroupsByName;
    private SortPolicy sortPolicy = SortPolicy.BY_NAME;

    public PBXGroup(String name, @Nullable String path, PBXReference.SourceTree sourceTree) {
        super(name, path, sourceTree);
        this.children = Lists.newArrayList();
        this.childGroupsByName = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, PBXGroup>(){

            public PBXGroup load(String key) throws Exception {
                PBXGroup group = new PBXGroup(key, null, PBXReference.SourceTree.GROUP);
                PBXGroup.this.children.add(group);
                return group;
            }
        });
    }

    public PBXGroup getOrCreateChildGroupByName(String name) {
        return (PBXGroup)this.childGroupsByName.getUnchecked((Object)name);
    }

    public List<PBXReference> getChildren() {
        return this.children;
    }

    public SortPolicy getSortPolicy() {
        return this.sortPolicy;
    }

    public void setSortPolicy(SortPolicy sortPolicy) {
        this.sortPolicy = (SortPolicy)((Object)Preconditions.checkNotNull((Object)((Object)sortPolicy)));
    }

    @Override
    public String isa() {
        return "PBXGroup";
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        if (this.sortPolicy == SortPolicy.BY_NAME) {
            Collections.sort(this.children, new Comparator<PBXReference>(){

                @Override
                public int compare(PBXReference o1, PBXReference o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        s.addField("children", this.children);
    }

    public static enum SortPolicy {
        BY_NAME,
        UNSORTED;

    }
}

