/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Collection;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeBuildDependencySubstitutions
implements Action<DependencySubstitution> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeBuildDependencySubstitutions.class);
    private final Multimap<ModuleIdentifier, ProjectComponentIdentifier> replacementMap = ArrayListMultimap.create();

    public CompositeBuildDependencySubstitutions(Collection<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> replacements) {
        for (Pair<ModuleVersionIdentifier, ProjectComponentIdentifier> replacement : replacements) {
            this.replacementMap.put((Object)replacement.getLeft().getModule(), (Object)replacement.getRight());
        }
    }

    @Override
    public void execute(DependencySubstitution sub) {
        ModuleComponentSelector selector;
        ProjectComponentIdentifier replacement;
        DependencySubstitutionInternal dependencySubstitution = (DependencySubstitutionInternal)sub;
        ComponentSelector requested = dependencySubstitution.getTarget();
        if (requested instanceof ModuleComponentSelector && (replacement = this.getReplacementFor(selector = (ModuleComponentSelector)requested)) != null) {
            dependencySubstitution.useTarget((Object)DefaultProjectComponentSelector.newSelector(replacement), VersionSelectionReasons.COMPOSITE_BUILD);
        }
    }

    private ProjectComponentIdentifier getReplacementFor(ModuleComponentSelector selector) {
        ModuleIdentifier candidateId = selector.getModuleIdentifier();
        Collection providingProjects = this.replacementMap.get((Object)candidateId);
        if (providingProjects.isEmpty()) {
            LOGGER.debug("Found no composite build substitute for module '" + candidateId + "'.");
            return null;
        }
        if (providingProjects.size() == 1) {
            ProjectComponentIdentifier match = (ProjectComponentIdentifier)providingProjects.iterator().next();
            LOGGER.info("Found project '" + match + "' as substitute for module '" + candidateId + "'.");
            return match;
        }
        TreeSet sortedProjects = Sets.newTreeSet(CollectionUtils.collect(providingProjects, new Transformer<String, ProjectComponentIdentifier>(){

            @Override
            public String transform(ProjectComponentIdentifier projectComponentIdentifier) {
                return projectComponentIdentifier.getDisplayName();
            }
        }));
        String failureMessage = String.format("Module version '%s' is not unique in composite: can be provided by %s.", selector.getDisplayName(), sortedProjects);
        throw new ModuleVersionResolveException((ComponentSelector)selector, failureMessage);
    }
}

