/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.operations;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.operations.ExecuteTestBuildOperationType;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.time.Clock;

public class TestListenerBuildOperationAdapter
implements TestListenerInternal {
    private final Map<TestDescriptor, InProgressExecuteTestBuildOperation> runningTests = new HashMap<TestDescriptor, InProgressExecuteTestBuildOperation>();
    private final BuildOperationListener listener;
    private final BuildOperationIdFactory buildOperationIdFactory;
    private final Clock clock;

    public TestListenerBuildOperationAdapter(BuildOperationListener listener, BuildOperationIdFactory buildOperationIdFactory, Clock clock) {
        this.listener = listener;
        this.buildOperationIdFactory = buildOperationIdFactory;
        this.clock = clock;
    }

    @Override
    public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
        long currentTime = this.clock.getCurrentTime();
        BuildOperationDescriptor testBuildOperationDescriptor = this.createTestBuildOperationDescriptor(testDescriptor, startEvent);
        this.runningTests.put(testDescriptor, new InProgressExecuteTestBuildOperation(testBuildOperationDescriptor, currentTime));
        this.listener.started(testBuildOperationDescriptor, new OperationStartEvent(currentTime));
    }

    @Override
    public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
        long currentTime = this.clock.getCurrentTime();
        InProgressExecuteTestBuildOperation runningOp = this.runningTests.remove(testDescriptor);
        this.listener.finished(runningOp.descriptor, new OperationFinishEvent(runningOp.startTime, currentTime, testResult.getException(), new Result(testResult)));
    }

    @Override
    public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
        long currentTime = this.clock.getCurrentTime();
        InProgressExecuteTestBuildOperation runningOp = this.runningTests.get(testDescriptor);
        this.listener.progress(runningOp.descriptor.getId(), new OperationProgressEvent(currentTime, new OutputProgress(event)));
    }

    private BuildOperationDescriptor createTestBuildOperationDescriptor(TestDescriptor testDescriptor, TestStartEvent testStartEvent) {
        Details details = new Details(testDescriptor, testStartEvent.getStartTime());
        InProgressExecuteTestBuildOperation parentOperation = this.runningTests.get(testDescriptor.getParent());
        OperationIdentifier parentId = parentOperation == null ? CurrentBuildOperationRef.instance().getId() : parentOperation.descriptor.getId();
        return BuildOperationDescriptor.displayName(testDescriptor.getName()).details(details).build(this.newOperationIdentifier(), parentId);
    }

    private OperationIdentifier newOperationIdentifier() {
        return new OperationIdentifier(this.buildOperationIdFactory.nextId());
    }

    private static class InProgressExecuteTestBuildOperation {
        final BuildOperationDescriptor descriptor;
        final long startTime;

        InProgressExecuteTestBuildOperation(BuildOperationDescriptor testBuildOperationDescriptor, long startTime) {
            this.descriptor = testBuildOperationDescriptor;
            this.startTime = startTime;
        }
    }

    private static class Result
    implements ExecuteTestBuildOperationType.Result {
        final TestResult result;

        Result(TestResult testResult) {
            this.result = testResult;
        }

        @Override
        public TestResult getResult() {
            return this.result;
        }
    }

    private static class OutputProgress
    implements ExecuteTestBuildOperationType.Output {
        private final TestOutputEvent event;

        private OutputProgress(TestOutputEvent event) {
            this.event = event;
        }

        @Override
        public TestOutputEvent getOutput() {
            return this.event;
        }
    }

    private static class Details
    implements ExecuteTestBuildOperationType.Details {
        private final TestDescriptor testDescriptor;
        private long startTime;

        Details(TestDescriptor testDescriptor, long startTime) {
            this.testDescriptor = testDescriptor;
            this.startTime = startTime;
        }

        @Override
        public TestDescriptor getTestDescriptor() {
            return this.testDescriptor;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }
    }
}

