/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalFileSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarHasher
implements RegularFileHasher,
ConfigurableNormalizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarHasher.class);
    private final ResourceHasher classpathResourceHasher;
    private final ResourceFilter classpathResourceFilter;

    public JarHasher(ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter) {
        this.classpathResourceHasher = classpathResourceHasher;
        this.classpathResourceFilter = classpathResourceFilter;
    }

    @Override
    @Nullable
    public HashCode hash(PhysicalFileSnapshot fileSnapshot) {
        return this.hashJarContents(fileSnapshot);
    }

    @Override
    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        hasher.putString(this.getClass().getName());
        this.classpathResourceHasher.appendConfigurationToHasher(hasher);
        this.classpathResourceFilter.appendConfigurationToHasher(hasher);
    }

    private HashCode hashJarContents(PhysicalFileSnapshot jarFileSnapshot) {
        try {
            List<NormalizedFileSnapshot> snapshots = this.snapshotZipEntries(jarFileSnapshot.getAbsolutePath());
            if (snapshots.isEmpty()) {
                return null;
            }
            DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
            NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, snapshots);
            return hasher.hash();
        }
        catch (Exception e) {
            return this.hashMalformedZip(jarFileSnapshot, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NormalizedFileSnapshot> snapshotZipEntries(String jarFile) throws IOException {
        ArrayList arrayList;
        ArrayList snapshots = Lists.newArrayList();
        InputStream fileInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = Files.newInputStream(Paths.get(jarFile, new String[0]), new OpenOption[0]);
            ZipInputStream zipInput = new ZipInputStream(fileInputStream);
            RelativePathFactory relativePathFactory = new RelativePathFactory();
            while ((zipEntry = zipInput.getNextEntry()) != null) {
                HashCode hash;
                relativePathFactory.setZipEntry(zipEntry);
                if (zipEntry.isDirectory() || this.classpathResourceFilter.shouldBeIgnored(relativePathFactory) || (hash = this.classpathResourceHasher.hash(zipEntry, zipInput)) == null) continue;
                snapshots.add(new DefaultNormalizedFileSnapshot(zipEntry.getName(), FileType.RegularFile, hash));
            }
            arrayList = snapshots;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return arrayList;
    }

    private HashCode hashMalformedZip(PhysicalFileSnapshot jarFileSnapshot, Exception e) {
        LOGGER.debug("Malformed jar '{}' found on classpath. Falling back to full content hash instead of classpath hashing.", (Object)jarFileSnapshot.getName(), (Object)e);
        return jarFileSnapshot.getHash();
    }

    private static class RelativePathFactory
    implements Factory<String[]> {
        private ZipEntry zipEntry;

        private RelativePathFactory() {
        }

        @Override
        public String[] create() {
            return FilePathUtil.getPathSegments(this.zipEntry.getName());
        }

        public void setZipEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }
    }
}

