/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.notations.ModuleIdentifierNotationConverter;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.rules.DefaultRuleActionAdapter;
import org.gradle.internal.rules.DefaultRuleActionValidator;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionAdapter;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

public class DefaultComponentSelectionRules
implements ComponentSelectionRulesInternal {
    private static final String INVALID_SPEC_ERROR = "Could not add a component selection rule for module '%s'.";
    public static final List<Class<?>> VALID_INPUT_TYPES = Lists.newArrayList((Object[])new Class[]{ComponentMetadata.class, IvyModuleDescriptor.class});
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private Set<SpecRuleAction<? super ComponentSelection>> rules;
    private final RuleActionAdapter ruleActionAdapter;
    private final NotationParser<Object, ModuleIdentifier> moduleIdentifierNotationParser;

    public DefaultComponentSelectionRules(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this(moduleIdentifierFactory, DefaultComponentSelectionRules.createAdapter());
    }

    protected DefaultComponentSelectionRules(ImmutableModuleIdentifierFactory moduleIdentifierFactory, RuleActionAdapter ruleActionAdapter) {
        this.ruleActionAdapter = ruleActionAdapter;
        this.moduleIdentifierNotationParser = NotationParserBuilder.toType(ModuleIdentifier.class).fromCharSequence(new ModuleIdentifierNotationConverter(moduleIdentifierFactory)).toComposite();
    }

    public void setMutationValidator(MutationValidator mutationValidator) {
        this.mutationValidator = mutationValidator;
    }

    private static RuleActionAdapter createAdapter() {
        DefaultRuleActionValidator ruleActionValidator = new DefaultRuleActionValidator(VALID_INPUT_TYPES);
        return new DefaultRuleActionAdapter(ruleActionValidator, "ComponentSelectionRules");
    }

    @Override
    public Collection<SpecRuleAction<? super ComponentSelection>> getRules() {
        return this.rules != null ? this.rules : Collections.emptySet();
    }

    @Override
    public ComponentSelectionRules all(Action<? super ComponentSelection> selectionAction) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromAction(selectionAction)));
    }

    @Override
    public ComponentSelectionRules all(Closure<?> closure) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromClosure(ComponentSelection.class, closure)));
    }

    @Override
    public ComponentSelectionRules all(Object ruleSource) {
        return this.addRule(this.createAllSpecRulesAction(this.ruleActionAdapter.createFromRuleSource(ComponentSelection.class, ruleSource)));
    }

    @Override
    public ComponentSelectionRules withModule(Object id, Action<? super ComponentSelection> selectionAction) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromAction(selectionAction)));
    }

    @Override
    public ComponentSelectionRules withModule(Object id, Closure<?> closure) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromClosure(ComponentSelection.class, closure)));
    }

    @Override
    public ComponentSelectionRules withModule(Object id, Object ruleSource) {
        return this.addRule(this.createSpecRuleActionFromId(id, this.ruleActionAdapter.createFromRuleSource(ComponentSelection.class, ruleSource)));
    }

    @Override
    public ComponentSelectionRules addRule(SpecRuleAction<? super ComponentSelection> specRuleAction) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        if (this.rules == null) {
            this.rules = new HashSet<SpecRuleAction<? super ComponentSelection>>();
        }
        this.rules.add(specRuleAction);
        return this;
    }

    @Override
    public ComponentSelectionRules addRule(RuleAction<? super ComponentSelection> specRuleAction) {
        return this.addRule(this.createAllSpecRulesAction(specRuleAction));
    }

    private SpecRuleAction<? super ComponentSelection> createSpecRuleActionFromId(Object id, RuleAction<? super ComponentSelection> ruleAction) {
        ModuleIdentifier moduleIdentifier;
        try {
            moduleIdentifier = this.moduleIdentifierNotationParser.parseNotation(id);
        }
        catch (UnsupportedNotationException e) {
            throw new InvalidUserCodeException(String.format(INVALID_SPEC_ERROR, id == null ? "null" : id.toString()), e);
        }
        ComponentSelectionMatchingSpec spec = new ComponentSelectionMatchingSpec(moduleIdentifier);
        return new SpecRuleAction<ComponentSelection>(ruleAction, spec);
    }

    private SpecRuleAction<? super ComponentSelection> createAllSpecRulesAction(RuleAction<? super ComponentSelection> ruleAction) {
        return new SpecRuleAction<ComponentSelection>(ruleAction, Specs.satisfyAll());
    }

    static class ComponentSelectionMatchingSpec
    implements Spec<ComponentSelection> {
        final ModuleIdentifier target;

        private ComponentSelectionMatchingSpec(ModuleIdentifier target) {
            this.target = target;
        }

        @Override
        public boolean isSatisfiedBy(ComponentSelection selection) {
            return selection.getCandidate().getGroup().equals(this.target.getGroup()) && selection.getCandidate().getModule().equals(this.target.getName());
        }
    }
}

