/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.utils.BaseWSFromFileAction;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.WSInvokeExternalCodeUtil;
import com.intellij.ws.xml.jaxb.GenerateJavaFromJAXBSchemasDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateJavaFromJAXBSchemasAction
extends BaseWSFromFileAction {
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.jaxb.java");
    @NonNls
    static final String DTD_FILE_EXTENTION = "dtd";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateJavaFromJAXBSchemasAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)DataKeys.PROJECT.getData(e.getDataContext());
        this.runAction(project, null, (PsiFile)DataKeys.PSI_FILE.getData(e.getDataContext()));
    }

    private void runAction(Project project, @Nullable GenerateJavaFromJAXBSchemasDialog previousDialog, PsiFile file) {
        GenerateJavaFromJAXBSchemasDialog dialog = new GenerateJavaFromJAXBSchemasDialog(project, previousDialog);
        if (file != null) {
            dialog.setCurrentFile(file);
        }
        if (dialog.showAndGet()) {
            this.doAction(project, dialog);
        }
    }

    private void doAction(Project project, GenerateJavaFromJAXBSchemasDialog dialog) {
        VirtualFile parent;
        VirtualFile virtualFile;
        List files;
        File path;
        ApplicationManager.getApplication().saveAll();
        LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("generate.java.code.from.jaxb.schemas.lvcs.action", new Object[0]));
        LinkedList<String> parameters = new LinkedList<String>();
        String packagePrefix = dialog.getPackagePrefix().getText();
        String outputPath = (String)dialog.getOutputPaths().getSelectedItem();
        Module moduleForFile = LibUtils.findModuleByOutputPath(project, outputPath);
        if (packagePrefix.length() > 0) {
            WebServicesPluginSettings.getInstance().addLastPackagePrefix(packagePrefix);
            parameters.add("-p");
            parameters.add(packagePrefix);
            new File(outputPath + File.separator + packagePrefix.replace('.', File.separatorChar)).mkdirs();
        }
        parameters.add("-d");
        parameters.add(outputPath);
        String moduleClassPath = InvokeExternalCodeUtil.buildClasspathForModule((Module)moduleForFile);
        ArrayList<String> classPath = new ArrayList<String>(StringUtil.split((String)moduleClassPath, (String)InvokeExternalCodeUtil.CLASS_PATH_SEPARATOR));
        if (moduleClassPath.length() > 0 && !WebServicePlatformUtils.isJdk1_6SetUpForModule(moduleForFile) && (path = new File(WebServicesPluginSettings.getInstance().getJwsdpPath())).exists() && path.isDirectory() && (files = FileUtil.findFilesByMask((Pattern)Pattern.compile("jaxb(.)*\\.jar"), (File)path)).size() > 0) {
            Function file2Name = file -> file.getName();
            for (File file2 : files) {
                classPath.add(file2.getPath());
            }
        }
        if (!StringUtil.isEmptyOrSpaces((String)dialog.getExternalBinding())) {
            parameters.add("-b");
            parameters.add(dialog.getExternalBinding());
        }
        if (dialog.toMarkGeneratedCodeWithAnnotations()) {
            parameters.add("-mark-generated");
        }
        if (dialog.toEnableSourceLocationSupport()) {
            parameters.add("-Xlocator");
        }
        if (dialog.toCreateSynchronizedMethods()) {
            parameters.add("-Xsync-methods");
        }
        if (dialog.toMakeGeneratedCodeReadOnly()) {
            parameters.add("-readOnly");
        }
        if (!dialog.toCreatePackageLevelAnnotations()) {
            parameters.add("-npa");
        }
        if (dialog.doNotGenerateHeader()) {
            parameters.add("-no-header");
        }
        parameters.add("-quiet");
        String url = (String)dialog.getUrl().getComboBox().getSelectedItem();
        Object[] urls = url.split("\u0000");
        WebServicesPluginSettings.getInstance().addLastJAXBUrl(urls[urls.length - 1]);
        ContainerUtil.addAll(parameters, (Object[])urls);
        if (url.endsWith("wsdl")) {
            parameters.add("-wsdl");
        } else if (url.endsWith(DTD_FILE_EXTENTION)) {
            parameters.add("-dtd");
        }
        Consumer atFailure = e -> {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"XJC generation error");
            LOG.debug((Throwable)e);
        };
        ExternalEngine engine = WebServicesPluginSettings.getInstance().getEngineManager().getExternalEngineByName("JAXB 2");
        String basePath = engine.getBasePath();
        String[] classpath = ArrayUtil.mergeArrays((String[])LibUtils.getLibUrlsForToolRunning(engine, moduleForFile), (String[])ArrayUtil.toStringArray(classPath));
        WsJavaExternalProcessHandler processHandler = new WsJavaExternalProcessHandler("XJC", basePath != null ? "com.sun.tools.xjc.XJCFacade" : "com.sun.tools.internal.xjc.Driver", classpath, ArrayUtil.toStringArray(parameters), moduleForFile, true);
        PsiClass currentClass = dialog.getCurrentClass();
        if (currentClass != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)currentClass)) != null && (parent = virtualFile.getParent()) != null) {
            processHandler.setLaunchDir(VfsUtilCore.virtualToIoFile((VirtualFile)parent));
        }
        WSInvokeExternalCodeUtil.addEndorsedJarDirectory(processHandler, engine, moduleForFile);
        InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)processHandler, (Project)project, () -> GenerateJavaFromJAXBSchemasAction.lambda$doAction$2(dialog, moduleForFile, engine, (String[])urls, outputPath, packagePrefix, atFailure), (Consumer)atFailure, () -> true, () -> this.runAction(project, dialog, null));
    }

    static boolean isAcceptableFileForGenerateJAXBJavaFromSchema(VirtualFile virtualFile) {
        String extension = virtualFile.getExtension();
        return "xsd".equals(extension) || DTD_FILE_EXTENTION.equals(extension) || "wsdl".equals(extension);
    }

    public boolean isAcceptableFile(VirtualFile file) {
        return GenerateJavaFromJAXBSchemasAction.isAcceptableFileForGenerateJAXBJavaFromSchema(file);
    }

    private static /* synthetic */ void lambda$doAction$2(GenerateJavaFromJAXBSchemasDialog dialog, Module moduleForFile, ExternalEngine engine, String[] urls, String outputPath, String packagePrefix, Consumer atFailure) {
        if (dialog.getAddLibs().isSelected()) {
            LibUtils.setupLibsForGeneratedCode(moduleForFile, engine, null);
        }
        try {
            for (String schema : urls) {
                LibUtils.saveSourceGeneratedFile(schema, outputPath, packagePrefix);
            }
        }
        catch (IOException e) {
            atFailure.consume((Object)e);
            return;
        }
        CommonWsUtils.doFileSystemRefresh();
        InvokeExternalCodeUtil.navigateToPackage((Module)moduleForFile, (String)packagePrefix, (String)outputPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/xml/jaxb/GenerateJavaFromJAXBSchemasAction", "actionPerformed"));
    }
}

