/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.references.MemberReferenceThatKnowsAboutParentClassName;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSDDReferenceProvider
extends MyReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String WSDD_NAMESPACE = "http://xml.apache.org/axis/wsdd/";
    @NonNls
    public static final String WSDD_JAVA_PROVIDER_NAMESPACE = "http://xml.apache.org/axis/wsdd/providers/java";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    @NonNls
    public static final String PARAMETER_TAG_NAME = "parameter";
    @NonNls
    private static final String NAME_ATTR_VALUE = "allowedMethods";
    @NonNls
    public static final String NAME_ATTR_VALUE2 = "className";
    @NonNls
    public static final String BEANMAPPING_TAG_NAME = "beanMapping";
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();

    @Override
    public String[] getAttributeNames() {
        return new String[]{VALUE_ATTR_NAME};
    }

    @Override
    public ElementFilter getAttributeFilter() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            WSDDReferenceProvider.$$$reportNull$$$0(0);
        }
        XmlAttribute attr = (XmlAttribute)psiElement.getParent();
        XmlTag tag = attr.getParent();
        if (VALUE_ATTR_NAME.equals(attr.getName()) && PARAMETER_TAG_NAME.equals(tag.getLocalName()) && WSDD_NAMESPACE.equals(tag.getNamespace())) {
            String name = tag.getAttributeValue(NAME_ATTR_NAME);
            if (NAME_ATTR_VALUE.equals(name)) {
                String s = StringUtil.stripQuotesAroundValue((String)psiElement.getText());
                if (s.length() > 0) {
                    ArrayList<WSMethodReference> refs = new ArrayList<WSMethodReference>(1);
                    int lastOffset = 1;
                    int ind = s.indexOf(32);
                    while (ind >= 0) {
                        refs.add(new WSMethodReference(psiElement, new TextRange(lastOffset, ind + 1)));
                        lastOffset = ind + 2;
                        ind = s.indexOf(32, ind + 1);
                    }
                    refs.add(new WSMethodReference(psiElement, new TextRange(lastOffset, s.length() + 1)));
                    PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
                    if (psiReferenceArray == null) {
                        WSDDReferenceProvider.$$$reportNull$$$0(1);
                    }
                    return psiReferenceArray;
                }
            } else if (NAME_ATTR_VALUE2.equals(name)) {
                PsiReference[] psiReferenceArray = this.myClassProvider.getReferencesByElement(psiElement);
                if (psiReferenceArray == null) {
                    WSDDReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            WSDDReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/WSDDReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/WSDDReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WSMethodReference
    implements PsiReference,
    MemberReferenceThatKnowsAboutParentClassName {
        private final PsiElement myElement;
        private final TextRange myRange;
        private String myClassName;

        public WSMethodReference(PsiElement element, TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement resolve() {
            final String text = this.getCanonicalText();
            final PsiElement[] result = new PsiElement[1];
            this.processMethods(new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element.getName().equals(text)) {
                        result[0] = element;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference$1", "execute"));
                }
            });
            if ("*".equals(text)) {
                return this.myElement;
            }
            return result[0];
        }

        private void processMethods(PsiElementProcessor<PsiMethod> processor) {
            PsiElement parent = this.myElement.getParent().getParent().getParent();
            if (parent instanceof XmlTag) {
                XmlTag[] subTags;
                XmlTag parentTag = (XmlTag)parent;
                for (XmlTag p : subTags = parentTag.findSubTags(WSDDReferenceProvider.PARAMETER_TAG_NAME)) {
                    PsiElement psiElement;
                    PsiReference clazzRef = this.findReference(p);
                    PsiElement psiElement2 = psiElement = clazzRef != null ? clazzRef.resolve() : null;
                    if (!(psiElement instanceof PsiClass)) continue;
                    PsiClass psiClass = (PsiClass)psiElement;
                    this.myClassName = psiClass.getQualifiedName();
                    for (PsiMethod m : psiClass.getMethods()) {
                        if (!DeployUtils.isAcceptableMethod(m) || processor.execute((PsiElement)m)) continue;
                        return;
                    }
                }
            }
        }

        protected PsiReference findReference(XmlTag p) {
            PsiReference[] references;
            String value;
            if (WSDDReferenceProvider.NAME_ATTR_VALUE2.equals(p.getAttributeValue(WSDDReferenceProvider.NAME_ATTR_NAME)) && (value = p.getAttributeValue(WSDDReferenceProvider.VALUE_ATTR_NAME)) != null && (references = p.getAttribute(WSDDReferenceProvider.VALUE_ATTR_NAME, null).getValueElement().getReferences()).length > 0) {
                return references[references.length - 1];
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            final ArrayList results = new ArrayList(1);
            this.processMethods(new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    results.add(element.getName());
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtil.toStringArray(results);
            if (objectArray == null) {
                WSMethodReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                WSMethodReference.$$$reportNull$$$0(1);
            }
            return psiElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                WSMethodReference.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public String getCanonicalText() {
            String text = this.myElement.getText();
            String string = this.myRange.substring(text);
            if (string == null) {
                WSMethodReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String string) throws IncorrectOperationException {
            if (string == null) {
                WSMethodReference.$$$reportNull$$$0(4);
            }
            return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.myRange, string);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                WSMethodReference.$$$reportNull$$$0(5);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                WSMethodReference.$$$reportNull$$$0(6);
            }
            return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
        }

        @Override
        public String getParentClassName() {
            return this.myClassName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDDReferenceProvider$WSMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

