/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.model.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.model.jam.WSJamWebMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@WebService")
public abstract class WSJamWebService
implements JamElement {
    public static final JamClassMeta<WSJamWebService> META = new JamClassMeta(WSJamWebService.class);
    private static final JamAnnotationMeta myMeta = new JamAnnotationMeta("javax.jws.WebService");
    public static final JamStringAttributeMeta.Single<String> NAME_META = JamAttributeMeta.singleString((String)"name");
    public static final JamStringAttributeMeta.Single<String> SERVICE_NAME_META = JamAttributeMeta.singleString((String)"serviceName");
    public static final JamStringAttributeMeta.Single<String> PORT_NAME_META = JamAttributeMeta.singleString((String)"portName");
    public static final JamStringAttributeMeta.Single<String> WSDL_LOCATION_META = JamAttributeMeta.singleString((String)"wsdlLocation");
    public static final JamStringAttributeMeta.Single<String> ENDPOINT_INTERFACE_META = JamAttributeMeta.singleString((String)"endpointInterface");
    private static final JamChildrenQuery<WSJamWebMethod> WEB_METHODS_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)WSJamWebMethod.META, WSJamWebMethod.class);

    @JamPsiConnector
    @NotNull
    public abstract PsiClass getPsiElement();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @Nullable
    public PsiAnnotation getAnnotation() {
        return myMeta.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    public List<WSJamWebMethod> getWebMethods() {
        return WEB_METHODS_QUERY.findChildren(PsiElementRef.real((PsiElement)this.getPsiElement()));
    }

    @Nullable
    public String getName() {
        return ((JamStringAttributeElement)myMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_META)).getStringValue();
    }

    @Nullable
    public String getServiceName() {
        return ((JamStringAttributeElement)myMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), SERVICE_NAME_META)).getStringValue();
    }

    @Nullable
    public String getPortName() {
        return ((JamStringAttributeElement)myMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), PORT_NAME_META)).getStringValue();
    }

    @Nullable
    public String getWsdlLocation() {
        return ((JamStringAttributeElement)myMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), WSDL_LOCATION_META)).getStringValue();
    }

    @Nullable
    public String getEndpointInterface() {
        return ((JamStringAttributeElement)myMeta.getAttribute((PsiModifierListOwner)this.getPsiElement(), ENDPOINT_INTERFACE_META)).getStringValue();
    }

    static {
        META.addChildrenQuery(WEB_METHODS_QUERY);
    }
}

