/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.ws.actions.GenerateWsdlFromJavaDialog;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.BaseWSFromFileAction;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateWsdlFromJavaAction
extends BaseWSFromFileAction {
    private static final Logger LOG = Logger.getInstance(GenerateWsdlFromJavaAction.class);

    public boolean isAcceptableFile(VirtualFile file) {
        return super.isAcceptableFile(file);
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            GenerateWsdlFromJavaAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = anActionEvent.getDataContext();
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiJavaFile psiFile = file instanceof PsiJavaFile ? (PsiJavaFile)file : null;
        PsiClass classFromDataContext = psiFile != null ? (PsiClass)ArrayUtil.getFirstElement((Object[])psiFile.getClasses()) : null;
        this.invokeDialog(project, classFromDataContext, null);
    }

    private void invokeDialog(Project project, PsiClass classFromDataContext, @Nullable GenerateWsdlFromJavaDialog previousDialog) {
        GenerateWsdlFromJavaDialog dialog = new GenerateWsdlFromJavaDialog(project, classFromDataContext, previousDialog);
        if (dialog.showAndGet()) {
            this.doAction(dialog, project);
        }
    }

    private void doAction(GenerateWsdlFromJavaDialog dialog, Project project) {
        LocalHistory.getInstance().putSystemLabel(project, "Generate Wsdl from Java");
        WSEngine wsEngine = dialog.getCurrentWsEngine();
        PsiClass psiClass = dialog.getCurrentClass();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
        String[] classPathEntries = ArrayUtil.mergeArrays((String[])LibUtils.getLibUrlsForToolRunning(wsEngine, module), (String[])InvokeExternalCodeUtil.buildClasspathStringsForModule((Module)module));
        MyGenerateWsdlFromJavaOptions options = new MyGenerateWsdlFromJavaOptions(psiClass, dialog, module, classPathEntries);
        wsEngine.generateWsdlFromJava(options, (Consumer<? super File>)((Consumer)file -> {
            if (file != null && file.exists()) {
                VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> {
                    LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                    VirtualFile condainingDir = fileSystem.refreshAndFindFileByIoFile(file.getParentFile());
                    condainingDir.refresh(false, false);
                    return fileSystem.refreshAndFindFileByIoFile(file);
                });
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
            } else {
                Messages.showMessageDialog((Project)project, (String)"There is error in launching java 2 wsdl, please, send the exception to plugin author", (String)"Internal Error", (Icon)Messages.getErrorIcon());
            }
        }), (Consumer<? super Exception>)((Consumer)e -> {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            if (message != null && message.toLowerCase().startsWith("warning")) {
                return;
            }
            Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
        }), () -> this.invokeDialog(dialog.getProject(), dialog.getCurrentClass(), dialog));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/intellij/ws/actions/GenerateWsdlFromJavaAction", "actionPerformed"));
    }

    private static class MyGenerateWsdlFromJavaOptions
    implements GenerateWsdlFromJavaOptions,
    Computable<Boolean> {
        private final PsiClass psiClass;
        private final GenerateWsdlFromJavaDialog dialog;
        private final Module module;
        private final String[] classPathEntries;

        MyGenerateWsdlFromJavaOptions(PsiClass psiClass, GenerateWsdlFromJavaDialog dialog, Module module, String[] classPathEntries) {
            this.psiClass = psiClass;
            this.dialog = dialog;
            this.module = module;
            this.classPathEntries = classPathEntries;
        }

        @Override
        public PsiClass getClassForOperation() {
            return this.psiClass;
        }

        @Override
        public String getTypeMappingVersion() {
            return this.dialog.getTypeMappingVersion();
        }

        @Override
        public String getSoapAction() {
            return this.dialog.getSoapAction();
        }

        @Override
        public String getBindingStyle() {
            return this.dialog.getBindingStyle();
        }

        @Override
        public String getUseOfItems() {
            return this.dialog.getUseItemsInBindings();
        }

        @Override
        public String getGenerationType() {
            return this.dialog.getGenerationType();
        }

        @Override
        public String getMethods() {
            PsiMethod[] selectedMethods = this.dialog.getSelectedMethods();
            StringBuilder builder = new StringBuilder(selectedMethods.length * 8);
            for (PsiMethod m : selectedMethods) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(m.getName());
            }
            return builder.toString();
        }

        @Override
        public Module getModule() {
            return this.module;
        }

        @Override
        public String getWebServiceNamespace() {
            return this.dialog.getWebServiceNamespace().getText();
        }

        @Override
        public String getWebServiceURL() {
            return this.dialog.getWebServiceURL().getText();
        }

        @Override
        public String[] getClassPathEntries() {
            return this.classPathEntries;
        }

        @Override
        public Computable<Boolean> isParametersStillValidPredicate() {
            return this;
        }

        @Override
        public Runnable getSuccessRunnable(Consumer<? super File> successAction, File file) {
            return () -> successAction.consume((Object)file);
        }

        public Boolean compute() {
            return this.getClassForOperation().isValid() ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

