/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.TargetResolver;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntDuplicateTargetsInspection
extends AntInspection {
    @NonNls
    private static final String SHORT_NAME = "AntDuplicateTargetsInspection";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AntBundle.message("ant.duplicate.targets.inspection", new Object[0]);
        if (string == null) {
            AntDuplicateTargetsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            AntDuplicateTargetsInspection.$$$reportNull$$$0(1);
        }
        return SHORT_NAME;
    }

    protected void checkDomElement(DomElement element, final DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof AntDomProject) {
            final AntDomProject project = (AntDomProject)element;
            TargetResolver.validateDuplicateTargets(project.getContextAntProject(), new TargetResolver.TargetSink(){

                @Override
                public void duplicateTargetDetected(AntDomTarget existingTarget, AntDomTarget duplicatingTarget, String targetEffectiveName) {
                    String duplicatedMessage;
                    AntDomProject duplucatingTargetProj;
                    boolean isFromDifferentFiles;
                    AntDomProject existingTargetProj = existingTarget.getAntProject();
                    boolean bl = isFromDifferentFiles = !Comparing.equal((Object)existingTargetProj, (Object)(duplucatingTargetProj = duplicatingTarget.getAntProject()));
                    if (project.equals(existingTargetProj)) {
                        duplicatedMessage = isFromDifferentFiles ? AntBundle.message("target.is.duplicated.in.imported.file", targetEffectiveName, duplucatingTargetProj != null ? duplucatingTargetProj.getName() : "") : AntBundle.message("target.is.duplicated", targetEffectiveName);
                        holder.createProblem(existingTarget.getName(), duplicatedMessage, new LocalQuickFix[0]);
                    }
                    if (project.equals(duplucatingTargetProj)) {
                        duplicatedMessage = isFromDifferentFiles ? AntBundle.message("target.is.duplicated.in.imported.file", targetEffectiveName, existingTargetProj != null ? existingTargetProj.getName() : "") : AntBundle.message("target.is.duplicated", targetEffectiveName);
                        holder.createProblem(duplicatingTarget.getName(), duplicatedMessage, new LocalQuickFix[0]);
                    }
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/ant/validation/AntDuplicateTargetsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

