/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.actions.TargetActionStub;
import com.intellij.lang.ant.config.impl.ExecuteAfterCompilationEvent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntToolwindowRegistrar
implements ProjectComponent {
    private final Project myProject;

    public AntToolwindowRegistrar(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        String prefix = AntConfiguration.getActionIdPrefix(this.myProject);
        ActionManager actionManager = ActionManager.getInstance();
        for (Keymap keymap : keymapManager.getAllKeymaps()) {
            for (String id : keymap.getActionIdList()) {
                if (!id.startsWith(prefix) || actionManager.getAction(id) != null) continue;
                actionManager.registerAction(id, (AnAction)new TargetActionStub(id, this.myProject));
            }
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        compilerManager.addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfiguration config = AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                ((AntConfigurationBase)config).ensureInitialized();
                return config.executeTargetBeforeCompile(AntToolwindowRegistrar.createDataContext(context));
            }
        });
        compilerManager.addAfterTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfigurationBase config = (AntConfigurationBase)AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                config.ensureInitialized();
                if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                    AntBuildTarget target = config.getTargetForEvent(ExecuteAfterCompilationEvent.getInstance());
                    if (target != null) {
                        context.addMessage(CompilerMessageCategory.INFORMATION, "Skipping ant target \"" + target.getDisplayName() + "\" because of compilation errors", null, -1, -1);
                    }
                    return true;
                }
                return config.executeTargetAfterCompile(AntToolwindowRegistrar.createDataContext(context));
            }
        });
    }

    @NotNull
    private static DataContext createDataContext(CompileContext context) {
        CompileScope scope;
        Module[] modules;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Project project = context.getProject();
        if (project != null) {
            dataMap.put(CommonDataKeys.PROJECT.getName(), project);
        }
        if ((modules = (scope = context.getCompileScope()).getAffectedModules()).length == 1) {
            dataMap.put(LangDataKeys.MODULE.getName(), modules[0]);
        }
        dataMap.put(LangDataKeys.MODULE_CONTEXT_ARRAY.getName(), modules);
        dataMap.put("COMPILER_CONTEXT_MAKE", context.isMake());
        DataContext dataContext = SimpleDataContext.getSimpleContext(dataMap, null);
        if (dataContext == null) {
            AntToolwindowRegistrar.$$$reportNull$$$0(0);
        }
        return dataContext;
    }

    public void projectClosed() {
        String[] oldIds;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (String oldId : oldIds = actionManager.getActionIds(AntConfiguration.getActionIdPrefix(this.myProject))) {
            actionManager.unregisterAction(oldId);
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("AntToolwindowRegistrar" == null) {
            AntToolwindowRegistrar.$$$reportNull$$$0(1);
        }
        return "AntToolwindowRegistrar";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/ant/config/impl/AntToolwindowRegistrar";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

