/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.ParameterReceiverElement;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryAttributeDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryHtmlTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryIdOrTypeAttributeDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryNamespaceDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryParameterDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryUnknownTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.psi.TmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DescriptorUtil {
    private DescriptorUtil() {
    }

    public static XmlAttributeDescriptor[] getAttributeDescriptors(@NotNull XmlTag context) {
        if (context == null) {
            DescriptorUtil.$$$reportNull$$$0(0);
        }
        XmlAttributeDescriptor[] result = DescriptorUtil.getAttributeDescriptorsImpl(context);
        List<Mixin> mixins = DescriptorUtil.findMixins(context);
        if (mixins.isEmpty()) {
            return result;
        }
        ArrayList listResult = new ArrayList(result.length);
        Collections.addAll(listResult, result);
        for (Mixin mixin : mixins) {
            ContainerUtil.addAll(listResult, (Object[])DescriptorUtil.getAttributeDescriptors(mixin, null));
        }
        return listResult.toArray(XmlAttributeDescriptor.EMPTY);
    }

    private static XmlAttributeDescriptor[] getAttributeDescriptorsImpl(XmlTag context) {
        Component component = TapestryUtils.getTypeOfTag(context);
        String id = DescriptorUtil.getTAttributeName(context, "id");
        if (component != null) {
            return DescriptorUtil.getAttributeDescriptors(component, id == null ? null : new TapestryIdOrTypeAttributeDescriptor(id, context));
        }
        if (id == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        String type = DescriptorUtil.getTAttributeName(context, "type");
        return new XmlAttributeDescriptor[]{new TapestryIdOrTypeAttributeDescriptor(type, context), new TapestryIdOrTypeAttributeDescriptor(id, context)};
    }

    @Nullable
    static String getTAttributeName(@NotNull XmlTag context, String attrName) {
        String prefix;
        if (context == null) {
            DescriptorUtil.$$$reportNull$$$0(1);
        }
        if ((prefix = context.getPrefixByNamespace(TapestryXmlExtension.getTapestryNamespace(context))) == null) {
            return null;
        }
        return prefix.length() > 0 ? prefix + ":" + attrName : attrName;
    }

    @Nullable
    private static XmlElementDescriptor getImplicitHtmlContainer(@NotNull ParameterReceiverElement component, @NotNull XmlTag context) {
        XmlNSDescriptor descriptor;
        IJavaClassType aClass;
        if (component == null) {
            DescriptorUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DescriptorUtil.$$$reportNull$$$0(3);
        }
        if ((aClass = component.getElementClass()) != null && aClass.supportsInformalParameters() && (descriptor = context.getNSDescriptor("http://www.w3.org/1999/xhtml", false)) instanceof XmlNSDescriptorEx) {
            return ((XmlNSDescriptorEx)descriptor).getElementDescriptor("div", "http://www.w3.org/1999/xhtml");
        }
        return null;
    }

    public static XmlAttributeDescriptor[] getAttributeDescriptors(@Nullable ParameterReceiverElement component, @Nullable TapestryIdOrTypeAttributeDescriptor idAttrDescriptor) {
        XmlElementDescriptor div;
        PsiElement declaration;
        if (component == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        XmlAttributeDescriptor[] additionalParameters = XmlAttributeDescriptor.EMPTY;
        if (idAttrDescriptor != null && (declaration = idAttrDescriptor.getDeclaration()) instanceof XmlTag && (div = DescriptorUtil.getImplicitHtmlContainer(component, (XmlTag)declaration)) != null) {
            additionalParameters = div.getAttributesDescriptors((XmlTag)declaration);
        }
        Collection<TapestryParameter> params = component.getParameters().values();
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[params.size() + (idAttrDescriptor != null ? 1 : 0) + additionalParameters.length];
        int i = 0;
        for (TapestryParameter param : params) {
            descriptors[i++] = new TapestryAttributeDescriptor(param);
        }
        if (idAttrDescriptor != null) {
            descriptors[i++] = idAttrDescriptor;
        }
        for (XmlAttributeDescriptor attr : additionalParameters) {
            descriptors[i++] = attr;
        }
        return descriptors;
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptor(@NotNull String attributeName, @NotNull XmlTag context) {
        XmlElementDescriptor container;
        List<Mixin> mixins;
        String prefix;
        if (attributeName == null) {
            DescriptorUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DescriptorUtil.$$$reportNull$$$0(5);
        }
        if ((prefix = XmlUtil.findPrefixByQualifiedName((String)attributeName)).length() != 0 && context.getNamespaceByPrefix(prefix).length() == 0) {
            return null;
        }
        XmlAttribute attr = TapestryUtils.getIdentifyingAttribute(context);
        if (attr != null && attr.getName().equals(attributeName)) {
            return new TapestryIdOrTypeAttributeDescriptor(attributeName, context);
        }
        String id = DescriptorUtil.getTAttributeName(context, "id");
        if (attributeName.equals(id)) {
            return new TapestryIdOrTypeAttributeDescriptor(id, context);
        }
        Component component = TapestryUtils.getTypeOfTag(context);
        XmlAttributeDescriptor descriptor = DescriptorUtil.getAttributeDescriptor(attributeName, component, mixins = DescriptorUtil.findMixins(context));
        if (descriptor != null) {
            return descriptor;
        }
        if (component != null && (container = DescriptorUtil.getImplicitHtmlContainer(component, context)) != null && (descriptor = container.getAttributeDescriptor(attributeName, context)) == null && attributeName.indexOf(58) == -1) {
            descriptor = new AnyXmlAttributeDescriptor(attributeName);
        }
        return descriptor;
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptor(@NotNull String attributeName, @Nullable ParameterReceiverElement component, List<? extends Mixin> mixins) {
        XmlAttributeDescriptor descriptor;
        if (attributeName == null) {
            DescriptorUtil.$$$reportNull$$$0(6);
        }
        if ((descriptor = DescriptorUtil.getAttributeDescriptor(attributeName, component)) != null) {
            return descriptor;
        }
        for (Mixin mixin : mixins) {
            descriptor = DescriptorUtil.getAttributeDescriptor(attributeName, mixin);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptor(@NotNull String attributeName, @Nullable ParameterReceiverElement component) {
        if (attributeName == null) {
            DescriptorUtil.$$$reportNull$$$0(7);
        }
        if (component == null) {
            return null;
        }
        TapestryParameter param = component.getParameters().get(XmlUtil.findLocalNameByQualifiedName((String)attributeName));
        return param == null ? null : new TapestryAttributeDescriptor(param);
    }

    public static XmlElementDescriptor[] getTmlSubelementDescriptors(@NotNull XmlTag context, TapestryNamespaceDescriptor descriptor) {
        TapestryProject project;
        if (context == null) {
            DescriptorUtil.$$$reportNull$$$0(8);
        }
        if ((project = TapestryModuleSupportLoader.getTapestryProject((XmlElement)context)) == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        String namespacePrefix = context.getPrefixByNamespace(TapestryXmlExtension.getTapestryNamespace(context));
        Object[] namespaceElements = DescriptorUtil.getElementDescriptors(project.getAvailableElements(), namespacePrefix, descriptor, context);
        String parametersPrefix = context.getPrefixByNamespace("tapestry:parameter");
        Component component = TapestryUtils.getTypeOfTag(context);
        if (parametersPrefix == null || component == null) {
            return namespaceElements;
        }
        Object[] parameterElements = DescriptorUtil.getParameterDescriptors(component, parametersPrefix, DescriptorUtil.findMixins(context), descriptor);
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])namespaceElements, (Object[])parameterElements);
    }

    private static XmlElementDescriptor[] getElementDescriptors(@NotNull Collection<? extends PresentationLibraryElement> elements, String namespacePrefix, TapestryNamespaceDescriptor descriptor, XmlTag context) {
        if (elements == null) {
            DescriptorUtil.$$$reportNull$$$0(9);
        }
        Object[] descriptors = new TapestryTagDescriptor[elements.size()];
        int i = 0;
        for (PresentationLibraryElement presentationLibraryElement : elements) {
            descriptors[i++] = new TapestryTagDescriptor(presentationLibraryElement, namespacePrefix, descriptor);
        }
        Object[] descriptorsFromSchema = descriptor.getSuperRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class));
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])descriptorsFromSchema);
    }

    private static XmlElementDescriptor[] getParameterDescriptors(@NotNull Component component, String namespacePrefix, List<? extends Mixin> mixins, TapestryNamespaceDescriptor descriptor) {
        if (component == null) {
            DescriptorUtil.$$$reportNull$$$0(10);
        }
        Function mapping = parameter -> {
            if (component == null) {
                DescriptorUtil.$$$reportNull$$$0(15);
            }
            return new TapestryParameterDescriptor(component, (TapestryParameter)parameter, namespacePrefix, descriptor);
        };
        ArrayList result = new ArrayList(ContainerUtil.map(component.getParameters().values(), (Function)mapping));
        for (Mixin mixin : mixins) {
            result.addAll(ContainerUtil.map(mixin.getParameters().values(), (Function)mapping));
        }
        return (XmlElementDescriptor[])ArrayUtil.toObjectArray(result, XmlElementDescriptor.class);
    }

    @Nullable
    public static XmlElementDescriptor getTmlOrHtmlTagDescriptor(@NotNull XmlTag tag) {
        TmlFile file;
        if (tag == null) {
            DescriptorUtil.$$$reportNull$$$0(11);
        }
        if ((file = DescriptorUtil.getTmlFile(tag)) == null) {
            return null;
        }
        XmlElementDescriptor tmlDescriptor = DescriptorUtil.getTmlTagDescriptor(tag);
        if (tmlDescriptor != null) {
            return tmlDescriptor;
        }
        XmlElementDescriptor htmlDescriptor = DescriptorUtil.getHtmlTagDescriptor(tag, file);
        List<Mixin> mixins = DescriptorUtil.findMixins(tag);
        return htmlDescriptor != null ? new TapestryHtmlTagDescriptor(htmlDescriptor, TapestryUtils.getTypeOfTag(tag), mixins, TapestryXmlExtension.getTapestryTemplateDescriptor(tag)) : null;
    }

    @Nullable
    public static XmlElementDescriptor getHtmlTagDescriptorViaNsDescriptor(XmlTag tag) {
        TmlFile file = DescriptorUtil.getTmlFile(tag);
        return file == null ? null : DescriptorUtil.getHtmlTagDescriptor(tag, file);
    }

    @Nullable
    private static XmlElementDescriptor getHtmlTagDescriptor(XmlTag tag, TmlFile file) {
        XmlNSDescriptor htmlNSDescriptor = DescriptorUtil.getHtmlNSDescriptor(file);
        return htmlNSDescriptor instanceof XmlNSDescriptorImpl ? ((XmlNSDescriptorImpl)htmlNSDescriptor).getElementDescriptor(tag.getLocalName(), tag.getNamespace()) : htmlNSDescriptor.getElementDescriptor(tag);
    }

    @Nullable
    private static TmlFile getTmlFile(XmlTag tag) {
        PsiFile file = tag.getContainingFile();
        if (file instanceof TmlFile) {
            return (TmlFile)file;
        }
        XmlElement parentTag = (XmlElement)tag.getUserData(XmlElement.INCLUDING_ELEMENT);
        if (parentTag == null) {
            return null;
        }
        file = parentTag.getContainingFile();
        return file instanceof TmlFile ? (TmlFile)file : null;
    }

    @Nullable
    public static XmlNSDescriptor getHtmlNSDescriptor(TmlFile tmlFile) {
        XmlDocument doc = tmlFile.getDocument();
        if (doc == null) {
            return null;
        }
        return doc.getDefaultNSDescriptor("http://www.w3.org/1999/xhtml", false);
    }

    @Nullable
    public static XmlElementDescriptor getTmlTagDescriptor(XmlTag tag) {
        String prefix = tag.getNamespacePrefix();
        String tagNamespace = tag.getNamespace();
        if (TapestryXmlExtension.isTapestryTemplateNamespace(tagNamespace)) {
            XmlElementDescriptor descriptorFromTapestrySchema;
            Component component = TapestryUtils.getTypeOfTag(tag);
            List<Mixin> mixins = DescriptorUtil.findMixins(tag);
            TapestryNamespaceDescriptor tapestryNamespaceDescriptor = TapestryXmlExtension.getTapestryTemplateDescriptor(tag);
            if (mixins.isEmpty() && component == null && (descriptorFromTapestrySchema = tapestryNamespaceDescriptor.getElementDescriptor(tag.getLocalName(), tagNamespace)) != null) {
                return new TapestryHtmlTagDescriptor(descriptorFromTapestrySchema, null, mixins, tapestryNamespaceDescriptor);
            }
            return component == null ? new TapestryUnknownTagDescriptor(tag.getLocalName(), prefix, tapestryNamespaceDescriptor) : new TapestryTagDescriptor(component, mixins, prefix, tapestryNamespaceDescriptor);
        }
        if ("tapestry:parameter".equals(tagNamespace)) {
            XmlTag parentTag = tag.getParentTag();
            Component component = parentTag != null ? TapestryUtils.getTypeOfTag(parentTag) : null;
            String parameterName = tag.getLocalName();
            TapestryParameter parameter = component == null ? null : component.getParameters().get(parameterName);
            TapestryNamespaceDescriptor tapestryNamespaceDescriptor = TapestryXmlExtension.getTapestryTemplateDescriptor(tag);
            return parameter == null ? new TapestryUnknownTagDescriptor(parameterName, prefix, tapestryNamespaceDescriptor) : new TapestryParameterDescriptor(component, parameter, prefix, tapestryNamespaceDescriptor);
        }
        return null;
    }

    @NotNull
    private static List<Mixin> findMixins(@Nullable XmlTag tag) {
        String[] components;
        if (tag == null) {
            List<Mixin> list = Collections.emptyList();
            if (list == null) {
                DescriptorUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        TapestryProject tapestryProject = TapestryUtils.getTapestryProject((PsiElement)tag);
        XmlAttribute mixinsAttribute = tag.getAttribute("mixins", TapestryXmlExtension.getTapestryNamespace(tag));
        if (tapestryProject == null || mixinsAttribute == null) {
            List<Mixin> list = Collections.emptyList();
            if (list == null) {
                DescriptorUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<Mixin> result = new ArrayList<Mixin>();
        String value = mixinsAttribute.getValue();
        for (String mixinName : components = value != null ? value.split(",") : ArrayUtil.EMPTY_STRING_ARRAY) {
            Mixin mixin = tapestryProject.findMixin(mixinName);
            if (mixin == null) continue;
            result.add(mixin);
        }
        ArrayList<Mixin> arrayList = result;
        if (arrayList == null) {
            DescriptorUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findMixins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTAttributeName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitHtmlContainer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTmlSubelementDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTmlOrHtmlTagDescriptor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParameterDescriptors$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

