/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ResolvedValue;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverChain;
import com.intellij.tapestry.core.util.ClassUtils;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TemplateCompletionContributor
extends CompletionContributor {
    private static final Logger _logger = Logger.getInstance(TemplateCompletionContributor.class);

    public TemplateCompletionContributor() {
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement psiElement;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!((psiElement = parameters.getPosition()) instanceof LeafPsiElement)) {
                    return;
                }
                PsiElement prev = psiElement.getPrevSibling();
                if (prev != null && ".".equals(prev.getText())) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (!TapestryUtils.isTapestryModule(module)) {
                    return;
                }
                if (psiElement instanceof XmlToken && ((XmlToken)psiElement).getTokenType().toString().equals("XML_ATTRIBUTE_VALUE_TOKEN")) {
                    XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlAttribute.class);
                    XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
                    if (attribute == null) {
                        return;
                    }
                    if (TapestryXmlExtension.isTapestryTemplateNamespace(attribute.getNamespace()) && (attribute.getLocalName().equals("type") || attribute.getLocalName().equals("id") || attribute.getLocalName().equals("mixins"))) {
                        return;
                    }
                    Component component = TapestryUtils.getTypeOfTag(tag);
                    if (component == null) {
                        return;
                    }
                    TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
                    if (tapestryProject == null) {
                        return;
                    }
                    PresentationLibraryElement element = tapestryProject.findElementByTemplate(parameters.getOriginalFile());
                    if (element == null) {
                        return;
                    }
                    IntellijJavaClassType elementClass = (IntellijJavaClassType)element.getElementClass();
                    if (elementClass == null) {
                        return;
                    }
                    for (TapestryParameter parameter : component.getParameters().values()) {
                        String attributeValue = "";
                        if (tag != null) {
                            attributeValue = tag.getAttributeValue(attribute.getLocalName());
                        }
                        if (!parameter.getName().equalsIgnoreCase(attribute.getLocalName())) continue;
                        if (attributeValue != null) {
                            if (attributeValue.equals("prop:IntellijIdeaRulezzz ")) {
                                Set<String> properties = ClassUtils.getClassProperties(elementClass).keySet();
                                ArrayList<String> returnedProperties = new ArrayList<String>();
                                for (String property : properties) {
                                    returnedProperties.add("prop:" + property);
                                }
                                this.addVariants(result, returnedProperties);
                                return;
                            }
                            if (attributeValue.contains(".") && !attributeValue.contains("..") && (parameter.getDefaultPrefix().equals("prop") || attributeValue.startsWith("prop:"))) {
                                ResolvedValue resolvedValue;
                                if (attributeValue.contains(".IntellijIdeaRulezzz ")) {
                                    String words = "";
                                    Scanner scan = new Scanner(attributeValue);
                                    Object object = null;
                                    try {
                                        String word = "";
                                        while (scan.hasNext() && !word.contains("IntellijIdeaRulezzz")) {
                                            word = scan.next();
                                            words = words + word;
                                        }
                                    }
                                    catch (Throwable word) {
                                        object = word;
                                        throw word;
                                    }
                                    finally {
                                        if (scan != null) {
                                            if (object != null) {
                                                try {
                                                    scan.close();
                                                }
                                                catch (Throwable word) {
                                                    ((Throwable)object).addSuppressed(word);
                                                }
                                            } else {
                                                scan.close();
                                            }
                                        }
                                    }
                                    attributeValue = words.replaceFirst("IntellijIdeaRulezzz", "");
                                }
                                try {
                                    resolvedValue = ValueResolverChain.getInstance().resolve(tapestryProject, elementClass, attributeValue, parameter.getDefaultPrefix());
                                }
                                catch (Exception ex) {
                                    _logger.error((Throwable)ex);
                                    return;
                                }
                                if (resolvedValue != null && resolvedValue.getType() != null && resolvedValue.getType() instanceof IJavaClassType) {
                                    elementClass = new IntellijJavaClassType(module, ((IntellijJavaClassType)resolvedValue.getType()).getPsiClass().getContainingFile());
                                    Set<String> properties = ClassUtils.getClassProperties(elementClass).keySet();
                                    ArrayList<String> returnedProperties = new ArrayList<String>();
                                    for (String property : properties) {
                                        returnedProperties.add(attributeValue + property);
                                    }
                                    this.addVariants(result, returnedProperties);
                                    return;
                                }
                            }
                        }
                        if (parameter.getParameterField().getType() != null && parameter.getParameterField().getType().getName().toLowerCase(Locale.getDefault()).equals("boolean")) {
                            HashSet<String> attributes = new HashSet<String>(ClassUtils.getClassProperties(elementClass).keySet());
                            attributes.add("literal:true");
                            attributes.add("literal:false");
                            this.addVariants(result, attributes);
                            return;
                        }
                        if (!parameter.getDefaultPrefix().equals("prop")) continue;
                        this.addVariants(result, ClassUtils.getClassProperties(elementClass).keySet());
                    }
                }
            }

            private void addVariants(@NotNull CompletionResultSet result, Collection<String> returnedProperties) {
                if (result == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (String property : returnedProperties) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)property).withCaseSensitivity(false));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/tapestry/intellij/lang/completion/TemplateCompletionContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCompletions";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addVariants";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

