/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.createnew;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.actions.createnew.AddNewComponentDialog;
import com.intellij.tapestry.intellij.actions.createnew.AddNewElementAction;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.util.Validators;
import com.intellij.tapestry.intellij.view.nodes.PagesNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AddNewPageAction
extends AddNewElementAction<PagesNode> {
    public AddNewPageAction() {
        super(PagesNode.class);
    }

    @Override
    protected String getElementsRootPackage(@NotNull TapestryProject tapestryProject) {
        if (tapestryProject == null) {
            AddNewPageAction.$$$reportNull$$$0(0);
        }
        return tapestryProject.getPagesRootPackage();
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Module module;
        if (event == null) {
            AddNewPageAction.$$$reportNull$$$0(1);
        }
        if ((module = AddNewPageAction.getModule(event)) == null) {
            return;
        }
        String defaultPagePath = this.getDefaultElementPath(event, module);
        if (defaultPagePath == null) {
            return;
        }
        AddNewComponentDialog addNewComponentDialog = new AddNewComponentDialog((Module)event.getDataContext().getData(DataKeys.MODULE.getName()), defaultPagePath, true);
        DialogBuilder builder = new DialogBuilder(module.getProject());
        builder.setCenterPanel((JComponent)addNewComponentDialog.getContentPane());
        builder.setTitle("New Tapestry Page");
        builder.setButtonsAlignment(0);
        builder.setPreferredFocusComponent(addNewComponentDialog.getNameComponent());
        builder.setOkOperation(() -> {
            String pageName = addNewComponentDialog.getNewComponentName();
            if (!Validators.isValidComponentName(pageName)) {
                Messages.showErrorDialog((String)"Invalid page name!", (String)CommonBundle.getErrorTitle());
                return;
            }
            String classSourceDir = addNewComponentDialog.getClassSourceDirectory().getPath();
            String templateSourceDir = addNewComponentDialog.getTemplateSourceDirectory().getPath();
            TapestryModuleSupportLoader.getInstance(module).getState().setNewPagesClassesSourceDirectory(classSourceDir);
            TapestryModuleSupportLoader.getInstance(module).getState().setNewPagesTemplatesSourceDirectory(templateSourceDir);
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    PsiDirectory classSourceDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(addNewComponentDialog.getClassSourceDirectory());
                    PsiDirectory templateSourceDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(addNewComponentDialog.getTemplateSourceDirectory());
                    if (addNewComponentDialog.isNotCreatingTemplate()) {
                        TapestryUtils.createPage(module, classSourceDirectory, null, pageName, addNewComponentDialog.isReplaceExistingFiles());
                    } else {
                        TapestryUtils.createPage(module, classSourceDirectory, templateSourceDirectory, pageName, addNewComponentDialog.isReplaceExistingFiles());
                    }
                }
                catch (IllegalStateException ex) {
                    Messages.showWarningDialog((Project)module.getProject(), (String)ex.getMessage(), (String)"Error creating page");
                }
            });
            builder.getWindow().dispose();
        });
        builder.showModal(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tapestryProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tapestry/intellij/actions/createnew/AddNewPageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsRootPackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

