/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.util;

import java.io.File;

public class PathUtils {
    public static final String TAPESTRY_PATH_SEPARATOR = "/";
    public static final String SYSTEM_PATH_SEPARATOR = File.separator;
    public static final String UNIX_PATH_SEPARATOR = "/";
    public static final String WINDOWS_PATH_SEPARATOR = "\\";
    public static final String PACKAGE_SEPARATOR = ".";

    public static String packageIntoPath(String packageName, boolean includeFinalSeparator) {
        if (PathUtils.isEmpty(packageName)) {
            return "";
        }
        return packageName.replace(PACKAGE_SEPARATOR, "/") + (includeFinalSeparator ? "/" : "");
    }

    public static String pathIntoPackage(String path, boolean removeLastElement) {
        if (PathUtils.isEmpty(path)) {
            return "";
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (removeLastElement && path.lastIndexOf("/") != -1) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        return path.replace("/", PACKAGE_SEPARATOR);
    }

    public static String getFullComponentPackage(String basePackage, String componentName) {
        if (PathUtils.isEmpty(componentName) || componentName.indexOf("/") == -1) {
            return basePackage != null ? basePackage : "";
        }
        String pathPath = componentName.substring(0, componentName.lastIndexOf("/"));
        return basePackage + PACKAGE_SEPARATOR + pathPath.replace("/", PACKAGE_SEPARATOR);
    }

    public static String getLastPathElement(String path) {
        if (PathUtils.isEmpty(path)) {
            return "";
        }
        if (path.indexOf("/") == -1) {
            return path;
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getFirstPathElement(String path) {
        if (PathUtils.isEmpty(path)) {
            return "";
        }
        if (path.indexOf("/") == -1) {
            return path;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.substring(0, path.indexOf("/"));
    }

    public static String removeLastFilePathElement(String path, boolean removeIfOnlyOneElement) {
        if (PathUtils.isEmpty(path)) {
            return "";
        }
        String separator = PathUtils.findSeparator(path);
        if (separator == null) {
            if (removeIfOnlyOneElement) {
                return "";
            }
            return path;
        }
        return path.substring(0, path.lastIndexOf(separator));
    }

    public static String getComponentFileName(String componentName) {
        if (PathUtils.isEmpty(componentName)) {
            return "";
        }
        if (componentName.indexOf("/") == -1) {
            return componentName;
        }
        return componentName.substring(componentName.lastIndexOf("/") + 1);
    }

    public static String toUnixPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace(File.separatorChar, '/');
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static String findSeparator(String path) {
        if (path.indexOf(WINDOWS_PATH_SEPARATOR) != -1) {
            return WINDOWS_PATH_SEPARATOR;
        }
        if (path.indexOf("/") != -1) {
            return "/";
        }
        return null;
    }
}

