/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation.valueresolvers.property;

import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.model.presentation.valueresolvers.AbstractValueResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverContext;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.chain.Context;

public class SingleMethodResolver
extends AbstractValueResolver {
    private static final Pattern PATTERN = Pattern.compile("\\w+\\(\\)");

    public boolean execute(Context context) throws Exception {
        String cleanValue = SingleMethodResolver.getCleanValue(((ValueResolverContext)context).getValue());
        if (PATTERN.matcher(cleanValue).matches()) {
            Collection<IJavaMethod> candidateMethods = ((ValueResolverContext)context).getContextClass().findPublicMethods(cleanValue.substring(0, cleanValue.indexOf("()")));
            for (IJavaMethod method : candidateMethods) {
                if (method.getParameters().size() != 0) continue;
                ((ValueResolverContext)context).setResultType(method.getReturnType());
                if (method.getReturnType() != null) {
                    ((ValueResolverContext)context).setResultCodeBind(method);
                }
                return true;
            }
            return true;
        }
        return false;
    }
}

