/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.externalizable.ExternalizableToClass;
import com.intellij.tapestry.core.model.externalizable.ExternalizableToDocumentation;
import com.intellij.tapestry.core.model.externalizable.documentation.generationchain.DocumentationGenerationChain;
import com.intellij.tapestry.core.model.externalizable.toclasschain.ExternalizeToClassChain;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.TemplateElement;
import com.intellij.tapestry.core.resource.CoreXmlRecursiveElementVisitor;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.core.resource.xml.XmlAttribute;
import com.intellij.tapestry.core.resource.xml.XmlTag;
import com.intellij.tapestry.core.util.ComponentUtils;
import com.intellij.tapestry.core.util.LocalizationUtils;
import com.intellij.tapestry.core.util.PathUtils;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class PresentationLibraryElement
implements ExternalizableToDocumentation,
ExternalizableToClass {
    private final IJavaClassType _class;
    private final TapestryProject _project;
    private String _name;
    private final Library _library;
    private String _documentationCache;
    private IResource[] _messageCatalogCache;
    private long _documentationTimestamp;
    private final ElementType _elementType;
    static final String PARAMETER_ANNOTATION = "org.apache.tapestry5.annotations.Parameter";

    PresentationLibraryElement(Library library, IJavaClassType elementClass, TapestryProject project) {
        this._class = elementClass;
        this._project = project;
        this._library = library;
        if (library != null && library.getId() != null) {
            this._name = this.getElementNameFromClass(library.getBasePackage());
            this._elementType = PresentationLibraryElement.getElementType(this._class, library.getBasePackage());
        } else {
            try {
                this._name = this.getElementNameFromClass(null);
            }
            catch (NotTapestryElementException notTapestryElementException) {
                // empty catch block
            }
            this._elementType = ElementType.COMPONENT;
        }
    }

    public static PresentationLibraryElement createElementInstance(Library library, IJavaClassType elementClass, TapestryProject project) throws NotTapestryElementException {
        switch (PresentationLibraryElement.getElementType(elementClass, library.getBasePackage())) {
            case COMPONENT: {
                return new Component(library, elementClass, project);
            }
            case PAGE: {
                return new Page(library, elementClass, project);
            }
            case MIXIN: {
                return new Mixin(library, elementClass, project);
            }
        }
        throw new NotTapestryElementException(elementClass.getFullyQualifiedName() + " is not a Tapestry class.");
    }

    public static PresentationLibraryElement createProjectElementInstance(IJavaClassType elementClass, TapestryProject project) throws NotTapestryElementException {
        return PresentationLibraryElement.createElementInstance(project.getApplicationLibrary(), elementClass, project);
    }

    public abstract boolean allowsTemplate();

    public abstract IResource[] getTemplate();

    public IResource[] getTemplateConsiderSuperClass() {
        IResource[] resources = this.getTemplate();
        if (resources.length > 0) {
            return resources;
        }
        IJavaClassType superClass = this.getElementClass().getSuperClassType();
        if (superClass == null) {
            return IResource.EMPTY_ARRAY;
        }
        PresentationLibraryElement superElement = this.getProject().findElement(superClass);
        return superElement == null ? IResource.EMPTY_ARRAY : superElement.getTemplateConsiderSuperClass();
    }

    public IResource[] getMessageCatalog() {
        if (this._messageCatalogCache != null && PresentationLibraryElement.checkAllValidResources(this._messageCatalogCache)) {
            return this._messageCatalogCache;
        }
        String packageName = this.getElementClass().getFullyQualifiedName().substring(0, this.getElementClass().getFullyQualifiedName().lastIndexOf(46));
        Collection<IResource> resources = this.getProject().getResourceFinder().findLocalizedClasspathResource(PathUtils.packageIntoPath(packageName, true) + PathUtils.getLastPathElement(this.getName()) + ".properties", true);
        if (resources.size() > 0) {
            ArrayList<IResource> catalogs = new ArrayList<IResource>();
            for (IResource catalog : resources) {
                if (!LocalizationUtils.unlocalizeFileName(catalog.getName()).equals(PathUtils.getLastPathElement(this.getName()) + ".properties")) continue;
                catalogs.add(catalog);
            }
            this._messageCatalogCache = catalogs.toArray(IResource.EMPTY_ARRAY);
            return this._messageCatalogCache;
        }
        this._messageCatalogCache = IResource.EMPTY_ARRAY;
        return this._messageCatalogCache;
    }

    public String getDescription() {
        if (this._documentationCache != null && this.getElementClass().getFile().getFile().lastModified() <= this._documentationTimestamp) {
            return this._documentationCache;
        }
        this._documentationCache = this.getElementClass().getDocumentation();
        this._documentationTimestamp = this.getElementClass().getFile().getFile().lastModified();
        return this._documentationCache;
    }

    public IJavaClassType getElementClass() {
        return this._class;
    }

    public String getName() {
        return this._name;
    }

    public TapestryProject getProject() {
        return this._project;
    }

    public Library getLibrary() {
        return this._library;
    }

    public boolean equals(Object obj) {
        return obj instanceof PresentationLibraryElement && this.getName().equals(((PresentationLibraryElement)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public List<TemplateElement> getEmbeddedComponents() {
        ArrayList embeddedComponentsTemplate = new ArrayList();
        final ArrayList<TemplateElement> embeddedComponents = new ArrayList<TemplateElement>();
        for (IJavaField field : this._class.getFields(true).values()) {
            if (!field.isValid() || !field.getAnnotations().containsKey("org.apache.tapestry5.annotations.Component") || !(field.getType() instanceof IJavaClassType)) continue;
            IJavaAnnotation annotation = field.getAnnotations().get("org.apache.tapestry5.annotations.Component");
            Component component = annotation.getParameters().containsKey("type") ? this._project.findComponent(annotation.getParameters().get("type")[0]) : this._project.findComponent((IJavaClassType)field.getType());
            embeddedComponents.add(new TemplateElement(new InjectedElement(field, (PresentationLibraryElement)component), "class"));
        }
        final ArrayList<TemplateElement> embeddedComponentsClass = new ArrayList<TemplateElement>(embeddedComponents);
        for (int i = 0; i < this.getTemplate().length; ++i) {
            this.getTemplate()[i].accept(new CoreXmlRecursiveElementVisitor(){

                @Override
                public void visitTag(XmlTag tag) {
                    if (!ComponentUtils._isComponentTag(tag)) {
                        return;
                    }
                    boolean hasAttributeType = false;
                    InjectedElement injectedElement = null;
                    Component component = null;
                    for (XmlAttribute attribute : tag.getAttributes()) {
                        String value;
                        if (!attribute.getLocalName().equals("type") || !TapestryXmlExtension.isTapestryTemplateNamespace(attribute.getNamespace()) || (value = attribute.getValue()) == null) continue;
                        component = PresentationLibraryElement.this._project.findComponent(value);
                        injectedElement = new InjectedElement(tag, (PresentationLibraryElement)component);
                        hasAttributeType = true;
                    }
                    if (!hasAttributeType) {
                        component = PresentationLibraryElement.this._project.findComponent(tag.getLocalName());
                        injectedElement = new InjectedElement(tag, (PresentationLibraryElement)component);
                    }
                    if (embeddedComponents.isEmpty() || component == null) {
                        return;
                    }
                    for (TemplateElement element : embeddedComponents) {
                        String injectedElementId = injectedElement.getElementId();
                        if (injectedElementId == null) continue;
                        String elementId = element.getElement().getElementId();
                        PresentationLibraryElement libraryElement = element.getElement().getElement();
                        if (libraryElement == null || elementId == null || !elementId.equalsIgnoreCase(injectedElementId) || !libraryElement.getName().equalsIgnoreCase(injectedElement.getTag().getLocalName()) || injectedElement.getParameters().size() == 1 || embeddedComponentsClass.isEmpty()) continue;
                        embeddedComponentsClass.remove(element);
                    }
                }
            });
        }
        embeddedComponentsClass.addAll(embeddedComponentsTemplate);
        return embeddedComponentsClass;
    }

    public List<TemplateElement> getEmbeddedComponentsTemplate() {
        final ArrayList<TemplateElement> embeddedComponentsTemplate = new ArrayList<TemplateElement>();
        final List<TemplateElement> embeddedComponentsClass = this.getEmbeddedComponents();
        for (int i = 0; i < this.getTemplate().length; ++i) {
            final String _resource = this.getTemplate()[i].getName();
            this.getTemplate()[i].accept(new CoreXmlRecursiveElementVisitor(){

                @Override
                public void visitTag(XmlTag tag) {
                    if (ComponentUtils._isComponentTag(tag)) {
                        boolean hasAttributeType = false;
                        InjectedElement injectedElement = null;
                        Component component = null;
                        for (XmlAttribute attribute : tag.getAttributes()) {
                            if (!attribute.getLocalName().equals("type") || !TapestryXmlExtension.isTapestryTemplateNamespace(attribute.getNamespace())) continue;
                            component = PresentationLibraryElement.this._project.findComponent(attribute.getValue());
                            injectedElement = new InjectedElement(tag, (PresentationLibraryElement)component);
                            hasAttributeType = true;
                        }
                        if (!hasAttributeType) {
                            component = PresentationLibraryElement.this._project.findComponent(tag.getLocalName());
                            injectedElement = new InjectedElement(tag, (PresentationLibraryElement)component);
                        }
                        if (!embeddedComponentsClass.isEmpty() && component != null) {
                            TemplateElement element = new TemplateElement(injectedElement, "class");
                            if (!embeddedComponentsClass.contains(element)) {
                                embeddedComponentsTemplate.add(new TemplateElement(injectedElement, _resource));
                            }
                        } else if (component != null) {
                            embeddedComponentsTemplate.add(new TemplateElement(injectedElement, _resource));
                        }
                    }
                }
            });
        }
        return embeddedComponentsTemplate;
    }

    public List<InjectedElement> getInjectedPages() {
        ArrayList<InjectedElement> injectedPages = new ArrayList<InjectedElement>();
        for (IJavaField field : this._class.getFields(true).values()) {
            if (!field.isValid() || !field.getAnnotations().containsKey("org.apache.tapestry5.annotations.InjectPage")) continue;
            IJavaAnnotation annotation = field.getAnnotations().get("org.apache.tapestry5.annotations.InjectPage");
            if (annotation.getParameters().containsKey("value")) {
                Page page = this._project.findPage(annotation.getParameters().get("value")[0]);
                if (page == null) continue;
                injectedPages.add(new InjectedElement(field, (PresentationLibraryElement)page));
                continue;
            }
            IJavaClassType type = (IJavaClassType)field.getType();
            if (type == null) continue;
            injectedPages.add(new InjectedElement(field, (PresentationLibraryElement)this._project.findPage(type)));
        }
        return injectedPages;
    }

    public ElementType getElementType() {
        return this._elementType;
    }

    @Override
    public String getDocumentation() throws Exception {
        return DocumentationGenerationChain.getInstance().generate(this);
    }

    @Override
    public String getClassRepresentation(IJavaClassType targetClass) throws Exception {
        return ExternalizeToClassChain.getInstance().externalize(this, targetClass);
    }

    protected String getElementNameFromClass(String libraryRootPackage) throws NotTapestryElementException {
        if (!this._class.isPublic() || !this._class.hasDefaultConstructor()) {
            throw new NotTapestryElementException(this._class.getFullyQualifiedName() + " is not a valid Tapestry class.");
        }
        if (libraryRootPackage == null) {
            throw new NotTapestryElementException(this._class.getFullyQualifiedName() + " is not a valid Tapestry class.");
        }
        String elementClassFqn = this._class.getFullyQualifiedName();
        String elementName = elementClassFqn.substring(libraryRootPackage.length() + 1);
        if (elementName.startsWith("components")) {
            elementName = PathUtils.packageIntoPath(elementName.substring("components".length() + 1), false);
        } else if (elementName.startsWith("base")) {
            elementName = PathUtils.packageIntoPath(elementName.substring("base".length() + 1), false);
        } else if (elementName.startsWith("pages")) {
            elementName = PathUtils.packageIntoPath(elementName.substring("pages".length() + 1), false);
        } else if (elementName.startsWith("mixins")) {
            elementName = PathUtils.packageIntoPath(elementName.substring("mixins".length() + 1), false);
        } else {
            throw new NotTapestryElementException(this._class.getFullyQualifiedName() + " is not under a Tapestry base package.");
        }
        return elementName;
    }

    protected static boolean checkAllValidResources(IResource[] resources) {
        for (IResource resource : resources) {
            if (resource.getFile() != null && resource.getFile().exists()) continue;
            return false;
        }
        return true;
    }

    private static ElementType getElementType(IJavaClassType elementClass, String basePackage) throws NotTapestryElementException {
        String elementName;
        try {
            elementName = elementClass.getFullyQualifiedName().substring(basePackage.length() + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NotTapestryElementException(elementClass.getFullyQualifiedName() + " is not under a Tapestry base package.");
        }
        if (elementName.startsWith("components") || elementName.startsWith("base")) {
            return ElementType.COMPONENT;
        }
        if (elementName.startsWith("pages")) {
            return ElementType.PAGE;
        }
        if (elementName.startsWith("mixins")) {
            return ElementType.MIXIN;
        }
        throw new NotTapestryElementException(elementClass.getFullyQualifiedName() + " is not under a Tapestry base package.");
    }

    public static enum ElementType {
        PAGE,
        COMPONENT,
        MIXIN;

    }
}

