/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.xml.XmlAttribute;
import com.intellij.tapestry.core.resource.xml.XmlTag;
import com.intellij.tapestry.core.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedElement
implements Comparable {
    private transient IJavaField _field;
    private final transient PresentationLibraryElement _element;
    private XmlTag _tag;

    public InjectedElement(@NotNull IJavaField field, PresentationLibraryElement element) {
        if (field == null) {
            InjectedElement.$$$reportNull$$$0(0);
        }
        this._field = field;
        this._element = element;
    }

    public InjectedElement(@NotNull XmlTag tag, PresentationLibraryElement element) {
        if (tag == null) {
            InjectedElement.$$$reportNull$$$0(1);
        }
        this._tag = tag;
        this._element = element;
    }

    public IJavaField getField() {
        return this._field;
    }

    public XmlTag getTag() {
        return this._tag;
    }

    public PresentationLibraryElement getElement() {
        return this._element;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters;
        block3: {
            String[] componentParameters;
            IJavaAnnotation componentAnnotation;
            block2: {
                parameters = new HashMap<String, String>();
                if (this._tag == null) break block2;
                for (XmlAttribute attribute : this._tag.getAttributes()) {
                    parameters.put(attribute.getLocalName(), attribute.getValue());
                }
                break block3;
            }
            if (this._field == null || (componentAnnotation = this._field.getAnnotations().get("org.apache.tapestry5.annotations.Component")) == null || (componentParameters = componentAnnotation.getParameters().get("parameters")) == null) break block3;
            for (String parameter : componentParameters) {
                if (parameter.split("=").length != 2) continue;
                parameters.put(parameter.split("=")[0], parameter.split("=")[1]);
            }
        }
        return parameters;
    }

    @Nullable
    public String getElementId() {
        if (this._element == null || this._field == null && this._tag == null) {
            return null;
        }
        if (this._field != null && this._element instanceof Component) {
            return this.getFieldId();
        }
        if (this._tag != null) {
            if (this._element instanceof Component && this.getParameters() != null && this.getParameters().containsKey("id")) {
                return this.getParameters().get("id");
            }
            if (!this._tag.getLocalName().toUpperCase().equals(this._element.getName().toUpperCase())) {
                return this.getElement().getName();
            }
            return this._tag.getLocalName();
        }
        return null;
    }

    public int compareTo(Object o) {
        return this.compareByIds(o);
    }

    private int compareByIds(Object o) {
        return InjectedElement.compareIds(this.getElementId(), ((InjectedElement)o).getElementId());
    }

    private static int compareIds(String id, String otherId) {
        if (id != null && otherId != null) {
            return id.compareTo(otherId);
        }
        if (id == null && otherId == null) {
            return 0;
        }
        return id == null ? -1 : 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof InjectedElement && this.compareByIds(obj) == 0 && this.getElement().getName().equals(((InjectedElement)obj).getElement().getName());
    }

    public int hashCode() {
        String id = this.getElementId();
        return id == null ? 0 : id.hashCode();
    }

    private String getFieldId() {
        IJavaAnnotation componentAnnotation = this._field.getAnnotations().get("org.apache.tapestry5.annotations.Component");
        if (componentAnnotation != null) {
            String[] values = componentAnnotation.getParameters().get("id");
            if (values != null && values.length > 0) {
                return values[0];
            }
            return ClassUtils.getName(this._field.getName());
        }
        return ClassUtils.getName(this._field.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "field";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
        }
        objectArray[1] = "com/intellij/tapestry/core/model/presentation/InjectedElement";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

