/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.externalizable.totemplatechain;

import com.intellij.tapestry.core.model.externalizable.totemplatechain.ToTemplateExternalizer;
import com.intellij.tapestry.core.model.presentation.Page;
import org.apache.commons.chain.Context;

public class PageExternalizer
extends ToTemplateExternalizer {
    @Override
    public boolean execute(Context context) throws Exception {
        if (!super.execute(context)) {
            return false;
        }
        if (!(this.getContext().getElement() instanceof Page)) {
            return false;
        }
        Page page = (Page)this.getContext().getElement();
        if (page.getElementClass().getFile() == null) {
            throw new RuntimeException("The page is invalid!!");
        }
        String pageName = page.getLibrary().getId().equals("application") || page.getLibrary().getId().equals("core") ? page.getName() : page.getLibrary().getId() + "/" + page.getName();
        StringBuilder serialized = new StringBuilder();
        serialized.append("<").append(this.getContext().getNamespacePrefix()).append(":pagelink");
        serialized.append(" page=\"").append(pageName).append("\">");
        serialized.append("Link to ").append(pageName);
        serialized.append("</").append(this.getContext().getNamespacePrefix()).append(":pagelink>");
        this.getContext().setResult(serialized.toString());
        return true;
    }
}

