/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.java.coercion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.AssignableToAll;
import com.intellij.tapestry.core.java.IJavaType;
import com.intellij.tapestry.core.java.coercion.CoercionContext;
import com.intellij.tapestry.core.java.coercion.EnumTypeCoercionValidator;
import com.intellij.tapestry.core.java.coercion.JavaArrayTypeCoercionValidator;
import com.intellij.tapestry.core.java.coercion.JavaClassTypeCoercionValidator;
import com.intellij.tapestry.core.java.coercion.JavaPrimitiveTypeCoercionValidator;
import org.apache.commons.chain.Chain;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ChainBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeCoercionValidator {
    private static final Logger _logger = Logger.getInstance(TypeCoercionValidator.class);
    private static final Chain _chain = new ChainBase();

    public static boolean canCoerce(@NotNull TapestryProject project, @NotNull IJavaType sourceType, @Nullable String sourceValue, @Nullable IJavaType targetType) {
        if (project == null) {
            TypeCoercionValidator.$$$reportNull$$$0(0);
        }
        if (sourceType == null) {
            TypeCoercionValidator.$$$reportNull$$$0(1);
        }
        if (targetType == null) {
            return false;
        }
        if (sourceType instanceof AssignableToAll || targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        CoercionContext context = new CoercionContext(project, sourceType, sourceValue, targetType);
        try {
            if (!_chain.execute((Context)context)) {
                return false;
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception ex) {
            _logger.error((Throwable)ex);
            return false;
        }
        return context.canCoerce();
    }

    static {
        _chain.addCommand((Command)new JavaClassTypeCoercionValidator());
        _chain.addCommand((Command)new JavaArrayTypeCoercionValidator());
        _chain.addCommand((Command)new JavaPrimitiveTypeCoercionValidator());
        _chain.addCommand((Command)new EnumTypeCoercionValidator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceType";
                break;
            }
        }
        objectArray[1] = "com/intellij/tapestry/core/java/coercion/TypeCoercionValidator";
        objectArray[2] = "canCoerce";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

