/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.util.CachedUserDataCache;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

abstract class ElementsCachedMap
extends CachedUserDataCache<Map<String, PresentationLibraryElement>, Module> {
    private final boolean myCacheComponents;
    private final boolean myCachePages;
    private final boolean myCacheMixin;
    private final boolean myCacheAbstractComponents;

    ElementsCachedMap(@NonNls String keyName, boolean cacheComponents, boolean cachePages, boolean cacheMixin) {
        this(keyName, cacheComponents, cachePages, cacheMixin, false);
    }

    ElementsCachedMap(@NonNls String keyName, boolean cacheComponents, boolean cachePages, boolean cacheMixin, boolean cacheAbstractComponents) {
        super(keyName);
        this.myCacheComponents = cacheComponents;
        this.myCachePages = cachePages;
        this.myCacheMixin = cacheMixin;
        this.myCacheAbstractComponents = cacheAbstractComponents;
        assert (this.myCachePages || this.myCacheComponents || this.myCacheMixin || this.myCacheAbstractComponents);
    }

    @Override
    protected Map<String, PresentationLibraryElement> computeValue(Module module) {
        THashMap map = new THashMap();
        TapestryProject project = TapestryModuleSupportLoader.getTapestryProject(module);
        assert (project != null);
        for (Library library : project.getLibraries()) {
            if (this.myCacheComponents) {
                this.computeKeyAndAddAll((Map<String, PresentationLibraryElement>)map, library.getComponents().values(), library.getShortName());
            }
            if (this.myCacheAbstractComponents) {
                this.computeKeyAndAddAll((Map<String, PresentationLibraryElement>)map, library.getAbstractComponents().values(), library.getShortName());
            }
            if (this.myCachePages) {
                this.computeKeyAndAddAll((Map<String, PresentationLibraryElement>)map, library.getPages().values(), library.getShortName());
            }
            if (!this.myCacheMixin) continue;
            this.computeKeyAndAddAll((Map<String, PresentationLibraryElement>)map, library.getMixins().values(), library.getShortName());
        }
        if (this.myCacheComponents) {
            this.computeKeyAndAddAll((Map<String, PresentationLibraryElement>)map, project.getBuiltinComponents(), null);
        }
        if (this.myCachePages) {
            this.computeKeyAndAddAll((Map<String, PresentationLibraryElement>)map, project.getBuiltinPages(), null);
        }
        return map;
    }

    @Override
    protected Object[] getDependencies(Module module) {
        return TapestryProject.JAVA_STRUCTURE_DEPENDENCY;
    }

    @Override
    protected Project getProject(Module projectOwner) {
        return projectOwner.getProject();
    }

    private void computeKeyAndAddAll(Map<String, PresentationLibraryElement> map, Collection<PresentationLibraryElement> elements, @Nullable String name) {
        for (PresentationLibraryElement element : elements) {
            String key = element == null ? null : this.computeKey(element);
            if (key == null) continue;
            if (!StringUtil.isEmpty((String)name)) {
                key = name + "/" + key;
            }
            map.put(key, element);
        }
    }

    @Nullable
    protected abstract String computeKey(PresentationLibraryElement var1);
}

